/*
 * Decompiled with CFR 0.152.
 */
package de.lolhens.http4s.jwt;

import cats.ApplicativeError;
import cats.Functor;
import cats.MonadError;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import de.lolhens.http4s.jwt.Jwt;
import de.lolhens.http4s.jwt.Jwt$;
import de.lolhens.http4s.jwt.JwtCodec$;
import io.circe.Json;
import io.circe.jawn.package$;
import java.io.Serializable;
import java.time.Clock;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtBase64$;
import pdi.jwt.JwtCirceParser;
import pdi.jwt.JwtClaim;
import pdi.jwt.JwtCore;
import pdi.jwt.JwtHeader;
import pdi.jwt.JwtOptions;
import pdi.jwt.JwtUtils$;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import pdi.jwt.algorithms.JwtHmacAlgorithm;
import pdi.jwt.exceptions.JwtEmptyAlgorithmException;
import pdi.jwt.exceptions.JwtEmptySignatureException;
import pdi.jwt.exceptions.JwtLengthException;
import pdi.jwt.exceptions.JwtValidationException;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.Tuple5;
import scala.Tuple5$;
import scala.collection.immutable.Seq;
import scala.util.Either;
import scala.util.Failure$;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;

public class JwtCodec
implements JwtCirceParser<JwtHeader, JwtClaim> {
    private final Clock clock;

    public static JwtCodec apply(Clock clock) {
        return JwtCodec$.MODULE$.apply(clock);
    }

    public JwtCodec(Clock clock) {
        this.clock = clock;
    }

    public Clock clock() {
        return this.clock;
    }

    public JwtHeader parseHeader(String header) {
        return JwtCodec$.MODULE$.de$lolhens$http4s$jwt$JwtCodec$$$parseHeaderHelp(header, this.clock());
    }

    public JwtClaim parseClaim(String claim) {
        return JwtCodec$.MODULE$.de$lolhens$http4s$jwt$JwtCodec$$$parseClaimHelp(claim, this.clock());
    }

    public Json parse(String value) {
        return (Json)package$.MODULE$.parse(value).toTry((.less.colon.less)$less$colon$less$.MODULE$.refl()).get();
    }

    public boolean validateHmacAlgorithm(JwtHmacAlgorithm algorithm, Seq<JwtHmacAlgorithm> algorithms) {
        return JwtCore.validateHmacAlgorithm$((JwtCore)this, (JwtHmacAlgorithm)algorithm, algorithms);
    }

    public boolean validateAsymmetricAlgorithm(JwtAsymmetricAlgorithm algorithm, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return JwtCore.validateAsymmetricAlgorithm$((JwtCore)this, (JwtAsymmetricAlgorithm)algorithm, algorithms);
    }

    public Tuple5<String, String, String, String, String> splitToken(String token) {
        String string;
        String[] parts = token.split("\\.");
        int n = parts.length;
        if (2 == n) {
            string = "";
        } else if (3 == n) {
            string = parts[2];
        } else {
            throw new JwtLengthException(new StringBuilder(67).append("Expected token [").append(token).append("] to be composed of 2 or 3 parts separated by dots.").toString());
        }
        String signature = string;
        return Tuple5$.MODULE$.apply((Object)parts[0], (Object)JwtBase64$.MODULE$.decodeString(parts[0]), (Object)parts[1], (Object)JwtBase64$.MODULE$.decodeString(parts[1]), (Object)signature);
    }

    public <F, A> Object decodeAllAndVerify(String token, JwtOptions options, Function1<Jwt<JwtAlgorithm>, Object> verify, MonadError<F, Throwable> F) {
        Try verified = Try$.MODULE$.apply(() -> this.$anonfun$1(token, options, verify, F));
        return verified.fold((Function1 & Serializable)e -> F.pure((Object)Failure$.MODULE$.apply(e)), (Function1 & Serializable)x -> Predef$.MODULE$.identity(x));
    }

    private final Object $anonfun$1(String token$1, JwtOptions options$1, Function1 verify$1, MonadError F$1) {
        Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token$1);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        String header64 = (String)tuple5._1();
        String header = (String)tuple5._2();
        String claim64 = (String)tuple5._3();
        String claim = (String)tuple5._4();
        String signature64 = (String)tuple5._5();
        Tuple5 tuple52 = Tuple5$.MODULE$.apply((Object)header64, (Object)header, (Object)claim64, (Object)claim, (Object)signature64);
        String header642 = (String)tuple52._1();
        String header2 = (String)tuple52._2();
        String claim642 = (String)tuple52._3();
        String claim2 = (String)tuple52._4();
        String signature642 = (String)tuple52._5();
        JwtHeader h = this.parseHeader(header2);
        JwtClaim c = this.parseClaim(claim2);
        byte[] data = JwtUtils$.MODULE$.bytify(new StringBuilder(1).append(header642).append(".").append(claim642).toString());
        byte[] signature = JwtBase64$.MODULE$.decode(signature642);
        Jwt jwt = Jwt$.MODULE$.apply(h, c, data, signature);
        if (options$1.signature()) {
            Option maybeAlgo = this.extractAlgorithm(h);
            if (options$1.signature() && signature642.isEmpty()) {
                throw new JwtEmptySignatureException();
            }
            if (maybeAlgo.isEmpty()) {
                throw new JwtEmptyAlgorithmException();
            }
            Object object = package.applicativeError$.MODULE$.catsSyntaxApplicativeError(verify$1.apply(jwt), (ApplicativeError)F$1);
            return package.functor$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, (ApplicativeError)F$1), (Functor)F$1).map((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Throwable error = (Throwable)((Left)either).value();
                    return Failure$.MODULE$.apply(error);
                }
                if (either instanceof Right) {
                    Option option = (Option)((Right)either).value();
                    if (None$.MODULE$.equals(option)) {
                        return Failure$.MODULE$.apply((Throwable)new JwtValidationException("Invalid signature for this token or wrong algorithm."));
                    }
                    if (option instanceof Some) {
                        Object verified = ((Some)option).value();
                        return this.validateTiming(c, options$1).map((Function1 & Serializable)_$2 -> Tuple2$.MODULE$.apply((Object)jwt, (Object)Some$.MODULE$.apply(verified)));
                    }
                }
                throw new MatchError((Object)either);
            });
        }
        return F$1.pure((Object)Success$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(jwt, (Object)None$.MODULE$)));
    }
}

