/*
 * Decompiled with CFR 0.152.
 */
package de.lemona.gradle.plugins;

import de.lemona.gradle.plugins.Utilities;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.Project;

public class Version {
    private final int major;
    private final int minor;
    private final int build;

    public Version(int major, int minor, int build) {
        if (major < 0 || major > 127) {
            throw new GradleException("Major version \"" + major + "\" must be between 0 and 127");
        }
        if (minor < 0 || minor > 255) {
            throw new GradleException("Minor version \"" + minor + "\" must be between 0 and 255");
        }
        if (build < -1 || build > 65533) {
            throw new GradleException("Build number \"" + minor + "\" must be between 0 and 65533");
        }
        this.major = major;
        this.minor = minor;
        this.build = build;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getBuild() {
        return this.build;
    }

    public int getVersionCode() {
        if (this.build < 0) {
            return 1;
        }
        return 2 + (this.major << 24 & 0x7F000000 | this.minor << 16 & 0xFF0000 | this.build & 0xFFFF);
    }

    public boolean getIsSnapshot() {
        return this.build < 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.major).append('.').append(this.minor);
        if (this.build < 0) {
            builder.append("-SNAPSHOT");
        } else {
            builder.append('.').append(this.build);
        }
        return builder.toString();
    }

    public static Version setup(Project project) {
        if (project.getVersion() == null || "unspecified".equals(project.getVersion())) {
            Version version = new Version(0, 0, -1);
            project.setVersion((Object)version);
            return version;
        }
        if (project.getVersion() instanceof Version) {
            return (Version)project.getVersion();
        }
        String projectVersion = project.getVersion().toString();
        Matcher versionMatcher = Pattern.compile("(\\d+)\\.(\\d+)").matcher(projectVersion);
        if (!versionMatcher.matches()) {
            throw new GradleException("Invalid project version \"" + projectVersion + "\"");
        }
        String buildNumber = Utilities.resolveValue(project, "buildNumber", "BUILD_NUMBER", "-1").toString();
        if (!buildNumber.matches("-?\\d+")) {
            throw new GradleException("Invalid build number \"" + buildNumber + "\"");
        }
        int major = Integer.parseInt(versionMatcher.group(1));
        int minor = Integer.parseInt(versionMatcher.group(2));
        int build = Integer.parseInt(buildNumber);
        Version version = new Version(major, minor, build);
        project.setVersion((Object)version);
        return version;
    }
}

