/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracles;

import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.statistics.Counter;
import de.learnlib.statistics.StatisticOracle;
import java.util.Collection;
import net.automatalib.words.Word;

public class CounterOracle<I, O>
implements StatisticOracle<I, O> {
    private final Counter counter;
    private MembershipOracle<I, O> nextOracle;

    public CounterOracle(MembershipOracle<I, O> nextOracle, String name) {
        this.nextOracle = nextOracle;
        this.counter = new Counter(name, "queries");
    }

    @Override
    public void processQueries(Collection<? extends Query<I, O>> queries) {
        this.counter.increment(queries.size());
        this.nextOracle.processQueries(queries);
    }

    @Override
    public Counter getStatisticalData() {
        return this.counter;
    }

    @Override
    public void setNext(MembershipOracle<I, O> next) {
        this.nextOracle = next;
    }

    public static class MealyCounterOracle<I, O>
    extends CounterOracle<I, Word<O>>
    implements MembershipOracle.MealyMembershipOracle<I, O> {
        public MealyCounterOracle(MembershipOracle<I, Word<O>> nextOracle, String name) {
            super(nextOracle, name);
        }
    }

    public static class DFACounterOracle<I>
    extends CounterOracle<I, Boolean>
    implements MembershipOracle.DFAMembershipOracle<I> {
        public DFACounterOracle(MembershipOracle<I, Boolean> nextOracle, String name) {
            super(nextOracle, name);
        }
    }
}

