/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracles;

import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.api.SUL;
import java.util.Collection;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class SULOracle<I, O>
implements MembershipOracle<I, Word<O>> {
    private final SUL<I, O> sul;

    public SULOracle(SUL<I, O> sul) {
        this.sul = sul;
    }

    @Override
    public void processQueries(Collection<? extends Query<I, Word<O>>> queries) {
        for (Query<I, Word<O>> query : queries) {
            this.answerQuery(query);
        }
    }

    private void answerQuery(Query<I, Word<O>> query) {
        this.sul.reset();
        for (Object sym : query.getPrefix()) {
            this.sul.step(sym);
        }
        Word<I> suffix = query.getSuffix();
        WordBuilder wb = new WordBuilder(suffix.length());
        for (Object sym : suffix) {
            wb.add(this.sul.step(sym));
        }
        query.answer((Word<Word>)wb.toWord());
    }
}

