/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracles;

import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.api.QueryAnswerer;
import de.learnlib.oracles.DefaultQuery;
import de.learnlib.settings.LearnLibSettings;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public abstract class MQUtil {
    public static int PARALLEL_THRESHOLD = -1;

    @Deprecated
    @Nullable
    public static <I, D> D output(MembershipOracle<I, D> oracle, Word<I> queryWord) {
        return oracle.answerQuery(queryWord);
    }

    @Deprecated
    @Nullable
    public static <I, D> D output(MembershipOracle<I, D> oracle, Word<I> prefix, Word<I> suffix) {
        return oracle.answerQuery(prefix, suffix);
    }

    @Nonnull
    public static <I, D> DefaultQuery<I, D> query(MembershipOracle<I, D> oracle, Word<I> prefix, Word<I> suffix) {
        DefaultQuery<I, Word<I>> qry = new DefaultQuery<I, Word<I>>(prefix, suffix);
        oracle.processQuery(qry);
        return qry;
    }

    public static <I, D> DefaultQuery<I, D> normalize(MembershipOracle<I, D> oracle, DefaultQuery<I, D> query) {
        if (query.isNormalized()) {
            return query;
        }
        return MQUtil.query(oracle, Word.epsilon(), query.getInput());
    }

    @Nonnull
    public static <I, D> DefaultQuery<I, D> query(MembershipOracle<I, D> oracle, Word<I> queryWord) {
        return MQUtil.query(oracle, Word.epsilon(), queryWord);
    }

    public static <I, D> void answerQueries(QueryAnswerer<I, D> answerer, Collection<? extends Query<I, D>> queries) {
        for (Query<I, D> query : queries) {
            Word<I> prefix = query.getPrefix();
            Word<I> suffix = query.getSuffix();
            D answer = answerer.answerQuery(prefix, suffix);
            query.answer(answer);
        }
    }

    public static <I, D> void answerQueriesParallel(QueryAnswerer<I, D> answerer, Collection<? extends Query<I, D>> queries) {
        queries.parallelStream().forEach(q -> {
            Word prefix = q.getPrefix();
            Word suffix = q.getSuffix();
            Object answer = answerer.answerQuery(prefix, suffix);
            q.answer(answer);
        });
    }

    public static <I, D> void answerQueriesAuto(QueryAnswerer<I, D> answerer, Collection<? extends Query<I, D>> queries) {
        if (PARALLEL_THRESHOLD < 0 || queries.size() < PARALLEL_THRESHOLD) {
            MQUtil.answerQueries(answerer, queries);
        } else {
            MQUtil.answerQueriesParallel(answerer, queries);
        }
    }

    public static <I, D> boolean isCounterexample(DefaultQuery<I, D> query, SuffixOutput<I, D> hyp) {
        Object hypOut;
        D qryOut = query.getOutput();
        return !Objects.equals(qryOut, hypOut = hyp.computeSuffixOutput(query.getPrefix(), query.getSuffix()));
    }

    static {
        LearnLibSettings settings = LearnLibSettings.getInstance();
        PARALLEL_THRESHOLD = settings.getInt("queries.parallel.threshold", -1);
    }
}

