/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.settings;

import de.learnlib.settings.LearnLibSettingsSource;
import java.util.Properties;
import java.util.logging.Logger;
import net.automatalib.commons.util.settings.SettingsSource;

public class LearnLibSettings {
    private static final Logger LOG = Logger.getLogger(LearnLibSettings.class.getName());
    private static final LearnLibSettings INSTANCE = new LearnLibSettings();
    private final Properties properties = SettingsSource.readSettings(LearnLibSettingsSource.class);

    public static LearnLibSettings getInstance() {
        return INSTANCE;
    }

    private LearnLibSettings() {
    }

    public String getProperty(String propName) {
        return this.properties.getProperty("learnlib." + propName);
    }

    public String getProperty(String propName, String defaultValue) {
        return this.properties.getProperty("learnlib." + propName, defaultValue);
    }

    public <E extends Enum<E>> E getEnumValue(String propName, Class<E> enumClazz) {
        String prop = this.getProperty(propName);
        if (prop == null) {
            return null;
        }
        return Enum.valueOf(enumClazz, prop.toUpperCase());
    }

    public <E extends Enum<E>> E getEnumValue(String propName, Class<E> enumClazz, E defaultValue) {
        E value = this.getEnumValue(propName, enumClazz);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public boolean getBool(String propName, boolean defaultValue) {
        Boolean b = this.getBoolean(propName);
        if (b != null) {
            return b;
        }
        return defaultValue;
    }

    public Boolean getBoolean(String propName) {
        String prop = this.getProperty(propName);
        if (prop != null) {
            return Boolean.parseBoolean(prop);
        }
        return null;
    }

    public int getInt(String propName, int defaultValue) {
        Integer prop = this.getInteger(propName);
        if (prop != null) {
            return prop;
        }
        return defaultValue;
    }

    public Integer getInteger(String propName) {
        String prop = this.getProperty(propName);
        if (prop != null) {
            try {
                int val = Integer.parseInt(prop);
                return val;
            }
            catch (NumberFormatException ex) {
                LOG.warning("Could not parse LearnLib integer property '" + propName + "': " + ex.getMessage());
            }
        }
        return null;
    }
}

