/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.passive.api;

import de.learnlib.oracles.DefaultQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.automatalib.words.Word;

public interface PassiveLearningAlgorithm<M, I, D> {
    public void addSamples(Collection<? extends DefaultQuery<I, D>> var1);

    default public void addSamples(DefaultQuery<I, D> ... samples) {
        this.addSamples(Arrays.asList(samples));
    }

    default public void addSample(DefaultQuery<I, D> sample) {
        this.addSamples(Collections.singleton(sample));
    }

    default public void addSample(Word<I> input, D output) {
        this.addSample(new DefaultQuery<I, D>(input, output));
    }

    default public void addSamples(D output, Collection<? extends Word<I>> words) {
        ArrayList<DefaultQuery<I, D>> queries = new ArrayList<DefaultQuery<I, D>>(words.size());
        for (Word<I> word : words) {
            queries.add(new DefaultQuery<I, D>(word, output));
        }
    }

    default public void addSamples(D output, Word<I> ... words) {
        this.addSamples(output, Arrays.asList(words));
    }

    public M computeModel();
}

