/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.nfa;

import de.learnlib.api.LearningAlgorithm;
import de.learnlib.oracles.DefaultQuery;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.fsa.NFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.util.automata.fsa.NFAs;
import net.automatalib.words.Alphabet;

@ParametersAreNonnullByDefault
public class NFALearnerWrapper<I>
implements LearningAlgorithm.DFALearner<I> {
    @Nonnull
    private final Alphabet<I> alphabet;
    @Nonnull
    private final LearningAlgorithm<? extends NFA<?, I>, I, Boolean> nfaLearner;

    public NFALearnerWrapper(Alphabet<I> alphabet, LearningAlgorithm<? extends NFA<?, I>, I, Boolean> nfaLearner) {
        this.alphabet = alphabet;
        this.nfaLearner = nfaLearner;
    }

    @Override
    public void startLearning() {
        this.nfaLearner.startLearning();
    }

    @Override
    public boolean refineHypothesis(DefaultQuery<I, Boolean> ceQuery) {
        return this.nfaLearner.refineHypothesis(ceQuery);
    }

    @Override
    public CompactDFA<I> getHypothesisModel() {
        NFA<?, I> nfaHyp = this.nfaLearner.getHypothesisModel();
        CompactDFA dfaHyp = NFAs.determinize(nfaHyp, this.alphabet);
        return dfaHyp;
    }

    public String toString() {
        return this.nfaLearner.toString();
    }
}

