/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.experiments;

import de.learnlib.api.EquivalenceOracle;
import de.learnlib.api.LearningAlgorithm;
import de.learnlib.logging.LearnLogger;
import de.learnlib.oracles.DefaultQuery;
import de.learnlib.statistics.Counter;
import de.learnlib.statistics.SimpleProfiler;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public class Experiment<A> {
    private static LearnLogger logger = LearnLogger.getLogger(Experiment.class);
    private boolean logModels = false;
    private boolean profile = false;
    private Counter rounds = new Counter("rounds", "#");
    private A finalHypothesis = null;
    private final ExperimentImpl<?, ?> impl;

    public <I, D> Experiment(LearningAlgorithm<? extends A, I, D> learningAlgorithm, EquivalenceOracle<? super A, I, D> equivalenceAlgorithm, Alphabet<I> inputs) {
        this.impl = new ExperimentImpl<I, D>(learningAlgorithm, equivalenceAlgorithm, inputs);
    }

    @Nonnull
    public A run() {
        this.finalHypothesis = this.impl.run();
        return this.finalHypothesis;
    }

    @Nonnull
    public A getFinalHypothesis() {
        if (this.finalHypothesis == null) {
            throw new IllegalStateException("Experiment has not yet been run");
        }
        return this.finalHypothesis;
    }

    private void profileStart(String taskname) {
        if (this.profile) {
            SimpleProfiler.start(taskname);
        }
    }

    private void profileStop(String taskname) {
        if (this.profile) {
            SimpleProfiler.stop(taskname);
        }
    }

    public void setLogModels(boolean logModels) {
        this.logModels = logModels;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    @Nonnull
    public Counter getRounds() {
        return this.rounds;
    }

    private final class ExperimentImpl<I, D> {
        private final LearningAlgorithm<? extends A, I, D> learningAlgorithm;
        private final EquivalenceOracle<? super A, I, D> equivalenceAlgorithm;
        private final Alphabet<I> inputs;

        public ExperimentImpl(LearningAlgorithm<? extends A, I, D> learningAlgorithm, EquivalenceOracle<? super A, I, D> equivalenceAlgorithm, Alphabet<I> inputs) {
            this.learningAlgorithm = learningAlgorithm;
            this.equivalenceAlgorithm = equivalenceAlgorithm;
            this.inputs = inputs;
        }

        public A run() {
            Experiment.this.rounds.increment();
            logger.logPhase("Starting round " + Experiment.this.rounds.getCount());
            logger.logPhase("Learning");
            Experiment.this.profileStart("Learning");
            this.learningAlgorithm.startLearning();
            Experiment.this.profileStop("Learning");
            boolean done = false;
            Object hyp = null;
            while (!done) {
                hyp = this.learningAlgorithm.getHypothesisModel();
                if (Experiment.this.logModels) {
                    logger.logModel(hyp);
                }
                logger.logPhase("Searching for counterexample");
                Experiment.this.profileStart("Searching for counterexample");
                DefaultQuery<I, D> ce = this.equivalenceAlgorithm.findCounterExample(hyp, (Collection<I>)this.inputs);
                Experiment.this.profileStop("Searching for counterexample");
                if (ce == null) {
                    done = true;
                    continue;
                }
                logger.logCounterexample(ce.getInput().toString());
                Experiment.this.rounds.increment();
                logger.logPhase("Starting round " + Experiment.this.rounds.getCount());
                logger.logPhase("Learning");
                Experiment.this.profileStart("Learning");
                this.learningAlgorithm.refineHypothesis(ce);
                Experiment.this.profileStop("Learning");
            }
            return hyp;
        }
    }

    public static class MealyExperiment<I, O>
    extends Experiment<MealyMachine<?, I, ?, O>> {
        public MealyExperiment(LearningAlgorithm<? extends MealyMachine<?, I, ?, O>, I, Word<O>> learningAlgorithm, EquivalenceOracle<? super MealyMachine<?, I, ?, O>, I, Word<O>> equivalenceAlgorithm, Alphabet<I> inputs) {
            super(learningAlgorithm, equivalenceAlgorithm, inputs);
        }
    }

    public static class DFAExperiment<I>
    extends Experiment<DFA<?, I>> {
        public DFAExperiment(LearningAlgorithm<? extends DFA<?, I>, I, Boolean> learningAlgorithm, EquivalenceOracle<? super DFA<?, I>, I, Boolean> equivalenceAlgorithm, Alphabet<I> inputs) {
            super(learningAlgorithm, equivalenceAlgorithm, inputs);
        }
    }
}

