/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.statistics;

import de.learnlib.logging.LearnLogger;
import de.learnlib.statistics.Counter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SimpleProfiler {
    private static boolean PROFILE = true;
    private static final Map<String, Counter> cumulated = new HashMap<String, Counter>();
    private static final Map<String, Long> pending = new HashMap<String, Long>();
    private static LearnLogger logger = LearnLogger.getLogger(SimpleProfiler.class.getName());

    public static void reset() {
        cumulated.clear();
        pending.clear();
    }

    public static void start(String name) {
        if (!PROFILE) {
            return;
        }
        long start = System.currentTimeMillis();
        pending.put(name, start);
    }

    public static void stop(String name) {
        if (!PROFILE) {
            return;
        }
        Long start = pending.remove(name);
        if (start == null) {
            return;
        }
        long duration = System.currentTimeMillis() - start;
        Counter sum = cumulated.get(name);
        if (sum == null) {
            sum = new Counter(name, "ms");
        }
        sum.increment(duration);
        cumulated.put(name, sum);
    }

    @Nonnull
    public static String getResults() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Counter> e : cumulated.entrySet()) {
            sb.append(e.getValue().getSummary()).append(", (").append((double)e.getValue().getCount() / 1000.0).append(" s)").append(System.lineSeparator());
        }
        return sb.toString();
    }

    public static void logResults() {
        for (Map.Entry<String, Counter> e : cumulated.entrySet()) {
            logger.logProfilingInfo(e.getValue());
        }
    }
}

