/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracles;

import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.statistics.HistogramDataSet;
import de.learnlib.statistics.StatisticOracle;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class HistogramOracle<I, D>
implements StatisticOracle<I, D> {
    private final HistogramDataSet dataSet;
    private MembershipOracle<I, D> nextOracle;

    public HistogramOracle(MembershipOracle<I, D> next, String name) {
        this.nextOracle = next;
        this.dataSet = new HistogramDataSet(name, "query length");
    }

    @Override
    public final void processQueries(Collection<? extends Query<I, D>> queries) {
        for (Query<I, D> q : queries) {
            this.dataSet.addDataPoint(Long.valueOf(q.getInput().size()));
        }
        this.nextOracle.processQueries(queries);
    }

    @Override
    @Nonnull
    public final HistogramDataSet getStatisticalData() {
        return this.dataSet;
    }

    @Override
    public final void setNext(MembershipOracle<I, D> next) {
        this.nextOracle = next;
    }
}

