/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.mealy;

import de.learnlib.api.LearningAlgorithm;
import de.learnlib.mealy.MealyUtil;
import de.learnlib.oracles.DefaultQuery;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
final class MealyLearnerWrapper<M extends MealyMachine<?, I, ?, O>, I, O>
implements LearningAlgorithm<M, I, Word<O>> {
    private final LearningAlgorithm<M, I, O> learner;
    private M hypothesis = null;

    public MealyLearnerWrapper(LearningAlgorithm<M, I, O> learner) {
        this.learner = learner;
    }

    @Override
    public void startLearning() {
        this.learner.startLearning();
    }

    @Override
    public boolean refineHypothesis(DefaultQuery<I, Word<O>> ceQuery) {
        DefaultQuery<I, O> reducedQry;
        if (this.hypothesis == null) {
            this.hypothesis = (MealyMachine)this.learner.getHypothesisModel();
        }
        if ((reducedQry = MealyUtil.reduceCounterExample(this.hypothesis, ceQuery)) == null) {
            return false;
        }
        this.hypothesis = null;
        return this.learner.refineHypothesis(reducedQry);
    }

    @Override
    @Nonnull
    public M getHypothesisModel() {
        this.hypothesis = (MealyMachine)this.learner.getHypothesisModel();
        return this.hypothesis;
    }
}

