/*
 * Decompiled with CFR 0.152.
 */
package de.labathome.abscab;

public class CompleteEllipticIntegral {
    private static final double PI_2 = 1.5707963267948966;
    private static final double SQRT_EPS = Math.sqrt(Math.ulp(1.0));

    public static double cel(double k_c, double p, double a, double b) {
        double g;
        double f;
        if (k_c == 0.0) {
            if (b != 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            k_c = SQRT_EPS * SQRT_EPS;
        } else {
            k_c = Math.abs(k_c);
        }
        double m = 1.0;
        double e = k_c;
        if (p > 0.0) {
            p = Math.sqrt(p);
            b /= p;
        } else {
            f = k_c * k_c;
            double q = 1.0 - f;
            g = 1.0 - p;
            f -= p;
            q *= b - a * p;
            p = Math.sqrt(f / g);
            a = (a - b) / g;
            b = -q / (g * g * p) + a * p;
        }
        while (true) {
            f = a;
            a += b / p;
            g = e / p;
            b += f * g;
            b += b;
            p += g;
            g = m;
            m += k_c;
            if (!(Math.abs(g - k_c) > g * SQRT_EPS)) break;
            k_c = Math.sqrt(e);
            k_c += k_c;
            e = k_c * m;
        }
        return 1.5707963267948966 * (a * m + b) / (m * (m + p));
    }

    public static double ellipticK(double kSq) {
        return CompleteEllipticIntegral.cel(Math.sqrt(1.0 - kSq), 1.0, 1.0, 1.0);
    }

    public static double ellipticE(double kSq) {
        double kcSq = 1.0 - kSq;
        return CompleteEllipticIntegral.cel(Math.sqrt(kcSq), 1.0, 1.0, kcSq);
    }
}

