/*
 * Decompiled with CFR 0.152.
 */
package de.labathome.abscab;

import de.labathome.abscab.CompensatedSummation;
import de.labathome.abscab.CompleteEllipticIntegral;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import org.apache.commons.math3.util.FastMath;

public class ABSCAB {
    public static final double MU_0 = 1.25663706212E-6;
    private static final double MU_0_BY_PI = 4.000000002177503E-7;
    private static final double MU_0_BY_2_PI = 2.0000000010887514E-7;
    private static final double MU_0_BY_4_PI = 1.0000000005443757E-7;

    public static double[][] vectorPotentialPolygonFilament(double[][] vertices, double current, double[][] evalPos) {
        int numProcessors = Runtime.getRuntime().availableProcessors();
        return ABSCAB.vectorPotentialPolygonFilament(vertices, current, evalPos, numProcessors);
    }

    public static double[][] vectorPotentialPolygonFilament(int numVertices, IntFunction<double[]> vertexSupplier, double current, double[][] evalPos) {
        int numProcessors = Runtime.getRuntime().availableProcessors();
        return ABSCAB.vectorPotentialPolygonFilament(numVertices, vertexSupplier, current, evalPos, numProcessors);
    }

    public static double[][] magneticFieldPolygonFilament(double[][] vertices, double current, double[][] evalPos) {
        int numProcessors = Runtime.getRuntime().availableProcessors();
        return ABSCAB.magneticFieldPolygonFilament(vertices, current, evalPos, numProcessors);
    }

    public static double[][] magneticFieldPolygonFilament(int numVertices, IntFunction<double[]> vertexSupplier, double current, double[][] evalPos) {
        int numProcessors = Runtime.getRuntime().availableProcessors();
        return ABSCAB.magneticFieldPolygonFilament(numVertices, vertexSupplier, current, evalPos, numProcessors);
    }

    public static double[][] vectorPotentialPolygonFilament(double[][] vertices, double current, double[][] evalPos, int numProcessors) {
        boolean useCompensatedSummation = true;
        return ABSCAB.vectorPotentialPolygonFilament(vertices, current, evalPos, numProcessors, useCompensatedSummation);
    }

    public static double[][] vectorPotentialPolygonFilament(int numVertices, IntFunction<double[]> vertexSupplier, double current, double[][] evalPos, int numProcessors) {
        boolean useCompensatedSummation = true;
        return ABSCAB.vectorPotentialPolygonFilament(numVertices, vertexSupplier, current, evalPos, numProcessors, useCompensatedSummation);
    }

    public static double[][] magneticFieldPolygonFilament(double[][] vertices, double current, double[][] evalPos, int numProcessors) {
        boolean useCompensatedSummation = true;
        return ABSCAB.magneticFieldPolygonFilament(vertices, current, evalPos, numProcessors, useCompensatedSummation);
    }

    public static double[][] magneticFieldPolygonFilament(int numVertices, IntFunction<double[]> vertexSupplier, double current, double[][] evalPos, int numProcessors) {
        boolean useCompensatedSummation = true;
        return ABSCAB.magneticFieldPolygonFilament(numVertices, vertexSupplier, current, evalPos, numProcessors, useCompensatedSummation);
    }

    public static double[][] vectorPotentialPolygonFilament(double[][] vertices, double current, double[][] evalPos, int numProcessors, boolean useCompensatedSummation) {
        int numEvalPos = ABSCAB.validateCartesianVectorInput(evalPos);
        double[][] vectorPotential = new double[3][numEvalPos];
        ABSCAB.vectorPotentialPolygonFilament(vertices, current, evalPos, vectorPotential, numProcessors, useCompensatedSummation);
        return vectorPotential;
    }

    public static double[][] vectorPotentialPolygonFilament(int numVertices, IntFunction<double[]> vertexSupplier, double current, double[][] evalPos, int numProcessors, boolean useCompensatedSummation) {
        int numEvalPos = ABSCAB.validateCartesianVectorInput(evalPos);
        double[][] vectorPotential = new double[3][numEvalPos];
        ABSCAB.vectorPotentialPolygonFilament(numVertices, vertexSupplier, current, evalPos, vectorPotential, numProcessors, useCompensatedSummation);
        return vectorPotential;
    }

    public static double[][] magneticFieldPolygonFilament(double[][] vertices, double current, double[][] evalPos, int numProcessors, boolean useCompensatedSummation) {
        int numEvalPos = ABSCAB.validateCartesianVectorInput(evalPos);
        double[][] magneticField = new double[3][numEvalPos];
        ABSCAB.magneticFieldPolygonFilament(vertices, current, evalPos, magneticField, numProcessors, useCompensatedSummation);
        return magneticField;
    }

    public static double[][] magneticFieldPolygonFilament(int numVertices, IntFunction<double[]> vertexSupplier, double current, double[][] evalPos, int numProcessors, boolean useCompensatedSummation) {
        int numEvalPos = ABSCAB.validateCartesianVectorInput(evalPos);
        double[][] magneticField = new double[3][numEvalPos];
        ABSCAB.magneticFieldPolygonFilament(numVertices, vertexSupplier, current, evalPos, magneticField, numProcessors, useCompensatedSummation);
        return magneticField;
    }

    public static void vectorPotentialPolygonFilament(final double[][] vertices, final double current, final double[][] evalPos, double[][] vectorPotential, int numProcessors, final boolean useCompensatedSummation) {
        int numVertices = ABSCAB.validateCartesianVectorInput(vertices);
        if (numVertices < 2) {
            throw new RuntimeException("need at least 2 vertices, but only got " + numVertices);
        }
        int numEvalPos = ABSCAB.validateCartesianVectorInput(evalPos);
        if (numProcessors < 1) {
            throw new RuntimeException("need at least 1 processor, but only got " + numProcessors);
        }
        if (current == 0.0) {
            return;
        }
        if (numProcessors == 1) {
            boolean idxSourceStart = false;
            int idxSourceEnd = numVertices - 1;
            boolean idxEvalStart = false;
            int idxEvalEnd = numEvalPos;
            ABSCAB.kernelVectorPotentialPolygonFilament(vertices, current, evalPos, vectorPotential, 0, idxSourceEnd, 0, idxEvalEnd, useCompensatedSummation);
        } else if (numVertices - 1 > numEvalPos) {
            int nSourceRemainder;
            int nSourcePerThread;
            int nThreads;
            if (numVertices - 1 < numProcessors) {
                nThreads = numVertices - 1;
                nSourcePerThread = 1;
                nSourceRemainder = 0;
            } else {
                nThreads = numProcessors;
                nSourcePerThread = (numVertices - 1) / nThreads;
                nSourceRemainder = (numVertices - 1) % nThreads;
            }
            boolean idxEvalStart = false;
            final int idxEvalEnd = numEvalPos;
            final double[][][] vectorPotentialContributions = new double[nThreads][3][numEvalPos];
            ExecutorService service = Executors.newFixedThreadPool(nThreads);
            for (int idxThread = 0; idxThread < nThreads; ++idxThread) {
                int _idxSourceStart = idxThread * nSourcePerThread;
                int _idxSourceEnd = (idxThread + 1) * nSourcePerThread;
                if (idxThread < nSourceRemainder) {
                    _idxSourceStart += idxThread;
                    _idxSourceEnd += idxThread + 1;
                } else {
                    _idxSourceStart += nSourceRemainder;
                    _idxSourceEnd += nSourceRemainder;
                }
                final int idxSourceStart = _idxSourceStart;
                final int idxSourceEnd = _idxSourceEnd;
                service.submit(new Runnable(){
                    private int idxThread;

                    public Runnable init(int idxThread) {
                        this.idxThread = idxThread;
                        return this;
                    }

                    @Override
                    public void run() {
                        try {
                            ABSCAB.kernelVectorPotentialPolygonFilament(vertices, current, evalPos, vectorPotentialContributions[this.idxThread], idxSourceStart, idxSourceEnd, 0, idxEvalEnd, useCompensatedSummation);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }.init(idxThread));
            }
            service.shutdown();
            try {
                service.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (useCompensatedSummation) {
                for (int i = 0; i < numEvalPos; ++i) {
                    CompensatedSummation sumX = new CompensatedSummation();
                    CompensatedSummation sumY = new CompensatedSummation();
                    CompensatedSummation sumZ = new CompensatedSummation();
                    for (int idxThread = 0; idxThread < nThreads; ++idxThread) {
                        sumX.add(vectorPotentialContributions[idxThread][0][i]);
                        sumY.add(vectorPotentialContributions[idxThread][1][i]);
                        sumZ.add(vectorPotentialContributions[idxThread][2][i]);
                    }
                    vectorPotential[0][i] = sumX.getSum();
                    vectorPotential[1][i] = sumY.getSum();
                    vectorPotential[2][i] = sumZ.getSum();
                }
            } else {
                for (int idxThread = 0; idxThread < nThreads; ++idxThread) {
                    for (int i = 0; i < numEvalPos; ++i) {
                        double[] dArray = vectorPotential[0];
                        int n = i;
                        dArray[n] = dArray[n] + vectorPotentialContributions[idxThread][0][i];
                        double[] dArray2 = vectorPotential[1];
                        int n2 = i;
                        dArray2[n2] = dArray2[n2] + vectorPotentialContributions[idxThread][1][i];
                        double[] dArray3 = vectorPotential[2];
                        int n3 = i;
                        dArray3[n3] = dArray3[n3] + vectorPotentialContributions[idxThread][2][i];
                    }
                }
            }
        } else {
            int nEvalRemainder;
            int nEvalPerThread;
            int nThreads;
            boolean idxSourceStart = false;
            int idxSourceEnd = numVertices - 1;
            if (numEvalPos < numProcessors) {
                nThreads = numEvalPos;
                nEvalPerThread = 1;
                nEvalRemainder = 0;
            } else {
                nThreads = numProcessors;
                nEvalPerThread = numEvalPos / nThreads;
                nEvalRemainder = numEvalPos % nThreads;
            }
            ExecutorService service = Executors.newFixedThreadPool(nThreads);
            for (int idxThread = 0; idxThread < nThreads; ++idxThread) {
                int _idxEvalStart = idxThread * nEvalPerThread;
                int _idxEvalEnd = (idxThread + 1) * nEvalPerThread;
                if (idxThread < nEvalRemainder) {
                    _idxEvalStart += idxThread;
                    _idxEvalEnd += idxThread + 1;
                } else {
                    _idxEvalStart += nEvalRemainder;
                    _idxEvalEnd += nEvalRemainder;
                }
                int idxEvalStart = _idxEvalStart;
                int idxEvalEnd = _idxEvalEnd;
                service.submit(() -> {
                    try {
                        ABSCAB.kernelVectorPotentialPolygonFilament(vertices, current, evalPos, vectorPotential, 0, idxSourceEnd, idxEvalStart, idxEvalEnd, useCompensatedSummation);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            service.shutdown();
            try {
                service.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void vectorPotentialPolygonFilament(int numVertices, final IntFunction<double[]> vertexSupplier, final double current, final double[][] evalPos, double[][] vectorPotential, int numProcessors, final boolean useCompensatedSummation) {
        if (numVertices < 2) {
            throw new RuntimeException("need at least 2 vertices, but only got " + numVertices);
        }
        int numEvalPos = ABSCAB.validateCartesianVectorInput(evalPos);
        if (numProcessors < 1) {
            throw new RuntimeException("need at least 1 processor, but only got " + numProcessors);
        }
        if (current == 0.0) {
            return;
        }
        if (numProcessors == 1) {
            boolean idxSourceStart = false;
            int idxSourceEnd = numVertices - 1;
            boolean idxEvalStart = false;
            int idxEvalEnd = numEvalPos;
            ABSCAB.kernelVectorPotentialPolygonFilament(vertexSupplier, current, evalPos, vectorPotential, 0, idxSourceEnd, 0, idxEvalEnd, useCompensatedSummation);
        } else if (numVertices - 1 > numEvalPos) {
            int nSourceRemainder;
            int nSourcePerThread;
            int nThreads;
            if (numVertices - 1 < numProcessors) {
                nThreads = numVertices - 1;
                nSourcePerThread = 1;
                nSourceRemainder = 0;
            } else {
                nThreads = numProcessors;
                nSourcePerThread = (numVertices - 1) / nThreads;
                nSourceRemainder = (numVertices - 1) % nThreads;
            }
            boolean idxEvalStart = false;
            final int idxEvalEnd = numEvalPos;
            final double[][][] vectorPotentialContributions = new double[nThreads][3][numEvalPos];
            ExecutorService service = Executors.newFixedThreadPool(nThreads);
            for (int idxThread = 0; idxThread < nThreads; ++idxThread) {
                int _idxSourceStart = idxThread * nSourcePerThread;
                int _idxSourceEnd = (idxThread + 1) * nSourcePerThread;
                if (idxThread < nSourceRemainder) {
                    _idxSourceStart += idxThread;
                    _idxSourceEnd += idxThread + 1;
                } else {
                    _idxSourceStart += nSourceRemainder;
                    _idxSourceEnd += nSourceRemainder;
                }
                final int idxSourceStart = _idxSourceStart;
                final int idxSourceEnd = _idxSourceEnd;
                service.submit(new Runnable(){
                    private int idxThread;

                    public Runnable init(int idxThread) {
                        this.idxThread = idxThread;
                        return this;
                    }

                    @Override
                    public void run() {
                        try {
                            ABSCAB.kernelVectorPotentialPolygonFilament(vertexSupplier, current, evalPos, vectorPotentialContributions[this.idxThread], idxSourceStart, idxSourceEnd, 0, idxEvalEnd, useCompensatedSummation);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }.init(idxThread));
            }
            service.shutdown();
            try {
                service.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (useCompensatedSummation) {
                for (int i = 0; i < numEvalPos; ++i) {
                    CompensatedSummation sumX = new CompensatedSummation();
                    CompensatedSummation sumY = new CompensatedSummation();
                    CompensatedSummation sumZ = new CompensatedSummation();
                    for (int idxThread = 0; idxThread < nThreads; ++idxThread) {
                        sumX.add(vectorPotentialContributions[idxThread][0][i]);
                        sumY.add(vectorPotentialContributions[idxThread][1][i]);
                        sumZ.add(vectorPotentialContributions[idxThread][2][i]);
                    }
                    vectorPotential[0][i] = sumX.getSum();
                    vectorPotential[1][i] = sumY.getSum();
                    vectorPotential[2][i] = sumZ.getSum();
                }
            } else {
                for (int idxThread = 0; idxThread < nThreads; ++idxThread) {
                    for (int i = 0; i < numEvalPos; ++i) {
                        double[] dArray = vectorPotential[0];
                        int n = i;
                        dArray[n] = dArray[n] + vectorPotentialContributions[idxThread][0][i];
                        double[] dArray2 = vectorPotential[1];
                        int n2 = i;
                        dArray2[n2] = dArray2[n2] + vectorPotentialContributions[idxThread][1][i];
                        double[] dArray3 = vectorPotential[2];
                        int n3 = i;
                        dArray3[n3] = dArray3[n3] + vectorPotentialContributions[idxThread][2][i];
                    }
                }
            }
        } else {
            int nEvalRemainder;
            int nEvalPerThread;
            int nThreads;
            boolean idxSourceStart = false;
            int idxSourceEnd = numVertices - 1;
            if (numEvalPos < numProcessors) {
                nThreads = numEvalPos;
                nEvalPerThread = 1;
                nEvalRemainder = 0;
            } else {
                nThreads = numProcessors;
                nEvalPerThread = numEvalPos / nThreads;
                nEvalRemainder = numEvalPos % nThreads;
            }
            ExecutorService service = Executors.newFixedThreadPool(nThreads);
            for (int idxThread = 0; idxThread < nThreads; ++idxThread) {
                int _idxEvalStart = idxThread * nEvalPerThread;
                int _idxEvalEnd = (idxThread + 1) * nEvalPerThread;
                if (idxThread < nEvalRemainder) {
                    _idxEvalStart += idxThread;
                    _idxEvalEnd += idxThread + 1;
                } else {
                    _idxEvalStart += nEvalRemainder;
                    _idxEvalEnd += nEvalRemainder;
                }
                int idxEvalStart = _idxEvalStart;
                int idxEvalEnd = _idxEvalEnd;
                service.submit(() -> {
                    try {
                        ABSCAB.kernelVectorPotentialPolygonFilament(vertexSupplier, current, evalPos, vectorPotential, 0, idxSourceEnd, idxEvalStart, idxEvalEnd, useCompensatedSummation);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            service.shutdown();
            try {
                service.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void magneticFieldPolygonFilament(final double[][] vertices, final double current, final double[][] evalPos, double[][] magneticField, int numProcessors, final boolean useCompensatedSummation) {
        int numVertices = ABSCAB.validateCartesianVectorInput(vertices);
        if (numVertices < 2) {
            throw new RuntimeException("need at least 2 vertices, but only got " + numVertices);
        }
        int numEvalPos = ABSCAB.validateCartesianVectorInput(evalPos);
        if (numProcessors < 1) {
            throw new RuntimeException("need at least 1 processor, but only got " + numProcessors);
        }
        if (current == 0.0) {
            return;
        }
        if (numProcessors == 1) {
            boolean idxSourceStart = false;
            int idxSourceEnd = numVertices - 1;
            boolean idxEvalStart = false;
            int idxEvalEnd = numEvalPos;
            ABSCAB.kernelMagneticFieldPolygonFilament(vertices, current, evalPos, magneticField, 0, idxSourceEnd, 0, idxEvalEnd, useCompensatedSummation);
        } else if (numVertices - 1 > numEvalPos) {
            int nSourceRemainder;
            int nSourcePerThread;
            int nThreads;
            if (numVertices - 1 < numProcessors) {
                nThreads = numVertices - 1;
                nSourcePerThread = 1;
                nSourceRemainder = 0;
            } else {
                nThreads = numProcessors;
                nSourcePerThread = (numVertices - 1) / nThreads;
                nSourceRemainder = (numVertices - 1) % nThreads;
            }
            boolean idxEvalStart = false;
            final int idxEvalEnd = numEvalPos;
            final double[][][] magneticFieldContributions = new double[nThreads][3][numEvalPos];
            ExecutorService service = Executors.newFixedThreadPool(nThreads);
            for (int idxThread = 0; idxThread < nThreads; ++idxThread) {
                int _idxSourceStart = idxThread * nSourcePerThread;
                int _idxSourceEnd = (idxThread + 1) * nSourcePerThread;
                if (idxThread < nSourceRemainder) {
                    _idxSourceStart += idxThread;
                    _idxSourceEnd += idxThread + 1;
                } else {
                    _idxSourceStart += nSourceRemainder;
                    _idxSourceEnd += nSourceRemainder;
                }
                final int idxSourceStart = _idxSourceStart;
                final int idxSourceEnd = _idxSourceEnd;
                service.submit(new Runnable(){
                    private int idxThread;

                    public Runnable init(int idxThread) {
                        this.idxThread = idxThread;
                        return this;
                    }

                    @Override
                    public void run() {
                        try {
                            ABSCAB.kernelMagneticFieldPolygonFilament(vertices, current, evalPos, magneticFieldContributions[this.idxThread], idxSourceStart, idxSourceEnd, 0, idxEvalEnd, useCompensatedSummation);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }.init(idxThread));
            }
            service.shutdown();
            try {
                service.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (useCompensatedSummation) {
                for (int i = 0; i < numEvalPos; ++i) {
                    CompensatedSummation sumX = new CompensatedSummation();
                    CompensatedSummation sumY = new CompensatedSummation();
                    CompensatedSummation sumZ = new CompensatedSummation();
                    for (int idxThread = 0; idxThread < nThreads; ++idxThread) {
                        sumX.add(magneticFieldContributions[idxThread][0][i]);
                        sumY.add(magneticFieldContributions[idxThread][1][i]);
                        sumZ.add(magneticFieldContributions[idxThread][2][i]);
                    }
                    magneticField[0][i] = sumX.getSum();
                    magneticField[1][i] = sumY.getSum();
                    magneticField[2][i] = sumZ.getSum();
                }
            } else {
                for (int idxThread = 0; idxThread < nThreads; ++idxThread) {
                    for (int i = 0; i < numEvalPos; ++i) {
                        double[] dArray = magneticField[0];
                        int n = i;
                        dArray[n] = dArray[n] + magneticFieldContributions[idxThread][0][i];
                        double[] dArray2 = magneticField[1];
                        int n2 = i;
                        dArray2[n2] = dArray2[n2] + magneticFieldContributions[idxThread][1][i];
                        double[] dArray3 = magneticField[2];
                        int n3 = i;
                        dArray3[n3] = dArray3[n3] + magneticFieldContributions[idxThread][2][i];
                    }
                }
            }
        } else {
            int nEvalRemainder;
            int nEvalPerThread;
            int nThreads;
            boolean idxSourceStart = false;
            int idxSourceEnd = numVertices - 1;
            if (numEvalPos < numProcessors) {
                nThreads = numEvalPos;
                nEvalPerThread = 1;
                nEvalRemainder = 0;
            } else {
                nThreads = numProcessors;
                nEvalPerThread = numEvalPos / nThreads;
                nEvalRemainder = numEvalPos % nThreads;
            }
            ExecutorService service = Executors.newFixedThreadPool(nThreads);
            for (int idxThread = 0; idxThread < nThreads; ++idxThread) {
                int _idxEvalStart = idxThread * nEvalPerThread;
                int _idxEvalEnd = (idxThread + 1) * nEvalPerThread;
                if (idxThread < nEvalRemainder) {
                    _idxEvalStart += idxThread;
                    _idxEvalEnd += idxThread + 1;
                } else {
                    _idxEvalStart += nEvalRemainder;
                    _idxEvalEnd += nEvalRemainder;
                }
                int idxEvalStart = _idxEvalStart;
                int idxEvalEnd = _idxEvalEnd;
                service.submit(() -> {
                    try {
                        ABSCAB.kernelMagneticFieldPolygonFilament(vertices, current, evalPos, magneticField, 0, idxSourceEnd, idxEvalStart, idxEvalEnd, useCompensatedSummation);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            service.shutdown();
            try {
                service.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void magneticFieldPolygonFilament(int numVertices, final IntFunction<double[]> vertexSupplier, final double current, final double[][] evalPos, double[][] magneticField, int numProcessors, final boolean useCompensatedSummation) {
        if (numVertices < 2) {
            throw new RuntimeException("need at least 2 vertices, but only got " + numVertices);
        }
        int numEvalPos = ABSCAB.validateCartesianVectorInput(evalPos);
        if (numProcessors < 1) {
            throw new RuntimeException("need at least 1 processor, but only got " + numProcessors);
        }
        if (current == 0.0) {
            return;
        }
        if (numProcessors == 1) {
            boolean idxSourceStart = false;
            int idxSourceEnd = numVertices - 1;
            boolean idxEvalStart = false;
            int idxEvalEnd = numEvalPos;
            ABSCAB.kernelMagneticFieldPolygonFilament(vertexSupplier, current, evalPos, magneticField, 0, idxSourceEnd, 0, idxEvalEnd, useCompensatedSummation);
        } else if (numVertices - 1 > numEvalPos) {
            int nSourceRemainder;
            int nSourcePerThread;
            int nThreads;
            if (numVertices - 1 < numProcessors) {
                nThreads = numVertices - 1;
                nSourcePerThread = 1;
                nSourceRemainder = 0;
            } else {
                nThreads = numProcessors;
                nSourcePerThread = (numVertices - 1) / nThreads;
                nSourceRemainder = (numVertices - 1) % nThreads;
            }
            boolean idxEvalStart = false;
            final int idxEvalEnd = numEvalPos;
            final double[][][] magneticFieldContributions = new double[nThreads][3][numEvalPos];
            ExecutorService service = Executors.newFixedThreadPool(nThreads);
            for (int idxThread = 0; idxThread < nThreads; ++idxThread) {
                int _idxSourceStart = idxThread * nSourcePerThread;
                int _idxSourceEnd = (idxThread + 1) * nSourcePerThread;
                if (idxThread < nSourceRemainder) {
                    _idxSourceStart += idxThread;
                    _idxSourceEnd += idxThread + 1;
                } else {
                    _idxSourceStart += nSourceRemainder;
                    _idxSourceEnd += nSourceRemainder;
                }
                final int idxSourceStart = _idxSourceStart;
                final int idxSourceEnd = _idxSourceEnd;
                service.submit(new Runnable(){
                    private int idxThread;

                    public Runnable init(int idxThread) {
                        this.idxThread = idxThread;
                        return this;
                    }

                    @Override
                    public void run() {
                        try {
                            ABSCAB.kernelMagneticFieldPolygonFilament(vertexSupplier, current, evalPos, magneticFieldContributions[this.idxThread], idxSourceStart, idxSourceEnd, 0, idxEvalEnd, useCompensatedSummation);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }.init(idxThread));
            }
            service.shutdown();
            try {
                service.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (useCompensatedSummation) {
                for (int i = 0; i < numEvalPos; ++i) {
                    CompensatedSummation sumX = new CompensatedSummation();
                    CompensatedSummation sumY = new CompensatedSummation();
                    CompensatedSummation sumZ = new CompensatedSummation();
                    for (int idxThread = 0; idxThread < nThreads; ++idxThread) {
                        sumX.add(magneticFieldContributions[idxThread][0][i]);
                        sumY.add(magneticFieldContributions[idxThread][1][i]);
                        sumZ.add(magneticFieldContributions[idxThread][2][i]);
                    }
                    magneticField[0][i] = sumX.getSum();
                    magneticField[1][i] = sumY.getSum();
                    magneticField[2][i] = sumZ.getSum();
                }
            } else {
                for (int idxThread = 0; idxThread < nThreads; ++idxThread) {
                    for (int i = 0; i < numEvalPos; ++i) {
                        double[] dArray = magneticField[0];
                        int n = i;
                        dArray[n] = dArray[n] + magneticFieldContributions[idxThread][0][i];
                        double[] dArray2 = magneticField[1];
                        int n2 = i;
                        dArray2[n2] = dArray2[n2] + magneticFieldContributions[idxThread][1][i];
                        double[] dArray3 = magneticField[2];
                        int n3 = i;
                        dArray3[n3] = dArray3[n3] + magneticFieldContributions[idxThread][2][i];
                    }
                }
            }
        } else {
            int nEvalRemainder;
            int nEvalPerThread;
            int nThreads;
            boolean idxSourceStart = false;
            int idxSourceEnd = numVertices - 1;
            if (numEvalPos < numProcessors) {
                nThreads = numEvalPos;
                nEvalPerThread = 1;
                nEvalRemainder = 0;
            } else {
                nThreads = numProcessors;
                nEvalPerThread = numEvalPos / nThreads;
                nEvalRemainder = numEvalPos % nThreads;
            }
            ExecutorService service = Executors.newFixedThreadPool(nThreads);
            for (int idxThread = 0; idxThread < nThreads; ++idxThread) {
                int _idxEvalStart = idxThread * nEvalPerThread;
                int _idxEvalEnd = (idxThread + 1) * nEvalPerThread;
                if (idxThread < nEvalRemainder) {
                    _idxEvalStart += idxThread;
                    _idxEvalEnd += idxThread + 1;
                } else {
                    _idxEvalStart += nEvalRemainder;
                    _idxEvalEnd += nEvalRemainder;
                }
                int idxEvalStart = _idxEvalStart;
                int idxEvalEnd = _idxEvalEnd;
                service.submit(() -> {
                    try {
                        ABSCAB.kernelMagneticFieldPolygonFilament(vertexSupplier, current, evalPos, magneticField, 0, idxSourceEnd, idxEvalStart, idxEvalEnd, useCompensatedSummation);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            service.shutdown();
            try {
                service.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static void kernelVectorPotentialPolygonFilament(double[][] vertices, double current, double[][] evalPos, double[][] vectorPotential, int idxSourceStart, int idxSourceEnd, int idxEvalStart, int idxEvalEnd, boolean useCompensatedSummation) {
        CompensatedSummation[] aZSum;
        CompensatedSummation[] aYSum;
        CompensatedSummation[] aXSum;
        double aPrefactor = 2.0000000010887514E-7 * current;
        if (useCompensatedSummation) {
            int numEvalPos = idxEvalEnd - idxEvalStart;
            aXSum = new CompensatedSummation[numEvalPos];
            aYSum = new CompensatedSummation[numEvalPos];
            aZSum = new CompensatedSummation[numEvalPos];
            for (int idxEval = 0; idxEval < numEvalPos; ++idxEval) {
                aXSum[idxEval] = new CompensatedSummation();
                aYSum[idxEval] = new CompensatedSummation();
                aZSum[idxEval] = new CompensatedSummation();
            }
        } else {
            aXSum = null;
            aYSum = null;
            aZSum = null;
        }
        if (idxSourceStart >= vertices[0].length) {
            System.out.printf("ERROR: access out-of-bounds in kernelVectorPotentialPolygonFilament: %d >= %d\n", idxSourceStart, vertices[0].length);
        }
        double x_i = vertices[0][idxSourceStart];
        double y_i = vertices[1][idxSourceStart];
        double z_i = vertices[2][idxSourceStart];
        for (int idxSource = idxSourceStart; idxSource < idxSourceEnd; ++idxSource) {
            double x_f = vertices[0][idxSource + 1];
            double dx = x_f - x_i;
            double y_f = vertices[1][idxSource + 1];
            double dy = y_f - y_i;
            double z_f = vertices[2][idxSource + 1];
            double dz = z_f - z_i;
            double l2 = dx * dx + dy * dy + dz * dz;
            if (l2 == 0.0) continue;
            double l = Math.sqrt(l2);
            double eX = dx / l;
            double eY = dy / l;
            double eZ = dz / l;
            for (int idxEval = idxEvalStart; idxEval < idxEvalEnd; ++idxEval) {
                double r0x = evalPos[0][idxEval] - x_i;
                double r0y = evalPos[1][idxEval] - y_i;
                double r0z = evalPos[2][idxEval] - z_i;
                double alignedZ = eX * r0x + eY * r0y + eZ * r0z;
                double zP = alignedZ / l;
                double rPerpX = r0x - alignedZ * eX;
                double rPerpY = r0y - alignedZ * eY;
                double rPerpZ = r0z - alignedZ * eZ;
                double alignedR = Math.sqrt(rPerpX * rPerpX + rPerpY * rPerpY + rPerpZ * rPerpZ);
                double rhoP = alignedR / l;
                double aParallel = aPrefactor * ABSCAB.straightWireSegment_A_z(rhoP, zP);
                if (useCompensatedSummation) {
                    aXSum[idxEval - idxEvalStart].add(aParallel * eX);
                    aYSum[idxEval - idxEvalStart].add(aParallel * eY);
                    aZSum[idxEval - idxEvalStart].add(aParallel * eZ);
                    continue;
                }
                double[] dArray = vectorPotential[0];
                int n = idxEval;
                dArray[n] = dArray[n] + aParallel * eX;
                double[] dArray2 = vectorPotential[1];
                int n2 = idxEval;
                dArray2[n2] = dArray2[n2] + aParallel * eY;
                double[] dArray3 = vectorPotential[2];
                int n3 = idxEval;
                dArray3[n3] = dArray3[n3] + aParallel * eZ;
            }
            x_i = x_f;
            y_i = y_f;
            z_i = z_f;
        }
        if (useCompensatedSummation) {
            for (int idxEval = idxEvalStart; idxEval < idxEvalEnd; ++idxEval) {
                vectorPotential[0][idxEval] = aXSum[idxEval - idxEvalStart].getSum();
                vectorPotential[1][idxEval] = aYSum[idxEval - idxEvalStart].getSum();
                vectorPotential[2][idxEval] = aZSum[idxEval - idxEvalStart].getSum();
            }
        }
    }

    private static void kernelVectorPotentialPolygonFilament(IntFunction<double[]> vertexSupplier, double current, double[][] evalPos, double[][] vectorPotential, int idxSourceStart, int idxSourceEnd, int idxEvalStart, int idxEvalEnd, boolean useCompensatedSummation) {
        CompensatedSummation[] aZSum;
        CompensatedSummation[] aYSum;
        CompensatedSummation[] aXSum;
        double aPrefactor = 2.0000000010887514E-7 * current;
        if (useCompensatedSummation) {
            int numEvalPos = idxEvalEnd - idxEvalStart;
            aXSum = new CompensatedSummation[numEvalPos];
            aYSum = new CompensatedSummation[numEvalPos];
            aZSum = new CompensatedSummation[numEvalPos];
            for (int idxEval = 0; idxEval < numEvalPos; ++idxEval) {
                aXSum[idxEval] = new CompensatedSummation();
                aYSum[idxEval] = new CompensatedSummation();
                aZSum[idxEval] = new CompensatedSummation();
            }
        } else {
            aXSum = null;
            aYSum = null;
            aZSum = null;
        }
        double[] firstPoint = vertexSupplier.apply(idxSourceStart);
        double x_i = firstPoint[0];
        double y_i = firstPoint[1];
        double z_i = firstPoint[2];
        for (int idxSource = idxSourceStart; idxSource < idxSourceEnd; ++idxSource) {
            double z_f;
            double dz;
            double y_f;
            double dy;
            double[] nextPoint = vertexSupplier.apply(idxSource + 1);
            double x_f = nextPoint[0];
            double dx = x_f - x_i;
            double l2 = dx * dx + (dy = (y_f = nextPoint[1]) - y_i) * dy + (dz = (z_f = nextPoint[2]) - z_i) * dz;
            if (l2 == 0.0) continue;
            double l = Math.sqrt(l2);
            double eX = dx / l;
            double eY = dy / l;
            double eZ = dz / l;
            for (int idxEval = idxEvalStart; idxEval < idxEvalEnd; ++idxEval) {
                double r0x = evalPos[0][idxEval] - x_i;
                double r0y = evalPos[1][idxEval] - y_i;
                double r0z = evalPos[2][idxEval] - z_i;
                double alignedZ = eX * r0x + eY * r0y + eZ * r0z;
                double zP = alignedZ / l;
                double rPerpX = r0x - alignedZ * eX;
                double rPerpY = r0y - alignedZ * eY;
                double rPerpZ = r0z - alignedZ * eZ;
                double alignedR = Math.sqrt(rPerpX * rPerpX + rPerpY * rPerpY + rPerpZ * rPerpZ);
                double rhoP = alignedR / l;
                double aParallel = aPrefactor * ABSCAB.straightWireSegment_A_z(rhoP, zP);
                if (useCompensatedSummation) {
                    aXSum[idxEval - idxEvalStart].add(aParallel * eX);
                    aYSum[idxEval - idxEvalStart].add(aParallel * eY);
                    aZSum[idxEval - idxEvalStart].add(aParallel * eZ);
                    continue;
                }
                double[] dArray = vectorPotential[0];
                int n = idxEval;
                dArray[n] = dArray[n] + aParallel * eX;
                double[] dArray2 = vectorPotential[1];
                int n2 = idxEval;
                dArray2[n2] = dArray2[n2] + aParallel * eY;
                double[] dArray3 = vectorPotential[2];
                int n3 = idxEval;
                dArray3[n3] = dArray3[n3] + aParallel * eZ;
            }
            x_i = x_f;
            y_i = y_f;
            z_i = z_f;
        }
        if (useCompensatedSummation) {
            for (int idxEval = idxEvalStart; idxEval < idxEvalEnd; ++idxEval) {
                vectorPotential[0][idxEval] = aXSum[idxEval - idxEvalStart].getSum();
                vectorPotential[1][idxEval] = aYSum[idxEval - idxEvalStart].getSum();
                vectorPotential[2][idxEval] = aZSum[idxEval - idxEvalStart].getSum();
            }
        }
    }

    private static void kernelMagneticFieldPolygonFilament(double[][] vertices, double current, double[][] evalPos, double[][] magneticField, int idxSourceStart, int idxSourceEnd, int idxEvalStart, int idxEvalEnd, boolean useCompensatedSummation) {
        CompensatedSummation[] bZSum;
        CompensatedSummation[] bYSum;
        CompensatedSummation[] bXSum;
        double bPrefactorL = 1.0000000005443757E-7 * current;
        if (useCompensatedSummation) {
            int numEvalPos = idxEvalEnd - idxEvalStart;
            bXSum = new CompensatedSummation[numEvalPos];
            bYSum = new CompensatedSummation[numEvalPos];
            bZSum = new CompensatedSummation[numEvalPos];
            for (int idxEval = 0; idxEval < numEvalPos; ++idxEval) {
                bXSum[idxEval] = new CompensatedSummation();
                bYSum[idxEval] = new CompensatedSummation();
                bZSum[idxEval] = new CompensatedSummation();
            }
        } else {
            bXSum = null;
            bYSum = null;
            bZSum = null;
        }
        double x_i = vertices[0][idxSourceStart];
        double y_i = vertices[1][idxSourceStart];
        double z_i = vertices[2][idxSourceStart];
        for (int idxSource = idxSourceStart; idxSource < idxSourceEnd; ++idxSource) {
            double x_f = vertices[0][idxSource + 1];
            double dx = x_f - x_i;
            double y_f = vertices[1][idxSource + 1];
            double dy = y_f - y_i;
            double z_f = vertices[2][idxSource + 1];
            double dz = z_f - z_i;
            double l2 = dx * dx + dy * dy + dz * dz;
            if (l2 == 0.0) continue;
            double l = Math.sqrt(l2);
            double bPrefactor = bPrefactorL / l;
            double eX = dx / l;
            double eY = dy / l;
            double eZ = dz / l;
            for (int idxEval = idxEvalStart; idxEval < idxEvalEnd; ++idxEval) {
                double r0x = evalPos[0][idxEval] - x_i;
                double r0y = evalPos[1][idxEval] - y_i;
                double r0z = evalPos[2][idxEval] - z_i;
                double alignedZ = eX * r0x + eY * r0y + eZ * r0z;
                double zP = alignedZ / l;
                double rPerpX = r0x - alignedZ * eX;
                double rPerpY = r0y - alignedZ * eY;
                double rPerpZ = r0z - alignedZ * eZ;
                double alignedRSq = rPerpX * rPerpX + rPerpY * rPerpY + rPerpZ * rPerpZ;
                if (!(alignedRSq > 0.0)) continue;
                double alignedR = Math.sqrt(alignedRSq);
                double rhoP = alignedR / l;
                double bPhi = bPrefactor * ABSCAB.straightWireSegment_B_phi(rhoP, zP);
                double eRX = rPerpX / alignedR;
                double eRY = rPerpY / alignedR;
                double eRZ = rPerpZ / alignedR;
                double ePhiX = eY * eRZ - eZ * eRY;
                double ePhiY = eZ * eRX - eX * eRZ;
                double ePhiZ = eX * eRY - eY * eRX;
                if (useCompensatedSummation) {
                    bXSum[idxEval - idxEvalStart].add(bPhi * ePhiX);
                    bYSum[idxEval - idxEvalStart].add(bPhi * ePhiY);
                    bZSum[idxEval - idxEvalStart].add(bPhi * ePhiZ);
                    continue;
                }
                double[] dArray = magneticField[0];
                int n = idxEval;
                dArray[n] = dArray[n] + bPhi * ePhiX;
                double[] dArray2 = magneticField[1];
                int n2 = idxEval;
                dArray2[n2] = dArray2[n2] + bPhi * ePhiY;
                double[] dArray3 = magneticField[2];
                int n3 = idxEval;
                dArray3[n3] = dArray3[n3] + bPhi * ePhiZ;
            }
            x_i = x_f;
            y_i = y_f;
            z_i = z_f;
        }
        if (useCompensatedSummation) {
            for (int idxEval = idxEvalStart; idxEval < idxEvalEnd; ++idxEval) {
                magneticField[0][idxEval] = bXSum[idxEval - idxEvalStart].getSum();
                magneticField[1][idxEval] = bYSum[idxEval - idxEvalStart].getSum();
                magneticField[2][idxEval] = bZSum[idxEval - idxEvalStart].getSum();
            }
        }
    }

    private static void kernelMagneticFieldPolygonFilament(IntFunction<double[]> vertexSupplier, double current, double[][] evalPos, double[][] magneticField, int idxSourceStart, int idxSourceEnd, int idxEvalStart, int idxEvalEnd, boolean useCompensatedSummation) {
        CompensatedSummation[] bZSum;
        CompensatedSummation[] bYSum;
        CompensatedSummation[] bXSum;
        if (useCompensatedSummation) {
            int numEvalPos = idxEvalEnd - idxEvalStart;
            bXSum = new CompensatedSummation[numEvalPos];
            bYSum = new CompensatedSummation[numEvalPos];
            bZSum = new CompensatedSummation[numEvalPos];
            for (int idxEval = 0; idxEval < numEvalPos; ++idxEval) {
                bXSum[idxEval] = new CompensatedSummation();
                bYSum[idxEval] = new CompensatedSummation();
                bZSum[idxEval] = new CompensatedSummation();
            }
        } else {
            bXSum = null;
            bYSum = null;
            bZSum = null;
        }
        double bPrefactorL = 1.0000000005443757E-7 * current;
        double[] firstPoint = vertexSupplier.apply(idxSourceStart);
        double x_i = firstPoint[0];
        double y_i = firstPoint[1];
        double z_i = firstPoint[2];
        for (int idxSource = idxSourceStart; idxSource < idxSourceEnd; ++idxSource) {
            double z_f;
            double dz;
            double y_f;
            double dy;
            double[] nextPoint = vertexSupplier.apply(idxSource + 1);
            double x_f = nextPoint[0];
            double dx = x_f - x_i;
            double l2 = dx * dx + (dy = (y_f = nextPoint[1]) - y_i) * dy + (dz = (z_f = nextPoint[2]) - z_i) * dz;
            if (l2 == 0.0) continue;
            double l = Math.sqrt(l2);
            double bPrefactor = bPrefactorL / l;
            double eX = dx / l;
            double eY = dy / l;
            double eZ = dz / l;
            for (int idxEval = idxEvalStart; idxEval < idxEvalEnd; ++idxEval) {
                double r0x = evalPos[0][idxEval] - x_i;
                double r0y = evalPos[1][idxEval] - y_i;
                double r0z = evalPos[2][idxEval] - z_i;
                double alignedZ = eX * r0x + eY * r0y + eZ * r0z;
                double zP = alignedZ / l;
                double rPerpX = r0x - alignedZ * eX;
                double rPerpY = r0y - alignedZ * eY;
                double rPerpZ = r0z - alignedZ * eZ;
                double alignedRSq = rPerpX * rPerpX + rPerpY * rPerpY + rPerpZ * rPerpZ;
                if (!(alignedRSq > 0.0)) continue;
                double alignedR = Math.sqrt(alignedRSq);
                double rhoP = alignedR / l;
                double bPhi = bPrefactor * ABSCAB.straightWireSegment_B_phi(rhoP, zP);
                double eRX = rPerpX / alignedR;
                double eRY = rPerpY / alignedR;
                double eRZ = rPerpZ / alignedR;
                double ePhiX = eY * eRZ - eZ * eRY;
                double ePhiY = eZ * eRX - eX * eRZ;
                double ePhiZ = eX * eRY - eY * eRX;
                if (useCompensatedSummation) {
                    bXSum[idxEval - idxEvalStart].add(bPhi * ePhiX);
                    bYSum[idxEval - idxEvalStart].add(bPhi * ePhiY);
                    bZSum[idxEval - idxEvalStart].add(bPhi * ePhiZ);
                    continue;
                }
                double[] dArray = magneticField[0];
                int n = idxEval;
                dArray[n] = dArray[n] + bPhi * ePhiX;
                double[] dArray2 = magneticField[1];
                int n2 = idxEval;
                dArray2[n2] = dArray2[n2] + bPhi * ePhiY;
                double[] dArray3 = magneticField[2];
                int n3 = idxEval;
                dArray3[n3] = dArray3[n3] + bPhi * ePhiZ;
            }
            x_i = x_f;
            y_i = y_f;
            z_i = z_f;
        }
        if (useCompensatedSummation) {
            for (int idxEval = idxEvalStart; idxEval < idxEvalEnd; ++idxEval) {
                magneticField[0][idxEval] = bXSum[idxEval - idxEvalStart].getSum();
                magneticField[1][idxEval] = bYSum[idxEval - idxEvalStart].getSum();
                magneticField[2][idxEval] = bZSum[idxEval - idxEvalStart].getSum();
            }
        }
    }

    public static double[][] vectorPotentialCircularFilament(double[] center, double[] normal, double radius, double current, double[][] evalPos) {
        Objects.requireNonNull(center);
        if (center.length != 3) {
            throw new RuntimeException("center needs to have 3 elements, but has " + center.length);
        }
        Objects.requireNonNull(normal);
        if (normal.length != 3) {
            throw new RuntimeException("normal needs to have 3 elements, but has " + normal.length);
        }
        if (!Double.isFinite(radius) || radius <= 0.0) {
            throw new RuntimeException("radius must be finite and positive, but is " + radius);
        }
        int nEvalPos = ABSCAB.validateCartesianVectorInput(evalPos);
        double aPrefactor = 4.000000002177503E-7 * current;
        double nLen2 = normal[0] * normal[0] + normal[1] * normal[1] + normal[2] * normal[2];
        if (nLen2 == 0.0) {
            throw new RuntimeException("length of normal vector must not be zero");
        }
        double nLen = Math.sqrt(nLen2);
        double eX = normal[0] / nLen;
        double eY = normal[1] / nLen;
        double eZ = normal[2] / nLen;
        double[][] ret = new double[3][nEvalPos];
        for (int idxEval = 0; idxEval < nEvalPos; ++idxEval) {
            double r0x = evalPos[0][idxEval] - center[0];
            double r0y = evalPos[1][idxEval] - center[1];
            double r0z = evalPos[2][idxEval] - center[2];
            double alignedZ = eX * r0x + eY * r0y + eZ * r0z;
            double zP = alignedZ / radius;
            double rParallelX = alignedZ * eX;
            double rPerpX = r0x - rParallelX;
            double rParallelY = alignedZ * eY;
            double rPerpY = r0y - rParallelY;
            double rParallelZ = alignedZ * eZ;
            double rPerpZ = r0z - rParallelZ;
            double alignedRSq = rPerpX * rPerpX + rPerpY * rPerpY + rPerpZ * rPerpZ;
            if (!(alignedRSq > 0.0)) continue;
            double alignedR = Math.sqrt(alignedRSq);
            double eRX = rPerpX / alignedR;
            double eRY = rPerpY / alignedR;
            double eRZ = rPerpZ / alignedR;
            double rhoP = alignedR / radius;
            double aPhi = aPrefactor * ABSCAB.circularWireLoop_A_phi(rhoP, zP);
            double ePhiX = eRY * eZ - eRZ * eY;
            double ePhiY = eRZ * eX - eRX * eZ;
            double ePhiZ = eRX * eY - eRY * eX;
            ret[0][idxEval] = aPhi * ePhiX;
            ret[1][idxEval] = aPhi * ePhiY;
            ret[2][idxEval] = aPhi * ePhiZ;
        }
        return ret;
    }

    public static double[][] magneticFieldCircularFilament(double[] center, double[] normal, double radius, double current, double[][] evalPos) {
        Objects.requireNonNull(center);
        if (center.length != 3) {
            throw new RuntimeException("center needs to have 3 elements, but has " + center.length);
        }
        Objects.requireNonNull(normal);
        if (normal.length != 3) {
            throw new RuntimeException("normal needs to have 3 elements, but has " + normal.length);
        }
        if (!Double.isFinite(radius) || radius <= 0.0) {
            throw new RuntimeException("radius must be finite and positive, but is " + radius);
        }
        int nEvalPos = ABSCAB.validateCartesianVectorInput(evalPos);
        double bPrefactor = 4.000000002177503E-7 * current / radius;
        double nLen2 = normal[0] * normal[0] + normal[1] * normal[1] + normal[2] * normal[2];
        if (nLen2 == 0.0) {
            throw new RuntimeException("length of normal vector must not be zero");
        }
        double nLen = Math.sqrt(nLen2);
        double eX = normal[0] / nLen;
        double eY = normal[1] / nLen;
        double eZ = normal[2] / nLen;
        double[][] ret = new double[3][nEvalPos];
        int idxEval = 0;
        while (idxEval < nEvalPos) {
            double rhoP;
            double r0x = evalPos[0][idxEval] - center[0];
            double r0y = evalPos[1][idxEval] - center[1];
            double r0z = evalPos[2][idxEval] - center[2];
            double alignedZ = eX * r0x + eY * r0y + eZ * r0z;
            double zP = alignedZ / radius;
            double rParallelX = alignedZ * eX;
            double rPerpX = r0x - rParallelX;
            double rParallelY = alignedZ * eY;
            double rPerpY = r0y - rParallelY;
            double rParallelZ = alignedZ * eZ;
            double rPerpZ = r0z - rParallelZ;
            double alignedRSq = rPerpX * rPerpX + rPerpY * rPerpY + rPerpZ * rPerpZ;
            if (alignedRSq > 0.0) {
                double alignedR = Math.sqrt(alignedRSq);
                double eRX = rPerpX / alignedR;
                double eRY = rPerpY / alignedR;
                double eRZ = rPerpZ / alignedR;
                rhoP = alignedR / radius;
                double bRho = bPrefactor * ABSCAB.circularWireLoop_B_rho(rhoP, zP);
                ret[0][idxEval] = bRho * eRX;
                ret[1][idxEval] = bRho * eRY;
                ret[2][idxEval] = bRho * eRZ;
            } else {
                rhoP = 0.0;
            }
            double bZ = bPrefactor * ABSCAB.circularWireLoop_B_z(rhoP, zP);
            double[] dArray = ret[0];
            int n = idxEval;
            dArray[n] = dArray[n] + bZ * eX;
            double[] dArray2 = ret[1];
            int n2 = idxEval;
            dArray2[n2] = dArray2[n2] + bZ * eY;
            double[] dArray3 = ret[2];
            int n3 = idxEval++;
            dArray3[n3] = dArray3[n3] + bZ * eZ;
        }
        return ret;
    }

    private static int validateCartesianVectorInput(double[][] a) {
        Objects.requireNonNull(a);
        if (a.length != 3) {
            throw new RuntimeException("first dimension must have 3 dimension, but has " + a.length);
        }
        Objects.requireNonNull(a[0]);
        Objects.requireNonNull(a[1]);
        Objects.requireNonNull(a[2]);
        int len = a[0].length;
        if (a[1].length != len) {
            throw new RuntimeException("expected " + len + " y coordinates, but only got " + a[1].length);
        }
        if (a[2].length != len) {
            throw new RuntimeException("expected " + len + " z coordinates, but only got " + a[2].length);
        }
        return len;
    }

    public static double straightWireSegment_A_z(double rhoP, double zP) {
        if (rhoP == 0.0) {
            if (zP < 0.0 || zP > 1.0) {
                return ABSCAB.sws_A_z_ax(zP);
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "evaluation locations on the wire segment (rho'=%g z'=%g) are not allowed", rhoP, zP));
        }
        if (zP == 0.0 || zP == 1.0) {
            return ABSCAB.sws_A_z_rad(rhoP);
        }
        if (rhoP >= 1.0 || zP <= -1.0 || zP > 2.0) {
            return ABSCAB.sws_A_z_f(rhoP, zP);
        }
        return ABSCAB.sws_A_z_n(rhoP, zP);
    }

    public static double straightWireSegment_B_phi(double rhoP, double zP) {
        if (rhoP == 0.0) {
            if (zP < 0.0 || zP > 1.0) {
                return 0.0;
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "evaluation locations on the wire segment (rho'=%g z'=%g) are not allowed", rhoP, zP));
        }
        if (zP == 0.0 || zP == 1.0) {
            return ABSCAB.sws_B_phi_rad(rhoP);
        }
        if (rhoP >= zP || rhoP >= 1.0 - zP || zP < 0.0 || zP > 1.0) {
            return ABSCAB.sws_B_phi_f(rhoP, zP);
        }
        return ABSCAB.sws_B_phi_n(rhoP, zP);
    }

    public static double circularWireLoop_A_phi(double rhoP, double zP) {
        if (rhoP == 0.0) {
            return 0.0;
        }
        if (rhoP < 0.5 || rhoP > 2.0 || Math.abs(zP) >= 1.0) {
            return ABSCAB.cwl_A_phi_f(rhoP, zP);
        }
        if (rhoP != 1.0) {
            return ABSCAB.cwl_A_phi_n(rhoP, zP);
        }
        if (zP != 0.0) {
            return ABSCAB.cwl_A_phi_v(zP);
        }
        throw new IllegalArgumentException("evaluation at location of wire loop (rho' = 1, z' = 0) is not defined");
    }

    public static double circularWireLoop_B_rho(double rhoP, double zP) {
        if (rhoP == 0.0 || zP == 0.0) {
            if (rhoP != 1.0) {
                return 0.0;
            }
            throw new IllegalArgumentException("evaluation at location of wire loop (rho' = 1, z' = 0) is not defined");
        }
        if (rhoP < 0.5 || rhoP > 2.0 || Math.abs(zP) >= 1.0) {
            return ABSCAB.cwl_B_rho_f(rhoP, zP);
        }
        if (rhoP != 1.0) {
            return ABSCAB.cwl_B_rho_n(rhoP, zP);
        }
        return ABSCAB.cwl_B_rho_v(zP);
    }

    public static double circularWireLoop_B_z(double rhoP, double zP) {
        if (rhoP < 0.5 || rhoP <= 2.0 && Math.abs(zP) > 1.0) {
            return ABSCAB.cwl_B_z_f1(rhoP, zP);
        }
        if (rhoP > 2.0) {
            return ABSCAB.cwl_B_z_f2(rhoP, zP);
        }
        if (rhoP != 1.0) {
            return ABSCAB.cwl_B_z_n(rhoP, zP);
        }
        if (zP != 0.0) {
            return ABSCAB.cwl_B_z_v(zP);
        }
        throw new IllegalArgumentException("evaluation at location of wire loop (rho' = 1, z' = 0) is not defined");
    }

    static double sws_A_z_ax(double zP) {
        if (zP < -1.0 || zP >= 2.0) {
            return ABSCAB.sws_A_z_ax_f(zP);
        }
        return ABSCAB.sws_A_z_ax_n(zP);
    }

    static double sws_A_z_ax_f(double zP) {
        return FastMath.atanh((double)(1.0 / (Math.abs(zP) + Math.abs(1.0 - zP))));
    }

    static double sws_A_z_ax_n(double zP) {
        return Math.signum(zP) * Math.log(zP / (zP - 1.0)) / 2.0;
    }

    static double sws_A_z_rad(double rhoP) {
        if (rhoP > 1.0) {
            return ABSCAB.sws_A_z_rad_f(rhoP);
        }
        return ABSCAB.sws_A_z_rad_n(rhoP);
    }

    static double sws_A_z_rad_f(double rhoP) {
        return FastMath.atanh((double)(1.0 / (rhoP + Math.hypot(rhoP, 1.0))));
    }

    static double sws_A_z_rad_n(double rhoP) {
        double cat = 1.0 / Math.hypot(rhoP, 1.0);
        double sat = Math.sin(Math.atan(rhoP) / 2.0);
        double rc = rhoP * cat;
        double num = rc + 1.0 + cat;
        double den = rc + 2.0 * sat * sat;
        return Math.log(num / den) / 2.0;
    }

    static double sws_A_z_f(double rhoP, double zP) {
        double r_i = Math.hypot(rhoP, zP);
        double r_f = Math.hypot(rhoP, 1.0 - zP);
        return FastMath.atanh((double)(1.0 / (r_i + r_f)));
    }

    static double sws_A_z_n(double rhoP, double zP) {
        double omz = 1.0 - zP;
        double r_i = Math.hypot(rhoP, zP);
        double r_f = Math.hypot(rhoP, omz);
        double alpha = Math.atan2(rhoP, zP);
        double sinAlphaHalf = Math.sin(alpha / 2.0);
        double beta = Math.atan2(rhoP, omz);
        double sinBetaHalf = Math.sin(beta / 2.0);
        double Ri_zP = r_i * sinAlphaHalf * sinAlphaHalf;
        double Rf_p_zM1 = r_f * sinBetaHalf * sinBetaHalf;
        double n = Ri_zP + Rf_p_zM1;
        return (Math.log(1.0 + n) - Math.log(n)) / 2.0;
    }

    static double sws_B_phi_rad(double rhoP) {
        return 1.0 / (rhoP * Math.hypot(rhoP, 1.0));
    }

    static double sws_B_phi_f(double rhoP, double zP) {
        double omz = 1.0 - zP;
        double r_i = Math.hypot(rhoP, zP);
        double r_f = Math.hypot(rhoP, omz);
        double num = rhoP * (1.0 / r_i + 1.0 / r_f);
        double den = rhoP * rhoP - zP * omz + r_i * r_f;
        return num / den;
    }

    static double sws_B_phi_n(double rhoP, double zP) {
        double omz = 1.0 - zP;
        double r_i = Math.hypot(rhoP, zP);
        double r_f = Math.hypot(rhoP, omz);
        double num = rhoP * (1.0 / r_i + 1.0 / r_f);
        double alpha = Math.atan2(rhoP, zP);
        double sinAlphaHalf = Math.sin(alpha / 2.0);
        double beta = Math.atan2(rhoP, omz);
        double sinBetaHalf = Math.sin(beta / 2.0);
        double rfb_omza = r_f * sinBetaHalf * sinBetaHalf + omz * sinAlphaHalf * sinAlphaHalf;
        double den = rhoP * rhoP + 2.0 * r_i * rfb_omza;
        return num / den;
    }

    static double cwl_A_phi_f(double rhoP, double zP) {
        double sqrt_kCSqNum = Math.hypot(zP, 1.0 - rhoP);
        double sqrt_kCSqDen = Math.hypot(zP, 1.0 + rhoP);
        double kC = sqrt_kCSqNum / sqrt_kCSqDen;
        double kSq = 4.0 * rhoP / (sqrt_kCSqDen * sqrt_kCSqDen);
        double kCp1 = 1.0 + kC;
        double arg1 = 2.0 * Math.sqrt(kC) / kCp1;
        double arg2 = 2.0 / (kCp1 * kCp1 * kCp1);
        double C = CompleteEllipticIntegral.cel(arg1, 1.0, 0.0, arg2);
        return kSq / sqrt_kCSqDen * C;
    }

    static double cwl_A_phi_n(double rhoP, double zP) {
        double rhoP_m_1 = rhoP - 1.0;
        double n = zP / rhoP_m_1;
        double m = 1.0 + 2.0 / rhoP_m_1;
        double num = n * n + 1.0;
        double den = n * n + m * m;
        double kCSq = num / den;
        double prefac = 1.0 / (Math.abs(rhoP - 1.0) * Math.sqrt(den));
        double celPart = CompleteEllipticIntegral.cel(Math.sqrt(kCSq), 1.0, -1.0, 1.0);
        return prefac * celPart;
    }

    static double cwl_A_phi_v(double zP) {
        double absZp = Math.abs(zP);
        double kCInv = Math.sqrt(4.0 + zP * zP) / absZp;
        return CompleteEllipticIntegral.cel(kCInv, 1.0, 1.0, -1.0) / absZp;
    }

    static double cwl_B_rho_f(double rhoP, double zP) {
        double sqrt_kCSqNum = Math.hypot(zP, 1.0 - rhoP);
        double sqrt_kCSqDen = Math.hypot(zP, 1.0 + rhoP);
        double kCSqNum = sqrt_kCSqNum * sqrt_kCSqNum;
        double kCSqDen = sqrt_kCSqDen * sqrt_kCSqDen;
        double kCSq = kCSqNum / kCSqDen;
        double kC = Math.sqrt(kCSq);
        double D = CompleteEllipticIntegral.cel(kC, 1.0, 0.0, 1.0);
        double kCp1 = 1.0 + kC;
        double arg1 = 2.0 * Math.sqrt(kC) / kCp1;
        double arg2 = 2.0 / (kCp1 * kCp1 * kCp1);
        double C = CompleteEllipticIntegral.cel(arg1, 1.0, 0.0, arg2);
        double prefac = 4.0 * rhoP / (kCSqDen * sqrt_kCSqDen * kCSqNum);
        return prefac * zP * (D - C);
    }

    static double cwl_B_rho_n(double rhoP, double zP) {
        double rhoP_m_1 = rhoP - 1.0;
        double rd2 = rhoP_m_1 * rhoP_m_1;
        double n = zP / rhoP_m_1;
        double m = 1.0 + 2.0 / rhoP_m_1;
        double sqrt_kCSqNum = Math.hypot(n, 1.0);
        double sqrt_kCSqDen = Math.hypot(n, m);
        double kCSqNum = sqrt_kCSqNum * sqrt_kCSqNum;
        double kCSqDen = sqrt_kCSqDen * sqrt_kCSqDen;
        double kC = sqrt_kCSqNum / sqrt_kCSqDen;
        double D = CompleteEllipticIntegral.cel(kC, 1.0, 0.0, 1.0);
        double kCp1 = 1.0 + kC;
        double arg1 = 2.0 * Math.sqrt(kC) / kCp1;
        double arg2 = 2.0 / (kCp1 * kCp1 * kCp1);
        double C = arg2 * CompleteEllipticIntegral.cel(arg1, 1.0, 0.0, 1.0);
        double zP_rd5 = zP / (Math.abs(rhoP_m_1) * rd2 * rd2);
        double prefac = 4.0 * rhoP / (kCSqDen * sqrt_kCSqDen * kCSqNum);
        return prefac * zP_rd5 * (D - C);
    }

    static double cwl_B_rho_v(double zP) {
        double zPSq = zP * zP;
        double kCSq = 1.0 / (1.0 + 4.0 / zPSq);
        double kC = Math.sqrt(kCSq);
        double K = CompleteEllipticIntegral.cel(kC, 1.0, 1.0, 1.0);
        double E = CompleteEllipticIntegral.cel(kC, 1.0, 1.0, kCSq);
        return Math.signum(zP) * kC / 2.0 * ((2.0 / zPSq + 1.0) * E - K);
    }

    static double cwl_B_z_f1(double rhoP, double zP) {
        double sqrt_kCSqNum = Math.hypot(zP, 1.0 - rhoP);
        double sqrt_kCSqDen = Math.hypot(zP, 1.0 + rhoP);
        double kC = sqrt_kCSqNum / sqrt_kCSqDen;
        double K = CompleteEllipticIntegral.cel(kC, 1.0, 1.0, 1.0);
        double E = CompleteEllipticIntegral.cel(kC, 1.0, 1.0, kC * kC);
        double D = CompleteEllipticIntegral.cel(kC, 1.0, 0.0, 1.0);
        double prefac = 1.0 / (sqrt_kCSqDen * sqrt_kCSqNum * sqrt_kCSqNum);
        double comb = E - 2.0 * K + 2.0 * D;
        return prefac * (E + rhoP * comb);
    }

    static double cwl_B_z_f2(double rhoP, double zP) {
        double sqrt_kCSqNum = Math.hypot(zP, 1.0 - rhoP);
        double sqrt_kCSqDen = Math.hypot(zP, 1.0 + rhoP);
        double kC = sqrt_kCSqNum / sqrt_kCSqDen;
        double kCSq = kC * kC;
        double zPSqP1 = zP * zP + 1.0;
        double rhoPSq = rhoP * rhoP;
        double t1 = zPSqP1 / rhoPSq + 1.0;
        double t2 = 2.0 / rhoP;
        double a = t1 + t2;
        double b = t1 - t2;
        double prefac = 1.0 / (Math.sqrt(a) * b * rhoPSq * rhoP);
        double cdScale = 1.0 + (2.0 + zPSqP1 / rhoP) / rhoP;
        double E = CompleteEllipticIntegral.cel(kC, 1.0, 1.0, kCSq);
        double D = CompleteEllipticIntegral.cel(kC, 1.0, 0.0, 1.0);
        double kCP1 = 1.0 + kC;
        double arg1 = 2.0 * Math.sqrt(kC) / kCP1;
        double arg2 = 2.0 / (kCP1 * kCP1 * kCP1);
        double C = arg2 * CompleteEllipticIntegral.cel(arg1, 1.0, 0.0, 1.0);
        return prefac * (E + 4.0 * (C - D) / cdScale);
    }

    static double cwl_B_z_n(double rhoP, double zP) {
        double rp1 = rhoP - 1.0;
        double n = zP / rp1;
        double m = 1.0 + 2.0 / rp1;
        double sqrt_kCSqNum = Math.hypot(n, 1.0);
        double sqrt_kCSqDen = Math.hypot(n, m);
        double kCSqDen = sqrt_kCSqDen * sqrt_kCSqDen;
        double kC = sqrt_kCSqNum / sqrt_kCSqDen;
        double prefac = 1.0 / (Math.abs(rp1) * rp1 * rp1 * kCSqDen * sqrt_kCSqDen);
        return prefac * CompleteEllipticIntegral.cel(kC, kC * kC, 1.0 + rhoP, 1.0 - rhoP);
    }

    static double cwl_B_z_v(double zP) {
        double kCSq = zP * zP / (4.0 + zP * zP);
        double kC = Math.sqrt(kCSq);
        double f = zP * zP + 4.0;
        double prefac = 1.0 / (f * Math.sqrt(f));
        return prefac * CompleteEllipticIntegral.cel(kC, kCSq, 2.0, 0.0);
    }
}

