/*
 * Decompiled with CFR 0.152.
 */
package de.labathome;

import de.labathome.AlocVarRequest;
import de.labathome.AlocVarResult;
import de.labathome.FreeVarRequest;
import de.labathome.FreeVarResult;
import de.labathome.RecvDblRequest;
import de.labathome.RecvDblResult;
import de.labathome.RecvFltRequest;
import de.labathome.RecvFltResult;
import de.labathome.RecvIntRequest;
import de.labathome.RecvIntResult;
import de.labathome.RemoteComputationKernelGrpc;
import de.labathome.ResetRequest;
import de.labathome.SendDblRequest;
import de.labathome.SendDblResult;
import de.labathome.SendFltRequest;
import de.labathome.SendFltResult;
import de.labathome.SendIntRequest;
import de.labathome.SendIntResult;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;

public class RemoteComputationClient {
    private ManagedChannel channel;
    private RemoteComputationKernelGrpc.RemoteComputationKernelBlockingStub blockingStub;
    private RemoteComputationKernelGrpc.RemoteComputationKernelStub asyncStub;

    public RemoteComputationClient(String host, int port) {
        this(ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext());
    }

    public RemoteComputationClient(ManagedChannelBuilder<?> channelBuilder) {
        this.channel = channelBuilder.build();
        this.blockingStub = RemoteComputationKernelGrpc.newBlockingStub((Channel)this.channel);
        this.asyncStub = RemoteComputationKernelGrpc.newStub((Channel)this.channel);
    }

    public void reset() {
        this.blockingStub.reset(ResetRequest.newBuilder().build());
    }

    public int allocate_int() {
        return this.allocate_int(null);
    }

    public int allocate_int(int ... dimensions) {
        AlocVarResult res;
        AlocVarRequest.Builder req_builder = AlocVarRequest.newBuilder().setDtype(3);
        if (dimensions != null) {
            for (int dim : dimensions) {
                req_builder.addDimensions(dim);
            }
        }
        if ((res = this.blockingStub.alocVar(req_builder.build())).getError() == 0) {
            return res.getId();
        }
        throw new RuntimeException("alocVar(int) failed with the following error code: " + res.getError());
    }

    public int allocate_float() {
        return this.allocate_float(null);
    }

    public int allocate_float(int ... dimensions) {
        AlocVarResult res;
        AlocVarRequest.Builder req_builder = AlocVarRequest.newBuilder().setDtype(5);
        if (dimensions != null) {
            for (int dim : dimensions) {
                req_builder.addDimensions(dim);
            }
        }
        if ((res = this.blockingStub.alocVar(req_builder.build())).getError() == 0) {
            return res.getId();
        }
        throw new RuntimeException("alocVar(float) failed with the following error code: " + res.getError());
    }

    public int allocate_double() {
        return this.allocate_double(null);
    }

    public int allocate_double(int ... dimensions) {
        AlocVarResult res;
        AlocVarRequest.Builder req_builder = AlocVarRequest.newBuilder().setDtype(6);
        if (dimensions != null) {
            for (int dim : dimensions) {
                req_builder.addDimensions(dim);
            }
        }
        if ((res = this.blockingStub.alocVar(req_builder.build())).getError() == 0) {
            return res.getId();
        }
        throw new RuntimeException("alocVar(double) failed with the following error code: " + res.getError());
    }

    public void free_variable(int id) {
        FreeVarRequest req = FreeVarRequest.newBuilder().setId(id).build();
        FreeVarResult res = this.blockingStub.freeVar(req);
        if (res.getError() != 0) {
            throw new RuntimeException("freeVar(" + id + ") failed with the following error code: " + res.getError());
        }
    }

    public void send_int(int id, int value) {
        SendIntRequest req = SendIntRequest.newBuilder().setId(id).addData(value).build();
        SendIntResult res = this.blockingStub.sendInt(req);
        if (res.getError() != 0) {
            throw new RuntimeException("sendInt(" + id + ", int) failed with the following error code: " + res.getError());
        }
    }

    public void send_int(int id, int[] value) {
        SendIntRequest.Builder req_builder = SendIntRequest.newBuilder().setId(id);
        for (int i = 0; i < value.length; ++i) {
            req_builder.addData(value[i]);
        }
        SendIntRequest req = req_builder.build();
        SendIntResult res = this.blockingStub.sendInt(req);
        if (res.getError() != 0) {
            throw new RuntimeException("sendInt(" + id + ", int[]) failed with the following error code: " + res.getError());
        }
    }

    public void send_int(int id, int[][] value) {
        SendIntRequest.Builder req_builder = SendIntRequest.newBuilder().setId(id);
        for (int i = 0; i < value.length; ++i) {
            for (int j = 0; j < value[0].length; ++j) {
                req_builder.addData(value[j][i]);
            }
        }
        SendIntRequest req = req_builder.build();
        SendIntResult res = this.blockingStub.sendInt(req);
        if (res.getError() != 0) {
            throw new RuntimeException("sendInt(" + id + ", int[][]) failed with the following error code: " + res.getError());
        }
    }

    public void send_float(int id, float value) {
        SendFltRequest req = SendFltRequest.newBuilder().setId(id).addData(value).build();
        SendFltResult res = this.blockingStub.sendFlt(req);
        if (res.getError() != 0) {
            throw new RuntimeException("sendFlt(" + id + ", float) failed with the following error code: " + res.getError());
        }
    }

    public void send_float(int id, float[] value) {
        SendFltRequest.Builder req_builder = SendFltRequest.newBuilder().setId(id);
        for (int i = 0; i < value.length; ++i) {
            req_builder.addData(value[i]);
        }
        SendFltRequest req = req_builder.build();
        SendFltResult res = this.blockingStub.sendFlt(req);
        if (res.getError() != 0) {
            throw new RuntimeException("sendFlt(" + id + ", float[]) failed with the following error code: " + res.getError());
        }
    }

    public void send_float(int id, float[][] value) {
        SendFltRequest.Builder req_builder = SendFltRequest.newBuilder().setId(id);
        for (int i = 0; i < value.length; ++i) {
            for (int j = 0; j < value[0].length; ++j) {
                req_builder.addData(value[j][i]);
            }
        }
        SendFltRequest req = req_builder.build();
        SendFltResult res = this.blockingStub.sendFlt(req);
        if (res.getError() != 0) {
            throw new RuntimeException("sendFlt(" + id + ", float[][]) failed with the following error code: " + res.getError());
        }
    }

    public void send_double(int id, double value) {
        SendDblRequest req = SendDblRequest.newBuilder().setId(id).addData(value).build();
        SendDblResult res = this.blockingStub.sendDbl(req);
        if (res.getError() != 0) {
            throw new RuntimeException("sendDbl(" + id + ", double) failed with the following error code: " + res.getError());
        }
    }

    public void send_double(int id, double[] value) {
        SendDblRequest.Builder req_builder = SendDblRequest.newBuilder().setId(id);
        for (int i = 0; i < value.length; ++i) {
            req_builder.addData(value[i]);
        }
        SendDblRequest req = req_builder.build();
        SendDblResult res = this.blockingStub.sendDbl(req);
        if (res.getError() != 0) {
            throw new RuntimeException("sendDbl(" + id + ", double[]) failed with the following error code: " + res.getError());
        }
    }

    public void send_double(int id, double[][] value) {
        SendDblRequest.Builder req_builder = SendDblRequest.newBuilder().setId(id);
        for (int i = 0; i < value.length; ++i) {
            for (int j = 0; j < value[0].length; ++j) {
                req_builder.addData(value[j][i]);
            }
        }
        SendDblRequest req = req_builder.build();
        SendDblResult res = this.blockingStub.sendDbl(req);
        if (res.getError() != 0) {
            throw new RuntimeException("sendDbl(" + id + ", double[][]) failed with the following error code: " + res.getError());
        }
    }

    public final int recv_int_0d(int id) {
        RecvIntRequest req = RecvIntRequest.newBuilder().setId(id).build();
        RecvIntResult res = this.blockingStub.recvInt(req);
        if (res.getError() == 0) {
            int num_data = res.getDataCount();
            if (num_data == 1) {
                return res.getData(0);
            }
            throw new RuntimeException("recvInt(" + id + ") delivered " + num_data + " values instead of 1");
        }
        throw new RuntimeException("recvInt(" + id + ") failed with the following error code: " + res.getError());
    }

    public final int[] recv_int_1d(int id) {
        RecvIntRequest req = RecvIntRequest.newBuilder().setId(id).build();
        RecvIntResult res = this.blockingStub.recvInt(req);
        if (res.getError() == 0) {
            int num_dims = res.getDimensionsCount();
            if (num_dims == 1) {
                int num_data = res.getDataCount();
                if (num_data > 0 && num_data == res.getDimensions(0)) {
                    int[] result = new int[num_data];
                    for (int i = 0; i < num_data; ++i) {
                        result[i] = res.getData(i);
                    }
                    return result;
                }
                throw new RuntimeException("recvInt(" + id + ") delivered " + num_data + " values; should be " + res.getDimensions(0));
            }
            throw new RuntimeException("recvInt(" + id + ") call gave too many dimensions: " + num_dims);
        }
        throw new RuntimeException("recvInt(" + id + ") failed with the following error code: " + res.getError());
    }

    public final int[][] recv_int_2d(int id) {
        RecvIntRequest req = RecvIntRequest.newBuilder().setId(id).build();
        RecvIntResult res = this.blockingStub.recvInt(req);
        if (res.getError() == 0) {
            int num_dims = res.getDimensionsCount();
            if (num_dims == 2) {
                int dim0 = res.getDimensions(0);
                int dim1 = res.getDimensions(1);
                int num_total = dim0 * dim1;
                int num_data = res.getDataCount();
                if (num_data > 0 && num_data == num_total) {
                    int[][] result = new int[dim0][dim1];
                    int idx = 0;
                    for (int j = 0; j < dim1; ++j) {
                        for (int i = 0; i < dim0; ++i) {
                            result[i][j] = res.getData(idx);
                            ++idx;
                        }
                    }
                    return result;
                }
                throw new RuntimeException("recvInt(" + id + ") delivered " + num_data + " values; should be " + num_total);
            }
            throw new RuntimeException("recvInt(" + id + ") call gave too many dimensions: " + num_dims);
        }
        throw new RuntimeException("recvInt(" + id + ") failed with the following error code: " + res.getError());
    }

    public final float recv_float_0d(int id) {
        RecvFltRequest req = RecvFltRequest.newBuilder().setId(id).build();
        RecvFltResult res = this.blockingStub.recvFlt(req);
        if (res.getError() == 0) {
            int num_data = res.getDataCount();
            if (num_data == 1) {
                return res.getData(0);
            }
            throw new RuntimeException("recvFlt(" + id + ") delivered " + num_data + " values instead of 1");
        }
        throw new RuntimeException("recvFlt(" + id + ") failed with the following error code: " + res.getError());
    }

    public final float[] recv_float_1d(int id) {
        RecvFltRequest req = RecvFltRequest.newBuilder().setId(id).build();
        RecvFltResult res = this.blockingStub.recvFlt(req);
        if (res.getError() == 0) {
            int num_dims = res.getDimensionsCount();
            if (num_dims == 1) {
                int num_data = res.getDataCount();
                if (num_data > 0 && num_data == res.getDimensions(0)) {
                    float[] result = new float[num_data];
                    for (int i = 0; i < num_data; ++i) {
                        result[i] = res.getData(i);
                    }
                    return result;
                }
                throw new RuntimeException("recvFlt(" + id + ") delivered " + num_data + " values; should be " + res.getDimensions(0));
            }
            throw new RuntimeException("recvFlt(" + id + ") call gave too many dimensions: " + num_dims);
        }
        throw new RuntimeException("recvFlt(" + id + ") failed with the following error code: " + res.getError());
    }

    public final float[][] recv_float_2d(int id) {
        RecvFltRequest req = RecvFltRequest.newBuilder().setId(id).build();
        RecvFltResult res = this.blockingStub.recvFlt(req);
        if (res.getError() == 0) {
            int num_dims = res.getDimensionsCount();
            if (num_dims == 2) {
                int dim0 = res.getDimensions(0);
                int dim1 = res.getDimensions(1);
                int num_total = dim0 * dim1;
                int num_data = res.getDataCount();
                if (num_data > 0 && num_data == num_total) {
                    float[][] result = new float[dim0][dim1];
                    int idx = 0;
                    for (int j = 0; j < dim1; ++j) {
                        for (int i = 0; i < dim0; ++i) {
                            result[i][j] = res.getData(idx);
                            ++idx;
                        }
                    }
                    return result;
                }
                throw new RuntimeException("recvFlt(" + id + ") delivered " + num_data + " values; should be " + num_total);
            }
            throw new RuntimeException("recvFlt(" + id + ") call gave too many dimensions: " + num_dims);
        }
        throw new RuntimeException("recvFlt(" + id + ") failed with the following error code: " + res.getError());
    }

    public final double recv_double_0d(int id) {
        RecvDblRequest req = RecvDblRequest.newBuilder().setId(id).build();
        RecvDblResult res = this.blockingStub.recvDbl(req);
        if (res.getError() == 0) {
            int num_data = res.getDataCount();
            if (num_data == 1) {
                return res.getData(0);
            }
            throw new RuntimeException("recvDbl(" + id + ") delivered " + num_data + " values instead of 1");
        }
        throw new RuntimeException("recvDbl(" + id + ") failed with the following error code: " + res.getError());
    }

    public final double[] recv_double_1d(int id) {
        RecvDblRequest req = RecvDblRequest.newBuilder().setId(id).build();
        RecvDblResult res = this.blockingStub.recvDbl(req);
        if (res.getError() == 0) {
            int num_dims = res.getDimensionsCount();
            if (num_dims == 1) {
                int num_data = res.getDataCount();
                if (num_data > 0 && num_data == res.getDimensions(0)) {
                    double[] result = new double[num_data];
                    for (int i = 0; i < num_data; ++i) {
                        result[i] = res.getData(i);
                    }
                    return result;
                }
                throw new RuntimeException("recvDbl(" + id + ") delivered " + num_data + " values; should be " + res.getDimensions(0));
            }
            throw new RuntimeException("recvDbl(" + id + ") call gave too many dimensions: " + num_dims);
        }
        throw new RuntimeException("recvDbl(" + id + ") failed with the following error code: " + res.getError());
    }

    public final double[][] recv_double_2d(int id) {
        RecvDblRequest req = RecvDblRequest.newBuilder().setId(id).build();
        RecvDblResult res = this.blockingStub.recvDbl(req);
        if (res.getError() == 0) {
            int num_dims = res.getDimensionsCount();
            if (num_dims == 2) {
                int dim0 = res.getDimensions(0);
                int dim1 = res.getDimensions(1);
                int num_total = dim0 * dim1;
                int num_data = res.getDataCount();
                if (num_data > 0 && num_data == num_total) {
                    double[][] result = new double[dim0][dim1];
                    int idx = 0;
                    for (int j = 0; j < dim1; ++j) {
                        for (int i = 0; i < dim0; ++i) {
                            result[i][j] = res.getData(idx);
                            ++idx;
                        }
                    }
                    return result;
                }
                throw new RuntimeException("recvDbl(" + id + ") delivered " + num_data + " values; should be " + num_total);
            }
            throw new RuntimeException("recvDbl(" + id + ") call gave too many dimensions: " + num_dims);
        }
        throw new RuntimeException("recvDbl(" + id + ") failed with the following error code: " + res.getError());
    }

    public static void main(String[] args) {
        RemoteComputationClient client = new RemoteComputationClient("localhost", 50051);
        client.reset();
        double a_send = 42.0;
        int id_a = client.allocate_double();
        client.send_double(id_a, a_send);
        double a_readback = client.recv_double_0d(id_a);
        System.out.println("a send=" + a_send + " readback=" + a_readback);
    }
}

