package de.labathome;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * Execute some code on a remove computer and keep possibility to interact on the fly.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.23.0)",
    comments = "Source: remoteComputationKernel.proto")
public final class RemoteComputationKernelGrpc {

  private RemoteComputationKernelGrpc() {}

  public static final String SERVICE_NAME = "rck.RemoteComputationKernel";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<de.labathome.ResetRequest,
      de.labathome.ResetResult> getResetMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Reset",
      requestType = de.labathome.ResetRequest.class,
      responseType = de.labathome.ResetResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<de.labathome.ResetRequest,
      de.labathome.ResetResult> getResetMethod() {
    io.grpc.MethodDescriptor<de.labathome.ResetRequest, de.labathome.ResetResult> getResetMethod;
    if ((getResetMethod = RemoteComputationKernelGrpc.getResetMethod) == null) {
      synchronized (RemoteComputationKernelGrpc.class) {
        if ((getResetMethod = RemoteComputationKernelGrpc.getResetMethod) == null) {
          RemoteComputationKernelGrpc.getResetMethod = getResetMethod =
              io.grpc.MethodDescriptor.<de.labathome.ResetRequest, de.labathome.ResetResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Reset"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.ResetRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.ResetResult.getDefaultInstance()))
              .setSchemaDescriptor(new RemoteComputationKernelMethodDescriptorSupplier("Reset"))
              .build();
        }
      }
    }
    return getResetMethod;
  }

  private static volatile io.grpc.MethodDescriptor<de.labathome.AlocVarRequest,
      de.labathome.AlocVarResult> getAlocVarMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "AlocVar",
      requestType = de.labathome.AlocVarRequest.class,
      responseType = de.labathome.AlocVarResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<de.labathome.AlocVarRequest,
      de.labathome.AlocVarResult> getAlocVarMethod() {
    io.grpc.MethodDescriptor<de.labathome.AlocVarRequest, de.labathome.AlocVarResult> getAlocVarMethod;
    if ((getAlocVarMethod = RemoteComputationKernelGrpc.getAlocVarMethod) == null) {
      synchronized (RemoteComputationKernelGrpc.class) {
        if ((getAlocVarMethod = RemoteComputationKernelGrpc.getAlocVarMethod) == null) {
          RemoteComputationKernelGrpc.getAlocVarMethod = getAlocVarMethod =
              io.grpc.MethodDescriptor.<de.labathome.AlocVarRequest, de.labathome.AlocVarResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "AlocVar"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.AlocVarRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.AlocVarResult.getDefaultInstance()))
              .setSchemaDescriptor(new RemoteComputationKernelMethodDescriptorSupplier("AlocVar"))
              .build();
        }
      }
    }
    return getAlocVarMethod;
  }

  private static volatile io.grpc.MethodDescriptor<de.labathome.FreeVarRequest,
      de.labathome.FreeVarResult> getFreeVarMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "FreeVar",
      requestType = de.labathome.FreeVarRequest.class,
      responseType = de.labathome.FreeVarResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<de.labathome.FreeVarRequest,
      de.labathome.FreeVarResult> getFreeVarMethod() {
    io.grpc.MethodDescriptor<de.labathome.FreeVarRequest, de.labathome.FreeVarResult> getFreeVarMethod;
    if ((getFreeVarMethod = RemoteComputationKernelGrpc.getFreeVarMethod) == null) {
      synchronized (RemoteComputationKernelGrpc.class) {
        if ((getFreeVarMethod = RemoteComputationKernelGrpc.getFreeVarMethod) == null) {
          RemoteComputationKernelGrpc.getFreeVarMethod = getFreeVarMethod =
              io.grpc.MethodDescriptor.<de.labathome.FreeVarRequest, de.labathome.FreeVarResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "FreeVar"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.FreeVarRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.FreeVarResult.getDefaultInstance()))
              .setSchemaDescriptor(new RemoteComputationKernelMethodDescriptorSupplier("FreeVar"))
              .build();
        }
      }
    }
    return getFreeVarMethod;
  }

  private static volatile io.grpc.MethodDescriptor<de.labathome.SendIntRequest,
      de.labathome.SendIntResult> getSendIntMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SendInt",
      requestType = de.labathome.SendIntRequest.class,
      responseType = de.labathome.SendIntResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<de.labathome.SendIntRequest,
      de.labathome.SendIntResult> getSendIntMethod() {
    io.grpc.MethodDescriptor<de.labathome.SendIntRequest, de.labathome.SendIntResult> getSendIntMethod;
    if ((getSendIntMethod = RemoteComputationKernelGrpc.getSendIntMethod) == null) {
      synchronized (RemoteComputationKernelGrpc.class) {
        if ((getSendIntMethod = RemoteComputationKernelGrpc.getSendIntMethod) == null) {
          RemoteComputationKernelGrpc.getSendIntMethod = getSendIntMethod =
              io.grpc.MethodDescriptor.<de.labathome.SendIntRequest, de.labathome.SendIntResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SendInt"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.SendIntRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.SendIntResult.getDefaultInstance()))
              .setSchemaDescriptor(new RemoteComputationKernelMethodDescriptorSupplier("SendInt"))
              .build();
        }
      }
    }
    return getSendIntMethod;
  }

  private static volatile io.grpc.MethodDescriptor<de.labathome.SendFltRequest,
      de.labathome.SendFltResult> getSendFltMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SendFlt",
      requestType = de.labathome.SendFltRequest.class,
      responseType = de.labathome.SendFltResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<de.labathome.SendFltRequest,
      de.labathome.SendFltResult> getSendFltMethod() {
    io.grpc.MethodDescriptor<de.labathome.SendFltRequest, de.labathome.SendFltResult> getSendFltMethod;
    if ((getSendFltMethod = RemoteComputationKernelGrpc.getSendFltMethod) == null) {
      synchronized (RemoteComputationKernelGrpc.class) {
        if ((getSendFltMethod = RemoteComputationKernelGrpc.getSendFltMethod) == null) {
          RemoteComputationKernelGrpc.getSendFltMethod = getSendFltMethod =
              io.grpc.MethodDescriptor.<de.labathome.SendFltRequest, de.labathome.SendFltResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SendFlt"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.SendFltRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.SendFltResult.getDefaultInstance()))
              .setSchemaDescriptor(new RemoteComputationKernelMethodDescriptorSupplier("SendFlt"))
              .build();
        }
      }
    }
    return getSendFltMethod;
  }

  private static volatile io.grpc.MethodDescriptor<de.labathome.SendDblRequest,
      de.labathome.SendDblResult> getSendDblMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SendDbl",
      requestType = de.labathome.SendDblRequest.class,
      responseType = de.labathome.SendDblResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<de.labathome.SendDblRequest,
      de.labathome.SendDblResult> getSendDblMethod() {
    io.grpc.MethodDescriptor<de.labathome.SendDblRequest, de.labathome.SendDblResult> getSendDblMethod;
    if ((getSendDblMethod = RemoteComputationKernelGrpc.getSendDblMethod) == null) {
      synchronized (RemoteComputationKernelGrpc.class) {
        if ((getSendDblMethod = RemoteComputationKernelGrpc.getSendDblMethod) == null) {
          RemoteComputationKernelGrpc.getSendDblMethod = getSendDblMethod =
              io.grpc.MethodDescriptor.<de.labathome.SendDblRequest, de.labathome.SendDblResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SendDbl"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.SendDblRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.SendDblResult.getDefaultInstance()))
              .setSchemaDescriptor(new RemoteComputationKernelMethodDescriptorSupplier("SendDbl"))
              .build();
        }
      }
    }
    return getSendDblMethod;
  }

  private static volatile io.grpc.MethodDescriptor<de.labathome.RecvIntRequest,
      de.labathome.RecvIntResult> getRecvIntMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RecvInt",
      requestType = de.labathome.RecvIntRequest.class,
      responseType = de.labathome.RecvIntResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<de.labathome.RecvIntRequest,
      de.labathome.RecvIntResult> getRecvIntMethod() {
    io.grpc.MethodDescriptor<de.labathome.RecvIntRequest, de.labathome.RecvIntResult> getRecvIntMethod;
    if ((getRecvIntMethod = RemoteComputationKernelGrpc.getRecvIntMethod) == null) {
      synchronized (RemoteComputationKernelGrpc.class) {
        if ((getRecvIntMethod = RemoteComputationKernelGrpc.getRecvIntMethod) == null) {
          RemoteComputationKernelGrpc.getRecvIntMethod = getRecvIntMethod =
              io.grpc.MethodDescriptor.<de.labathome.RecvIntRequest, de.labathome.RecvIntResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RecvInt"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.RecvIntRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.RecvIntResult.getDefaultInstance()))
              .setSchemaDescriptor(new RemoteComputationKernelMethodDescriptorSupplier("RecvInt"))
              .build();
        }
      }
    }
    return getRecvIntMethod;
  }

  private static volatile io.grpc.MethodDescriptor<de.labathome.RecvFltRequest,
      de.labathome.RecvFltResult> getRecvFltMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RecvFlt",
      requestType = de.labathome.RecvFltRequest.class,
      responseType = de.labathome.RecvFltResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<de.labathome.RecvFltRequest,
      de.labathome.RecvFltResult> getRecvFltMethod() {
    io.grpc.MethodDescriptor<de.labathome.RecvFltRequest, de.labathome.RecvFltResult> getRecvFltMethod;
    if ((getRecvFltMethod = RemoteComputationKernelGrpc.getRecvFltMethod) == null) {
      synchronized (RemoteComputationKernelGrpc.class) {
        if ((getRecvFltMethod = RemoteComputationKernelGrpc.getRecvFltMethod) == null) {
          RemoteComputationKernelGrpc.getRecvFltMethod = getRecvFltMethod =
              io.grpc.MethodDescriptor.<de.labathome.RecvFltRequest, de.labathome.RecvFltResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RecvFlt"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.RecvFltRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.RecvFltResult.getDefaultInstance()))
              .setSchemaDescriptor(new RemoteComputationKernelMethodDescriptorSupplier("RecvFlt"))
              .build();
        }
      }
    }
    return getRecvFltMethod;
  }

  private static volatile io.grpc.MethodDescriptor<de.labathome.RecvDblRequest,
      de.labathome.RecvDblResult> getRecvDblMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RecvDbl",
      requestType = de.labathome.RecvDblRequest.class,
      responseType = de.labathome.RecvDblResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<de.labathome.RecvDblRequest,
      de.labathome.RecvDblResult> getRecvDblMethod() {
    io.grpc.MethodDescriptor<de.labathome.RecvDblRequest, de.labathome.RecvDblResult> getRecvDblMethod;
    if ((getRecvDblMethod = RemoteComputationKernelGrpc.getRecvDblMethod) == null) {
      synchronized (RemoteComputationKernelGrpc.class) {
        if ((getRecvDblMethod = RemoteComputationKernelGrpc.getRecvDblMethod) == null) {
          RemoteComputationKernelGrpc.getRecvDblMethod = getRecvDblMethod =
              io.grpc.MethodDescriptor.<de.labathome.RecvDblRequest, de.labathome.RecvDblResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RecvDbl"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.RecvDblRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  de.labathome.RecvDblResult.getDefaultInstance()))
              .setSchemaDescriptor(new RemoteComputationKernelMethodDescriptorSupplier("RecvDbl"))
              .build();
        }
      }
    }
    return getRecvDblMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static RemoteComputationKernelStub newStub(io.grpc.Channel channel) {
    return new RemoteComputationKernelStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static RemoteComputationKernelBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new RemoteComputationKernelBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static RemoteComputationKernelFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new RemoteComputationKernelFutureStub(channel);
  }

  /**
   * <pre>
   * Execute some code on a remove computer and keep possibility to interact on the fly.
   * </pre>
   */
  public static abstract class RemoteComputationKernelImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * reset the server to a known state, i.e. free all variables
     * </pre>
     */
    public void reset(de.labathome.ResetRequest request,
        io.grpc.stub.StreamObserver<de.labathome.ResetResult> responseObserver) {
      asyncUnimplementedUnaryCall(getResetMethod(), responseObserver);
    }

    /**
     * <pre>
     * allocate a variable
     * </pre>
     */
    public void alocVar(de.labathome.AlocVarRequest request,
        io.grpc.stub.StreamObserver<de.labathome.AlocVarResult> responseObserver) {
      asyncUnimplementedUnaryCall(getAlocVarMethod(), responseObserver);
    }

    /**
     * <pre>
     * free a variable
     * </pre>
     */
    public void freeVar(de.labathome.FreeVarRequest request,
        io.grpc.stub.StreamObserver<de.labathome.FreeVarResult> responseObserver) {
      asyncUnimplementedUnaryCall(getFreeVarMethod(), responseObserver);
    }

    /**
     * <pre>
     * send data and save it in an already-allocated int variable
     * </pre>
     */
    public void sendInt(de.labathome.SendIntRequest request,
        io.grpc.stub.StreamObserver<de.labathome.SendIntResult> responseObserver) {
      asyncUnimplementedUnaryCall(getSendIntMethod(), responseObserver);
    }

    /**
     * <pre>
     * send data and save it in an already-allocated float variable
     * </pre>
     */
    public void sendFlt(de.labathome.SendFltRequest request,
        io.grpc.stub.StreamObserver<de.labathome.SendFltResult> responseObserver) {
      asyncUnimplementedUnaryCall(getSendFltMethod(), responseObserver);
    }

    /**
     * <pre>
     * send data and save it in an already-allocated double variable
     * </pre>
     */
    public void sendDbl(de.labathome.SendDblRequest request,
        io.grpc.stub.StreamObserver<de.labathome.SendDblResult> responseObserver) {
      asyncUnimplementedUnaryCall(getSendDblMethod(), responseObserver);
    }

    /**
     * <pre>
     * receive data from an already-allocated int variable
     * </pre>
     */
    public void recvInt(de.labathome.RecvIntRequest request,
        io.grpc.stub.StreamObserver<de.labathome.RecvIntResult> responseObserver) {
      asyncUnimplementedUnaryCall(getRecvIntMethod(), responseObserver);
    }

    /**
     * <pre>
     * receive data from an already-allocated float variable
     * </pre>
     */
    public void recvFlt(de.labathome.RecvFltRequest request,
        io.grpc.stub.StreamObserver<de.labathome.RecvFltResult> responseObserver) {
      asyncUnimplementedUnaryCall(getRecvFltMethod(), responseObserver);
    }

    /**
     * <pre>
     * receive data from an already-allocated double variable
     * </pre>
     */
    public void recvDbl(de.labathome.RecvDblRequest request,
        io.grpc.stub.StreamObserver<de.labathome.RecvDblResult> responseObserver) {
      asyncUnimplementedUnaryCall(getRecvDblMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getResetMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                de.labathome.ResetRequest,
                de.labathome.ResetResult>(
                  this, METHODID_RESET)))
          .addMethod(
            getAlocVarMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                de.labathome.AlocVarRequest,
                de.labathome.AlocVarResult>(
                  this, METHODID_ALOC_VAR)))
          .addMethod(
            getFreeVarMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                de.labathome.FreeVarRequest,
                de.labathome.FreeVarResult>(
                  this, METHODID_FREE_VAR)))
          .addMethod(
            getSendIntMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                de.labathome.SendIntRequest,
                de.labathome.SendIntResult>(
                  this, METHODID_SEND_INT)))
          .addMethod(
            getSendFltMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                de.labathome.SendFltRequest,
                de.labathome.SendFltResult>(
                  this, METHODID_SEND_FLT)))
          .addMethod(
            getSendDblMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                de.labathome.SendDblRequest,
                de.labathome.SendDblResult>(
                  this, METHODID_SEND_DBL)))
          .addMethod(
            getRecvIntMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                de.labathome.RecvIntRequest,
                de.labathome.RecvIntResult>(
                  this, METHODID_RECV_INT)))
          .addMethod(
            getRecvFltMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                de.labathome.RecvFltRequest,
                de.labathome.RecvFltResult>(
                  this, METHODID_RECV_FLT)))
          .addMethod(
            getRecvDblMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                de.labathome.RecvDblRequest,
                de.labathome.RecvDblResult>(
                  this, METHODID_RECV_DBL)))
          .build();
    }
  }

  /**
   * <pre>
   * Execute some code on a remove computer and keep possibility to interact on the fly.
   * </pre>
   */
  public static final class RemoteComputationKernelStub extends io.grpc.stub.AbstractStub<RemoteComputationKernelStub> {
    private RemoteComputationKernelStub(io.grpc.Channel channel) {
      super(channel);
    }

    private RemoteComputationKernelStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected RemoteComputationKernelStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new RemoteComputationKernelStub(channel, callOptions);
    }

    /**
     * <pre>
     * reset the server to a known state, i.e. free all variables
     * </pre>
     */
    public void reset(de.labathome.ResetRequest request,
        io.grpc.stub.StreamObserver<de.labathome.ResetResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getResetMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * allocate a variable
     * </pre>
     */
    public void alocVar(de.labathome.AlocVarRequest request,
        io.grpc.stub.StreamObserver<de.labathome.AlocVarResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getAlocVarMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * free a variable
     * </pre>
     */
    public void freeVar(de.labathome.FreeVarRequest request,
        io.grpc.stub.StreamObserver<de.labathome.FreeVarResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getFreeVarMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * send data and save it in an already-allocated int variable
     * </pre>
     */
    public void sendInt(de.labathome.SendIntRequest request,
        io.grpc.stub.StreamObserver<de.labathome.SendIntResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSendIntMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * send data and save it in an already-allocated float variable
     * </pre>
     */
    public void sendFlt(de.labathome.SendFltRequest request,
        io.grpc.stub.StreamObserver<de.labathome.SendFltResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSendFltMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * send data and save it in an already-allocated double variable
     * </pre>
     */
    public void sendDbl(de.labathome.SendDblRequest request,
        io.grpc.stub.StreamObserver<de.labathome.SendDblResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSendDblMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * receive data from an already-allocated int variable
     * </pre>
     */
    public void recvInt(de.labathome.RecvIntRequest request,
        io.grpc.stub.StreamObserver<de.labathome.RecvIntResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRecvIntMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * receive data from an already-allocated float variable
     * </pre>
     */
    public void recvFlt(de.labathome.RecvFltRequest request,
        io.grpc.stub.StreamObserver<de.labathome.RecvFltResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRecvFltMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * receive data from an already-allocated double variable
     * </pre>
     */
    public void recvDbl(de.labathome.RecvDblRequest request,
        io.grpc.stub.StreamObserver<de.labathome.RecvDblResult> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRecvDblMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Execute some code on a remove computer and keep possibility to interact on the fly.
   * </pre>
   */
  public static final class RemoteComputationKernelBlockingStub extends io.grpc.stub.AbstractStub<RemoteComputationKernelBlockingStub> {
    private RemoteComputationKernelBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private RemoteComputationKernelBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected RemoteComputationKernelBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new RemoteComputationKernelBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * reset the server to a known state, i.e. free all variables
     * </pre>
     */
    public de.labathome.ResetResult reset(de.labathome.ResetRequest request) {
      return blockingUnaryCall(
          getChannel(), getResetMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * allocate a variable
     * </pre>
     */
    public de.labathome.AlocVarResult alocVar(de.labathome.AlocVarRequest request) {
      return blockingUnaryCall(
          getChannel(), getAlocVarMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * free a variable
     * </pre>
     */
    public de.labathome.FreeVarResult freeVar(de.labathome.FreeVarRequest request) {
      return blockingUnaryCall(
          getChannel(), getFreeVarMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * send data and save it in an already-allocated int variable
     * </pre>
     */
    public de.labathome.SendIntResult sendInt(de.labathome.SendIntRequest request) {
      return blockingUnaryCall(
          getChannel(), getSendIntMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * send data and save it in an already-allocated float variable
     * </pre>
     */
    public de.labathome.SendFltResult sendFlt(de.labathome.SendFltRequest request) {
      return blockingUnaryCall(
          getChannel(), getSendFltMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * send data and save it in an already-allocated double variable
     * </pre>
     */
    public de.labathome.SendDblResult sendDbl(de.labathome.SendDblRequest request) {
      return blockingUnaryCall(
          getChannel(), getSendDblMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * receive data from an already-allocated int variable
     * </pre>
     */
    public de.labathome.RecvIntResult recvInt(de.labathome.RecvIntRequest request) {
      return blockingUnaryCall(
          getChannel(), getRecvIntMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * receive data from an already-allocated float variable
     * </pre>
     */
    public de.labathome.RecvFltResult recvFlt(de.labathome.RecvFltRequest request) {
      return blockingUnaryCall(
          getChannel(), getRecvFltMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * receive data from an already-allocated double variable
     * </pre>
     */
    public de.labathome.RecvDblResult recvDbl(de.labathome.RecvDblRequest request) {
      return blockingUnaryCall(
          getChannel(), getRecvDblMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Execute some code on a remove computer and keep possibility to interact on the fly.
   * </pre>
   */
  public static final class RemoteComputationKernelFutureStub extends io.grpc.stub.AbstractStub<RemoteComputationKernelFutureStub> {
    private RemoteComputationKernelFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private RemoteComputationKernelFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected RemoteComputationKernelFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new RemoteComputationKernelFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * reset the server to a known state, i.e. free all variables
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<de.labathome.ResetResult> reset(
        de.labathome.ResetRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getResetMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * allocate a variable
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<de.labathome.AlocVarResult> alocVar(
        de.labathome.AlocVarRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getAlocVarMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * free a variable
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<de.labathome.FreeVarResult> freeVar(
        de.labathome.FreeVarRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getFreeVarMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * send data and save it in an already-allocated int variable
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<de.labathome.SendIntResult> sendInt(
        de.labathome.SendIntRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getSendIntMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * send data and save it in an already-allocated float variable
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<de.labathome.SendFltResult> sendFlt(
        de.labathome.SendFltRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getSendFltMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * send data and save it in an already-allocated double variable
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<de.labathome.SendDblResult> sendDbl(
        de.labathome.SendDblRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getSendDblMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * receive data from an already-allocated int variable
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<de.labathome.RecvIntResult> recvInt(
        de.labathome.RecvIntRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRecvIntMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * receive data from an already-allocated float variable
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<de.labathome.RecvFltResult> recvFlt(
        de.labathome.RecvFltRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRecvFltMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * receive data from an already-allocated double variable
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<de.labathome.RecvDblResult> recvDbl(
        de.labathome.RecvDblRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRecvDblMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_RESET = 0;
  private static final int METHODID_ALOC_VAR = 1;
  private static final int METHODID_FREE_VAR = 2;
  private static final int METHODID_SEND_INT = 3;
  private static final int METHODID_SEND_FLT = 4;
  private static final int METHODID_SEND_DBL = 5;
  private static final int METHODID_RECV_INT = 6;
  private static final int METHODID_RECV_FLT = 7;
  private static final int METHODID_RECV_DBL = 8;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final RemoteComputationKernelImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(RemoteComputationKernelImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_RESET:
          serviceImpl.reset((de.labathome.ResetRequest) request,
              (io.grpc.stub.StreamObserver<de.labathome.ResetResult>) responseObserver);
          break;
        case METHODID_ALOC_VAR:
          serviceImpl.alocVar((de.labathome.AlocVarRequest) request,
              (io.grpc.stub.StreamObserver<de.labathome.AlocVarResult>) responseObserver);
          break;
        case METHODID_FREE_VAR:
          serviceImpl.freeVar((de.labathome.FreeVarRequest) request,
              (io.grpc.stub.StreamObserver<de.labathome.FreeVarResult>) responseObserver);
          break;
        case METHODID_SEND_INT:
          serviceImpl.sendInt((de.labathome.SendIntRequest) request,
              (io.grpc.stub.StreamObserver<de.labathome.SendIntResult>) responseObserver);
          break;
        case METHODID_SEND_FLT:
          serviceImpl.sendFlt((de.labathome.SendFltRequest) request,
              (io.grpc.stub.StreamObserver<de.labathome.SendFltResult>) responseObserver);
          break;
        case METHODID_SEND_DBL:
          serviceImpl.sendDbl((de.labathome.SendDblRequest) request,
              (io.grpc.stub.StreamObserver<de.labathome.SendDblResult>) responseObserver);
          break;
        case METHODID_RECV_INT:
          serviceImpl.recvInt((de.labathome.RecvIntRequest) request,
              (io.grpc.stub.StreamObserver<de.labathome.RecvIntResult>) responseObserver);
          break;
        case METHODID_RECV_FLT:
          serviceImpl.recvFlt((de.labathome.RecvFltRequest) request,
              (io.grpc.stub.StreamObserver<de.labathome.RecvFltResult>) responseObserver);
          break;
        case METHODID_RECV_DBL:
          serviceImpl.recvDbl((de.labathome.RecvDblRequest) request,
              (io.grpc.stub.StreamObserver<de.labathome.RecvDblResult>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class RemoteComputationKernelBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    RemoteComputationKernelBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return de.labathome.RCK.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("RemoteComputationKernel");
    }
  }

  private static final class RemoteComputationKernelFileDescriptorSupplier
      extends RemoteComputationKernelBaseDescriptorSupplier {
    RemoteComputationKernelFileDescriptorSupplier() {}
  }

  private static final class RemoteComputationKernelMethodDescriptorSupplier
      extends RemoteComputationKernelBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    RemoteComputationKernelMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (RemoteComputationKernelGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new RemoteComputationKernelFileDescriptorSupplier())
              .addMethod(getResetMethod())
              .addMethod(getAlocVarMethod())
              .addMethod(getFreeVarMethod())
              .addMethod(getSendIntMethod())
              .addMethod(getSendFltMethod())
              .addMethod(getSendDblMethod())
              .addMethod(getRecvIntMethod())
              .addMethod(getRecvFltMethod())
              .addMethod(getRecvDblMethod())
              .build();
        }
      }
    }
    return result;
  }
}
