/*
 * Decompiled with CFR 0.152.
 */
package util.json;

import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import util.json.JSONException;

public class Encoder {
    StringBuilder buf = new StringBuilder();
    List circ = new LinkedList();

    Encoder() {
    }

    static void encode(StringBuilder buf, CharSequence s) {
        char c = '\u0000';
        buf.append('\"');
        block3: for (int i = 0; i != s.length(); ++i) {
            c = s.charAt(i);
            if (Character.isISOControl(c)) continue;
            switch (c) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\"': 
                case '\\': {
                    buf.append('\\');
                    buf.append(c);
                    continue block3;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        buf.append('\"');
    }

    static void encode(StringBuilder buf, Number n) {
        buf.append(n.toString());
    }

    static void encode(StringBuilder buf, boolean b) {
        if (b) {
            buf.append("true");
        } else {
            buf.append("false");
        }
    }

    static void encode(StringBuilder buf, int i) {
        buf.append(i);
    }

    static void encode(StringBuilder buf, long i) {
        buf.append(i);
    }

    static void encode(StringBuilder buf, float i) {
        buf.append(i);
    }

    static void encode(StringBuilder buf, double i) {
        buf.append(i);
    }

    static void encode(StringBuilder buf, byte i) {
        buf.append(i);
    }

    static void encode(StringBuilder buf, short i) {
        buf.append(i);
    }

    static void encode(StringBuilder buf, char c) {
        buf.append((int)c);
    }

    boolean canEncode(Object o) {
        return true;
    }

    void encodeCustom(Object o) {
        this.error("unexpected object: " + o.getClass());
    }

    void encode(Object o) {
        if (null == o) {
            this.buf.append("null");
            return;
        }
        if (o instanceof Map) {
            this.encode((Map)o);
        } else if (o instanceof List) {
            this.encode((List)o);
        } else if (o instanceof Number) {
            Encoder.encode(this.buf, (Number)o);
        } else if (o instanceof CharSequence) {
            Encoder.encode(this.buf, (CharSequence)o);
        } else if (o instanceof Character) {
            Encoder.encode(this.buf, ((Character)o).charValue());
        } else if (o instanceof Boolean) {
            Encoder.encode(this.buf, (Boolean)o);
        } else if (o.getClass().isArray()) {
            this.encodeArray(o);
        } else if (this.canEncode(o)) {
            this.encodeCustom(o);
        } else {
            this.error(o.getClass());
        }
    }

    void error(Object o) {
        throw new JSONException(o.toString());
    }

    void encode(Map m) {
        this.checkCircular(m);
        this.buf.append('{');
        for (Object k : m.keySet()) {
            Object v = m.get(k);
            Encoder.encode(this.buf, k.toString());
            this.buf.append(':');
            this.encode(v);
            this.buf.append(",");
        }
        this.buf.setCharAt(this.buf.length() - 1, '}');
    }

    void encode(List l) {
        this.checkCircular(l);
        this.buf.append('[');
        for (Object k : l) {
            this.encode(k);
            this.buf.append(",");
        }
        this.buf.setCharAt(this.buf.length() - 1, ']');
    }

    void encodeArray(Object arr) {
        this.checkCircular(arr);
        assert (arr.getClass().isArray());
        this.buf.append('[');
        Object o = null;
        int i = 0;
        while (true) {
            try {
                o = Array.get(arr, i);
                this.encode(o);
                this.buf.append(",");
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                break;
            }
            ++i;
        }
        this.buf.setCharAt(this.buf.length() - 1, ']');
    }

    void checkCircular(Object m) {
        if (this.circ.contains(m)) {
            this.error("circular");
        } else {
            this.circ.add(m);
        }
    }
}

