/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;

public class IO {
    public static void readLines(InputStream is, LineCallback cb) {
        BufferedReader buf = new BufferedReader(new InputStreamReader(is));
        LineNumberReader reader = new LineNumberReader(buf);
        try {
            String line;
            while (null != (line = reader.readLine())) {
                cb.line(line, reader.getLineNumber());
            }
        }
        catch (IOException e) {
            cb.exceptionEncountered(e);
            throw new WrappedException(e);
        }
        finally {
            IO.close(is);
            cb.done();
        }
    }

    public static byte[] readAll(String filename) {
        try {
            FileInputStream fis = new FileInputStream(filename);
            return IO.readAll(fis);
        }
        catch (FileNotFoundException e) {
            throw new WrappedException(e);
        }
    }

    public static String readAllString(String filename) {
        try {
            FileInputStream fis = new FileInputStream(filename);
            return IO.readAllString(fis);
        }
        catch (FileNotFoundException fnf) {
            throw new WrappedException(fnf);
        }
    }

    public static String readAllString(InputStream is) {
        String string;
        InputStreamReader reader = null;
        try {
            int i;
            reader = new InputStreamReader(is);
            char[] c = new char[1024];
            StringBuilder builder = new StringBuilder();
            while (-1 != (i = reader.read(c))) {
                builder.append(c, 0, i);
            }
            string = builder.toString();
        }
        catch (IOException ioe) {
            try {
                throw new WrappedException(ioe);
            }
            catch (Throwable throwable) {
                IO.close(reader);
                throw throwable;
            }
        }
        IO.close(reader);
        return string;
    }

    public static byte[] readAll(InputStream is) {
        return IO.readAll(is, 1024);
    }

    public static byte[] readAll(InputStream is, int chunkSize) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunk size can't be <1");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] bytes = new byte[chunkSize];
        try {
            int read;
            while (-1 != (read = is.read(bytes))) {
                bos.write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            throw new WrappedException(e);
        }
        finally {
            IO.close(is);
        }
        return bos.toByteArray();
    }

    public static void writeAll(byte[] bs, String fn) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fn);
            IO.writeAll(bs, fos);
        }
        catch (FileNotFoundException e) {
            try {
                throw new WrappedException(e);
            }
            catch (Throwable throwable) {
                IO.close(fos);
                throw throwable;
            }
        }
        IO.close(fos);
    }

    public static void writeAll(byte[] bs, OutputStream os) {
        try {
            os.write(bs);
        }
        catch (IOException e) {
            throw new WrappedException(e);
        }
        finally {
            IO.close(os);
        }
    }

    public static boolean close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static String filenameRelativeTo(String filename, String relativeTo) {
        File f = new File(filename);
        if (f.isAbsolute()) {
            return filename;
        }
        return IO.getPath(relativeTo) + File.separator + filename;
    }

    public static String getPath(String fn) {
        if (fn == null) {
            return null;
        }
        int i = fn.lastIndexOf(File.separator);
        return i > -1 ? fn.substring(0, i) : fn;
    }

    public static abstract class LineCallback {
        public void line(String line, int lineNumber) {
            this.line(line);
        }

        public void line(String line) {
        }

        public void done() {
        }

        public void exceptionEncountered(IOException ioe) {
        }
    }

    public static class WrappedException
    extends RuntimeException {
        public WrappedException(IOException e) {
            super(e);
        }
    }
}

