/*
 * Decompiled with CFR 0.152.
 */
package util.crypto;

import java.security.Provider;
import java.security.PublicKey;
import javax.crypto.Cipher;
import util.bytes.Bytes;
import util.bytes.hexy.Hexy;
import util.crypto.KeyPair;

public class Main {
    public static void main(String[] args) throws Throwable {
        byte[] data = Bytes.h2b("85C99C14 0884AE40EC97333A 57FF3AF59116B5AA FCE9FC18BEA41A4B 4262DCDAA014DA9E A0337C62235A06C8 A51101D6CACB237B F44FBD8647AA6E9A 27794C51401657B2 84DFFB55DBD18DFE FE0E5AEB578BCDA9 AEAAD8B66696AC73 75BA430B8FB2454E 732A28792B51055A C9A795F58816BFCE 59CAA00A015BDAB9 60BB882EC3CBD6D4 A7CA9A1DF4E12301 2E53E652EE7FF2D7 4F6C5A4E436FEBF5 AD040D6BBEB41372 4C41ACE515EA4193 917295F4");
        byte[] modulus = Bytes.h2b("A1F5E1C9BD8650BD43AB6EE56B891EF7459C0A24FA84F9127D1A6C79D4930F6DB1852E2510F18B61CD354DB83A356BD190B88AB8DF04284D02A4204A7B6CB7C5551977A9B36379CA3DE1A08E69F301C95CC1C20506959275F41723DD5D2925290579E5A95B0DF6323FC8E9273D6F849198C4996209166D9BFC973C361CC826E1");
        Main.p("size modulus: " + modulus.length);
        byte[] exponent = new byte[]{3};
        Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
        PublicKey key = KeyPair.getRSAPublicKeyFromModulusAndExponent(modulus, exponent);
        Main.p(data.length);
        cipher.init(1, key);
        byte[] result = cipher.doFinal(data);
        Main.p(Bytes.b2h(result));
        Main.p(Hexy.toString(result));
        Main.p(cipher);
    }

    private static void dumpProvider(Provider provider) {
        Main.p("------------------------------------------------------------------------");
        Main.p("Provider: " + provider.getName());
        Main.p("Services: ");
        for (Provider.Service service : provider.getServices()) {
            Main.p(service);
        }
        Main.p("------------------------------------------------------------------------");
    }

    static void p(Object s) {
        System.out.println(s);
    }

    static void p(Object[] os) {
        for (Object o : os) {
            Main.p(o);
        }
    }

    static void p(byte[] bs) {
        for (byte b : bs) {
            Main.p(b);
        }
    }

    public void test(byte[] testdata) {
        Object is = null;
    }

    static enum TestEnum {
        bla_2000;

    }
}

