/*
 * Decompiled with CFR 0.152.
 */
package util.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import util.crypto.Hash;
import util.crypto.Random;
import util.crypto.WrappedException;

public class HMAC {
    public static byte[] generateKey(Hash.Algorithm a) {
        return Random.random(a.blockSizeBytes());
    }

    public static SecretKey generateJCAKey(Hash.Algorithm a) {
        byte[] keyBytes = HMAC.generateKey(a);
        return new SecretKeySpec(keyBytes, a.jcaHmacName());
    }

    public static byte[] hmacMD5(byte[] key, byte[] ... data) {
        return HMAC.hmac(Hash.Algorithm.MD5, key, data);
    }

    public static byte[] hmacSHA1(byte[] key, byte[] ... data) {
        return HMAC.hmac(Hash.Algorithm.SHA1, key, data);
    }

    public static byte[] hmacSHA256(byte[] key, byte[] ... data) {
        return HMAC.hmac(Hash.Algorithm.SHA256, key, data);
    }

    public static byte[] hmacSHA384(byte[] key, byte[] ... data) {
        return HMAC.hmac(Hash.Algorithm.SHA384, key, data);
    }

    public static byte[] hmacSHA512(byte[] key, byte[] ... data) {
        return HMAC.hmac(Hash.Algorithm.SHA512, key, data);
    }

    public static byte[] hmac(Hash.Algorithm algo, byte[] key, byte[] ... data) {
        try {
            SecretKeySpec k = new SecretKeySpec(key, algo.jcaHmacName());
            Mac mac = Mac.getInstance(algo.jcaHmacName());
            mac.init(k);
            for (byte[] bytes : data) {
                mac.update(bytes);
            }
            return mac.doFinal();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new WrappedException(e);
        }
    }
}

