/*
 * Decompiled with CFR 0.152.
 */
package util.bytes.hexy;

public class Hexy {
    static final byte[] EMPTY = new byte[0];
    static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    byte[] bytes;
    Config cfg;
    String indent;

    public Hexy(byte[] bytes) {
        this(bytes, new Config());
    }

    public Hexy(byte[] bytes, Config cfg) {
        this(cfg);
        this.bytes = bytes == null ? EMPTY : bytes;
    }

    public Hexy() {
        this(new Config());
    }

    public Hexy(Config cfg) {
        this.cfg = cfg;
    }

    public static String toString(byte[] bytes) {
        return new Hexy(bytes).toString();
    }

    public static String toHex(byte b, boolean upper) {
        char[] map = upper ? HEX : hex;
        char[] strChars = new char[]{map[(b & 0xF0) >> 4], map[b & 0xF0]};
        return new String(strChars);
    }

    public static String toHex(byte[] bs, boolean upper) {
        char[] map = upper ? HEX : hex;
        StringBuilder builder = new StringBuilder();
        for (byte b : bs) {
            builder.append(map[(b & 0xF0) >> 4]);
            builder.append(map[b & 0xF]);
        }
        return builder.toString();
    }

    public static String toString(String bytes) {
        if (null == bytes) {
            return "";
        }
        return Hexy.toString(bytes.getBytes());
    }

    private static byte[] get(byte[] bytes, int offset, int num) {
        if (offset >= bytes.length) {
            return EMPTY;
        }
        int d = offset + num - bytes.length;
        if (d > 0) {
            num -= d;
        }
        byte[] ret = new byte[num];
        System.arraycopy(bytes, offset, ret, 0, num);
        return ret;
    }

    static void p(Object o) {
        System.out.println(o);
    }

    private String getIndent() {
        if (null == this.indent) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i != this.cfg.indent; ++i) {
                b.append(" ");
            }
            b.append(this.cfg.prefix);
            this.indent = b.toString();
        }
        return this.indent;
    }

    public String hexDump(byte[] bytes) {
        return this.getString(bytes);
    }

    public String getString(byte[] bytes) {
        bytes = bytes == null ? EMPTY : bytes;
        StringBuilder builder = new StringBuilder();
        String tmp = null;
        for (int i = 0; i < bytes.length; i += this.cfg.width) {
            int j;
            byte[] bs = Hexy.get(bytes, i, this.cfg.width);
            builder.append(this.getIndent());
            if (Numbering.HEX_BYTES == this.cfg.numbering) {
                builder.append(String.format("%07X: ", i));
            } else if (Numbering.BASE_10 == this.cfg.numbering) {
                builder.append(String.format("%07d: ", i));
            }
            if (Format.FOURS == this.cfg.format) {
                for (j = 0; j < this.cfg.width; j += 2) {
                    byte[] printb = Hexy.get(bs, j, 2);
                    tmp = Hexy.toHex(printb, this.cfg.upper);
                    while (4 != tmp.length()) {
                        tmp = tmp + "  ";
                    }
                    builder.append(tmp);
                    builder.append(" ");
                }
            } else {
                for (j = 0; j != this.cfg.width; ++j) {
                    byte[] printb = Hexy.get(bs, j, 1);
                    tmp = Hexy.toHex(printb, this.cfg.upper);
                    if (2 != tmp.length()) {
                        tmp = tmp + "  ";
                    }
                    builder.append(tmp);
                    if (Format.TWOS != this.cfg.format) continue;
                    builder.append(" ");
                    if (j + 1 != this.cfg.width / 2) continue;
                    builder.append(" ");
                }
            }
            if (Annotate.ASCII == this.cfg.annotate) {
                builder.append(" ");
                for (j = 0; j != this.cfg.width && j != bs.length; ++j) {
                    char b = (char)bs[j];
                    if ('\u007f' > b && '\u0019' < b) {
                        builder.append(b);
                        continue;
                    }
                    builder.append('.');
                }
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public String getString() {
        return this.getString(this.bytes);
    }

    public String toString() {
        return this.getString();
    }

    public static class Config {
        public int width = 16;
        public Numbering numbering = Numbering.NONE;
        public Format format = Format.TWOS;
        public boolean upper;
        public Annotate annotate = Annotate.ASCII;
        public String prefix = "";
        public int indent = 0;
    }

    public static enum Annotate {
        NONE,
        ASCII;

    }

    public static enum Format {
        NONE,
        TWOS,
        FOURS;

    }

    public static enum Numbering {
        NONE,
        HEX_BYTES,
        BASE_10;

    }
}

