/*
 * Decompiled with CFR 0.152.
 */
package util.bytes;

import java.util.Arrays;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Bytes {
    static final byte[] EMPTY = new byte[0];
    static final byte[] hex = "0123456789abcdef".getBytes();
    static final Pattern WS = Pattern.compile("\\s+");
    private static Random rnd = new Random();

    public static String b2h(byte[] bytes) {
        if (null == bytes) {
            return "";
        }
        return Bytes.b2h(bytes, 0, bytes.length);
    }

    public static String b2h(byte[] bytes, int offset, int count) {
        byte[] hexBytes = new byte[count * 2];
        for (int j = 0; j < count; ++j) {
            int v = bytes[j + offset] & 0xFF;
            hexBytes[j * 2] = hex[v >>> 4];
            hexBytes[j * 2 + 1] = hex[v & 0xF];
        }
        return new String(hexBytes);
    }

    public static byte[] h2b(String hex) {
        if (null == hex || "".equals(hex)) {
            return EMPTY;
        }
        Matcher m = WS.matcher(hex);
        if ((hex = m.replaceAll("")).length() % 2 != 0) {
            throw new NumberFormatException("uneven number of hex chars");
        }
        byte[] data = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length(); i += 2) {
            data[i / 2] = (byte)(Bytes.h2b(hex.charAt(i)) << 4 | Bytes.h2b(hex.charAt(i + 1)));
        }
        return data;
    }

    private static byte h2b(char c) {
        int i = Character.digit(c, 16);
        if (i == -1) {
            throw new NumberFormatException("Invalid hex char: `" + c + "`");
        }
        return (byte)i;
    }

    public static String b2s(byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        for (byte b : bytes) {
            int i = b & 0xFF;
            if (i >= 32 && i < 127) {
                buf.append((char)i);
                continue;
            }
            buf.append('.');
        }
        return buf.toString();
    }

    public static byte[] random(int count) {
        byte[] bs = new byte[count];
        rnd.nextBytes(bs);
        return bs;
    }

    public static byte[] append(byte[] ... data) {
        if (data == null) {
            throw new NullPointerException();
        }
        int len = 0;
        for (byte[] bs : data) {
            if (null == bs) {
                throw new NullPointerException();
            }
            len += bs.length;
        }
        byte[] joined = new byte[len];
        int pos = 0;
        for (byte[] bs : data) {
            System.arraycopy(bs, 0, joined, pos, bs.length);
            pos += bs.length;
        }
        return joined;
    }

    public static byte[][] split(byte[] bytes, int pos) {
        if (bytes == null || pos < 0 || pos >= bytes.length) {
            throw new IllegalArgumentException("bytes or pos invalid");
        }
        byte[] bs_one = new byte[pos];
        byte[] bs_two = new byte[bytes.length - pos];
        System.arraycopy(bytes, 0, bs_one, 0, pos);
        System.arraycopy(bytes, pos, bs_two, 0, bytes.length - pos);
        return new byte[][]{bs_one, bs_two};
    }

    public static void main(String[] args) {
        Bytes.p(Bytes.b2s(Bytes.h2b("5448884063169011D1711201158090354F")));
    }

    public static String i2h(int i) {
        return Integer.toHexString(i);
    }

    public static String[] dissect(byte[] bytes, int[] lens) {
        int sum = 0;
        for (int j : lens) {
            sum += j;
        }
        if (bytes == null || bytes.length != sum) {
            return null;
        }
        String[] res = new String[lens.length];
        int pos = 0;
        for (int i = 0; i != lens.length; ++i) {
            res[i] = Bytes.b2h(Arrays.copyOfRange(bytes, pos, lens[i]));
            pos += lens[i];
        }
        return res;
    }

    public static void p(Object o) {
        System.out.println(o);
    }

    public static void p(byte[] bytes) {
        Bytes.p(Bytes.b2h(bytes));
    }
}

