/*
 * Decompiled with CFR 0.152.
 */
package util.benchmark;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.benchmark.BenchmarkResult;
import util.benchmark.InternalBenchmark;

public class Benchmark {
    public int N;
    InternalBenchmark internal;
    long ns;
    long bytes;
    long start;

    static long min(long x, long y) {
        return x > y ? y : x;
    }

    static long max(long x, long y) {
        return x < y ? y : x;
    }

    static int roundDown10(int n) {
        int tens = 0;
        while (n > 10) {
            n /= 10;
            ++tens;
        }
        int result = 1;
        for (int i = 0; i < tens; ++i) {
            result *= 10;
        }
        return result;
    }

    static int roundUp(int n) {
        int base = Benchmark.roundDown10(n);
        if (n < 2 * base) {
            return 2 * base;
        }
        if (n < 5 * base) {
            return 5 * base;
        }
        return 10 * base;
    }

    static boolean hasBenchmarkParam(Method m) {
        Class<?>[] paramTypes = m.getParameterTypes();
        if (paramTypes == null || paramTypes.length != 1) {
            return false;
        }
        return paramTypes[0].equals(Benchmark.class);
    }

    public static void runBenchmark(final Class c, String regexp) throws InstantiationException, IllegalAccessException {
        Pattern pattern = null;
        if (null != regexp) {
            pattern = Pattern.compile(regexp);
        }
        ArrayList<Method> list = new ArrayList<Method>();
        int maxName = 0;
        for (Method m : c.getMethods()) {
            Matcher matcher;
            if (m.getReturnType() != Void.TYPE || !Benchmark.hasBenchmarkParam(m) || null != pattern && !(matcher = pattern.matcher(m.getName())).matches()) continue;
            list.add(m);
            maxName = m.getName().length() > maxName ? m.getName().length() : maxName;
        }
        for (final Method m : list) {
            InternalBenchmark ib = new InternalBenchmark(){
                Object o;
                {
                    this.o = c.newInstance();
                }

                @Override
                void runBenchmark(Benchmark b) {
                    try {
                        m.invoke(this.o, b);
                    }
                    catch (Throwable iae) {
                        throw new RuntimeException(iae);
                    }
                }
            };
            ib.name = m.getName();
            Benchmark b = new Benchmark();
            b.internal = ib;
            BenchmarkResult res = b.run();
            System.out.println(String.format("%" + maxName + "s\t%s", ib.name, res));
        }
    }

    public static void runBenchmark(Class c) throws InstantiationException, IllegalAccessException {
        Benchmark.runBenchmark(c, null);
    }

    public static void stringBuilder(Benchmark b) {
        for (int n = 0; n != b.N; ++n) {
            StringBuilder sum = new StringBuilder();
            for (int i = 1; i != 1000; ++i) {
                sum.append(i);
            }
            if (n != 0) continue;
            b.setBytes(sum.length());
        }
    }

    public static void string(Benchmark b) {
        for (int n = 0; n != b.N; ++n) {
            String sum = "";
            for (int i = 1; i != 1000; ++i) {
                sum = sum + i;
            }
            if (n != 0) continue;
            b.setBytes(sum.getBytes().length);
        }
    }

    static void usage() {
        System.err.println("usage: [jre] Benchmark <name of benchmark class> [optional regexp]");
        System.exit(1);
    }

    public static void main(String[] args) throws Throwable {
        String regexp = null;
        if (args.length != 1 && args.length != 2) {
            Benchmark.usage();
        }
        if (args.length == 2) {
            regexp = args[1];
        }
        Class<?> c = Class.forName(args[0]);
        Benchmark.runBenchmark(c, regexp);
    }

    public void startTimer() {
        this.start = System.nanoTime();
    }

    public void stopTimer() {
        if (this.start > 0L) {
            this.ns += System.nanoTime() - this.start;
        }
        this.start = 0L;
    }

    public void resetTimer() {
        this.start = 0L;
        this.ns = 0L;
    }

    public void setBytes(long n) {
        this.bytes = n;
    }

    long nsPerOp() {
        if (this.N <= 0) {
            return 0L;
        }
        return this.ns / (long)this.N;
    }

    void runN(int n) {
        this.N = n;
        this.resetTimer();
        this.startTimer();
        this.internal.runBenchmark(this);
        this.stopTimer();
    }

    public BenchmarkResult run() {
        int n = 1;
        this.runN(n);
        while ((double)this.ns < 1.0E9 && (double)n < 1.0E9) {
            long last = n;
            n = this.nsPerOp() == 0L ? 1000000000 : (int)(1.0E9 / (double)this.nsPerOp());
            n = (int)Benchmark.max(Benchmark.min(n + n / 2, 100L * last), last + 1L);
            n = Benchmark.roundUp(n);
            this.runN(n);
        }
        return new BenchmarkResult(this.N, this.ns, this.bytes);
    }

    public void stringBuffer(Benchmark b) {
        for (int n = 0; n != b.N; ++n) {
            StringBuffer sum = new StringBuffer();
            for (int i = 1; i != 1000; ++i) {
                sum.append(i);
            }
            if (n != 0) continue;
            b.setBytes(sum.length());
        }
    }
}

