/**
 * Copyright (c) 2013-2016 Jens Deters http://www.jensd.de
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package de.jensd.fx.glyphs.icons525;

import de.jensd.fx.glyphs.GlyphIcons;

/**
 *
 * Icon Enum based on 525Icons v2.0
 *
 * @author Jens Deters (mail@jensd.de)
 * @version 2.0
 */
public enum Icons525 implements GlyphIcons {

    _500PX('\ue648'),
    _5STAR_SHADOW('\ue6EC'),
    ACCESS('\ue600'),
    ACROBAT('\ue6FC'),
    ADDRESS_BOOK('\ue7F2'),
    ADDTHIS('\ue63E'),
    ADOBE_AIR('\ue635'),
    AFTER_EFFECTS('\ue687'),
    AIM('\ue640'),
    ALARM('\ue808'),
    AMAZON('\ue6FE'),
    ANDROID('\ue7D3'),
    ANGELLIST('\ue6CC'),
    ANGLE('\ue738'),
    ANGLE2('\ue739'),
    ANGLE_DOUBLE('\ue73A'),
    ANGULAR('\ue6CA'),
    APP_LAUNCHER('\ue6E4'),
    APP_STORE('\ue7D8'),
    APPLE('\ue7D6'),
    AQUARIUS('\ue6BB'),
    ARCHIVE('\ue66D'),
    ARCHIVE_BOX('\ue6F2'),
    ARIES('\ue6B1'),
    ARROW('\ue737'),
    ARROW_SIGN('\ue734'),
    ARROWS('\ue768'),
    ASTERISK('\ue6F0'),
    ASTERISK2('\ue6F6'),
    AT('\ue6EA'),
    ATTACHMENT('\ue707'),
    ATTRACTION('\ue76D'),
    AUDITION('\ue689'),
    BACKWARD_CIRCLE('\ue7B6'),
    BADGE('\ue6F5'),
    BARCODE('\ue722'),
    BASKET('\ue71A'),
    BASKET2('\ue71B'),
    BATTERY_0('\ue628'),
    BATTERY_1('\ue629'),
    BATTERY_2('\ue62A'),
    BATTERY_3('\ue62B'),
    BATTERY_CHARGING('\ue62C'),
    BEHANCE('\ue645'),
    BIN('\ue740'),
    BING('\ue699'),
    BIOHAZARD('\ue6C2'),
    BITNAMI('\ue7FA'),
    BLOGGER('\ue650'),
    BLUERAY('\ue6F3'),
    BLUETOOTH('\ue696'),
    BOOK('\ue685'),
    BOOKM_BLK('\ue72A'),
    BOOKS('\ue66E'),
    BOOTSTRAP('\ue7D9'),
    BRIDGE('\ue68A'),
    BUCKET('\ue746'),
    BULLET('\ue6ED'),
    BUS('\ue7EB'),
    BY('\ue748'),
    CAB('\ue7EA'),
    CALCULATOR('\ue697'),
    CALENDAR('\ue66B'),
    CALENDAR_OPEN('\ue66A'),
    CAMERA('\ue7BA'),
    CAMERA_RETRO('\ue7B9'),
    CANCEL('\ue798'),
    CANCEL_CIRCLE('\ue796'),
    CANCER('\ue6B4'),
    CAPRICORN('\ue6BA'),
    CARD_CLUB('\ue67B'),
    CARD_DIAMOND('\ue67D'),
    CARD_HEART('\ue67C'),
    CARD_SPADE('\ue67A'),
    CARET('\ue73B'),
    CC('\ue747'),
    CC_MASTERCARD('\ue70F'),
    CC_PAYPAL('\ue710'),
    CC_VISA('\ue70E'),
    CE_MARK('\ue684'),
    CELCIUS('\ue6BD'),
    CHAR('\ue6C1'),
    CHAT('\ue78A'),
    CHECKBOX_CHECKED('\ue779'),
    CHEVRON('\ue735'),
    CHEVRON_CIRCLE('\ue736'),
    CHROME('\ue7AA'),
    CIRCLE('\ue7DB'),
    CIRCLE_0('\ue65D'),
    CIRCLE_1('\ue65E'),
    CIRCLE_2('\ue65F'),
    CIRCLE_3('\ue660'),
    CIRCLE_4('\ue661'),
    CIRCLE_5('\ue662'),
    CIRCLE_6('\ue663'),
    CIRCLE_7('\ue664'),
    CIRCLE_8('\ue665'),
    CIRCLE_9('\ue666'),
    CIRCLE_ANGLE('\ue732'),
    CIRCLE_ARROW('\ue730'),
    CIRCLE_ARROW_O('\ue731'),
    CIRCLE_DOWNLOAD('\ue679'),
    CIRCLE_FACEBOOK('\ue780'),
    CIRCLE_GITHUB('\ue79B'),
    CIRCLE_GOOGLEPLUS('\ue782'),
    CIRCLE_INSTAGRAM('\ue783'),
    CIRCLE_LINKEDIN('\ue787'),
    CIRCLE_MAIL('\ue784'),
    CIRCLE_MINUS('\ue793'),
    CIRCLE_O('\ue7DD'),
    CIRCLE_O_NOTCH('\ue764'),
    CIRCLE_PINTEREST('\ue786'),
    CIRCLE_SHARE('\ue781'),
    CIRCLE_STUMBLEUPON('\ue785'),
    CIRCLE_THINLINE('\ue7DC'),
    CIRCLE_TWITTER('\ue788'),
    CIRCLE_UPLOAD('\ue678'),
    CIRCLE_YOUTUBE('\ue789'),
    CIRCLEADD('\ue792'),
    CIRCLEDELETE('\ue794'),
    CIRCLESELECT('\ue795'),
    CLOCK('\ue772'),
    CLOUDY('\ue6DB'),
    CODEPEN('\ue7A6'),
    CODERWALL('\ue6D2'),
    COFFEE('\ue6D6'),
    COGS('\ue770'),
    COLOR_CC('\ue634'),
    COMMENT('\ue78B'),
    COMMENT2('\ue7EF'),
    COMMENT_QUOTE('\ue78C'),
    COMPASS('\ue809'),
    CONNECTION_WIFI('\ue692'),
    CONSTRUCTION('\ue771'),
    CONTACTS('\ue7B0'),
    COPY('\ue709'),
    COPYRIGHT('\ue6B0'),
    CREATIVECLOUD('\ue6D8'),
    CREDITCARD('\ue70D'),
    CSS3('\ue75F'),
    CUT('\ue708'),
    CUTLERY('\ue7E7'),
    DATABASE('\ue675'),
    DECO_BULLET('\ue6EE'),
    DELICIOUS('\ue64B'),
    DESKTOP('\ue7E0'),
    DEVIANTART('\ue7C7'),
    DICE_FIVE('\ue77E'),
    DICE_FOUR('\ue77D'),
    DICE_ONE('\ue77A'),
    DICE_SIX('\ue77F'),
    DICE_THREE('\ue77C'),
    DICE_TWO('\ue77B'),
    DIGG('\ue651'),
    DIGG2('\ue7FF'),
    DISAPPOINTED_FACE('\ue6AB'),
    DISC('\ue7F5'),
    DOMAIN2('\ue73D'),
    DOWNLOAD('\ue683'),
    DREAMWEAVER('\ue68B'),
    DRIBBBLE('\ue638'),
    DROPBOX('\ue7C6'),
    DVD('\ue6F4'),
    EDIT('\ue745'),
    EJECT('\ue65B'),
    EJECT_CIRCLE('\ue7B8'),
    ELLIPSIS('\ue774'),
    EMAIL('\ue654'),
    ENVELOPE('\ue714'),
    ENVELOPE_O('\ue713'),
    ETSY('\ue62E'),
    EVERNOTE('\ue644'),
    EVERNOTE2('\ue7CC'),
    EXCEL('\ue60A'),
    EXCHANGE('\ue601'),
    EXCLAMATION_CIRCLE('\ue7DF'),
    EXPAND('\ue72E'),
    EYE('\ue691'),
    EYEDROPPER('\ue744'),
    FA_LOGO('\ue703'),
    FACEBOOK('\ue64C'),
    FACEBOOK2('\ue7A4'),
    FAHRENHEIT('\ue6BE'),
    FAST_FORWARD('\ue659'),
    FAVORITES('\ue729'),
    FEEDLY('\ue6C6'),
    FILE_AI('\ue619'),
    FILE_ASP('\ue622'),
    FILE_AVI('\ue612'),
    FILE_CSS('\ue61E'),
    FILE_DOCX('\ue60F'),
    FILE_EPS('\ue61A'),
    FILE_EXE('\ue61D'),
    FILE_GIF('\ue618'),
    FILE_HTML('\ue621'),
    FILE_JPG('\ue617'),
    FILE_JS('\ue61F'),
    FILE_MOV('\ue614'),
    FILE_MP3('\ue610'),
    FILE_MP4('\ue613'),
    FILE_OTF('\ue623'),
    FILE_PDF('\ue61B'),
    FILE_PHP('\ue620'),
    FILE_PNG('\ue615'),
    FILE_PSD('\ue616'),
    FILE_RAR('\ue625'),
    FILE_SQL('\ue61C'),
    FILE_SVG('\ue626'),
    FILE_TXT('\ue627'),
    FILE_WAV('\ue611'),
    FILE_ZIP('\ue624'),
    FILES('\ue6A4'),
    FILM('\ue76B'),
    FINDER('\ue7D7'),
    FIRE_EXTINGUISHER('\ue75A'),
    FIREFOX('\ue7AB'),
    FIREWORKS('\ue68C'),
    FLASHPLAYER('\ue636'),
    FLICKR('\ue63B'),
    FLICKR2('\ue7D1'),
    FLIPBOARD('\ue646'),
    FORWARD('\ue658'),
    FORWARD_CIRCLE('\ue7B7'),
    FOURSQUARE('\ue631'),
    FRAME('\ue7F0'),
    FULLSCR('\ue72C'),
    FULLSCR_ESC('\ue72D'),
    G_ANALYTICS('\ue630'),
    G_WALLET('\ue711'),
    GEMINI('\ue6B3'),
    GITHUB('\ue637'),
    GITLAB('\ue6A0'),
    GLIDE('\ue6A1'),
    GLOBE('\ue6E6'),
    GLOBE_2('\ue73C'),
    GO('\ue6E1'),
    GOOGLE('\ue79F'),
    GOOGLE_DRIVE('\ue7CA'),
    GOOGLE_PLAY('\ue6FD'),
    GOOGLE_WD('\ue69D'),
    GOOGLEPLUS('\ue63D'),
    GOOGLEPLUS2('\ue7A0'),
    GREEN_DOT('\ue7F9'),
    GROUP('\ue7B1'),
    HANGOUTS('\ue7CB'),
    HEADPHONES('\ue6D5'),
    HEART('\ue777'),
    HEART_O('\ue778'),
    HOME('\ue705'),
    HOME2('\ue706'),
    HOOTSUITE('\ue69E'),
    HTML5('\ue75E'),
    ICLOUD('\ue6CF'),
    ICOMOON('\ue749'),
    ICQ('\ue63A'),
    IE('\ue7AC'),
    ILLUSTRATOR('\ue688'),
    IMAGE('\ue7BD'),
    IMAGE_GALLERY('\ue7BB'),
    IMAGE_GALLERY2('\ue7BC'),
    IMAGE_PORTRAIT('\ue7BE'),
    IMPORT('\ue715'),
    INDESIGN('\ue68D'),
    INFINITY('\ue760'),
    INFO('\ue71F'),
    INFO_CIRCLE('\ue71D'),
    INFO_CIRCLE2('\ue71E'),
    INSTAGRAM('\ue64E'),
    INSTAGRAM2('\ue6D1'),
    INT_ALPINE('\ue74F'),
    INT_BED('\ue753'),
    INT_BUS('\ue754'),
    INT_ELEVATOR('\ue751'),
    INT_FIRSTAID('\ue759'),
    INT_FUEL('\ue758'),
    INT_GENTS('\ue75D'),
    INT_GUARD('\ue750'),
    INT_LADIES('\ue75C'),
    INT_LIGHTHOUSE('\ue75B'),
    INT_LITTER('\ue752'),
    INT_LOCKER('\ue74E'),
    INT_P('\ue757'),
    INT_PHONE('\ue756'),
    INT_PLANE('\ue755'),
    INT_SWIM('\ue74D'),
    INT_TRAIN('\ue74C'),
    INT_WATER('\ue74B'),
    INT_WHEELCHAIR('\ue74A'),
    INV_SMILE('\ue6AF'),
    ITUNES('\ue7C4'),
    JOOMLA('\ue79D'),
    JQUERY('\ue7A8'),
    JSDELIVR('\ue6C5'),
    JSFIDDLE('\ue79E'),
    KEY('\ue67E'),
    KEYBOARD('\ue669'),
    KEYBOARD2('\ue718'),
    KIK('\ue633'),
    LAPTOP('\ue7E1'),
    LASTFM('\ue6FB'),
    LAUGHING_SMILING_EYES('\ue6A7'),
    LAUNCHPAD('\ue76A'),
    LEO('\ue6B5'),
    LIBRA('\ue6B7'),
    LIBRARY('\ue701'),
    LIGHTNING('\ue6DD'),
    LIGHTROOM('\ue68E'),
    LINE('\ue6C9'),
    LINK('\ue674'),
    LINKEDIN('\ue647'),
    LINKEDIN2('\ue79A'),
    LINUX('\ue7D2'),
    LISTEN('\ue65C'),
    LOCK('\ue667'),
    LOCK2('\ue6C0'),
    LOCK_OPEN('\ue668'),
    LOGOUT('\ue80C'),
    LONDON_TUBE('\ue671'),
    MAIL_SEND('\ue6E0'),
    MAP('\ue80A'),
    MAP2('\ue80B'),
    MAP_MARKER('\ue672'),
    MARKETPLACE('\ue69A'),
    MAXCDN('\ue6CB'),
    MEDIUM('\ue7FC'),
    MEDKIT('\ue7F4'),
    MEETUP('\ue6A3'),
    MENU('\ue775'),
    MESSENGER('\ue7C1'),
    MIC('\ue6D4'),
    MICROSOFT('\ue60D'),
    MIXCLOUD('\ue7FE'),
    MODX('\ue800'),
    MOON('\ue6E7'),
    MOUSE('\ue6FA'),
    MOVIE_CLAPPER('\ue6E9'),
    MS_EDGE('\ue7A9'),
    MSN('\ue7C0'),
    MUSICALNOTE('\ue67F'),
    MYSPACE('\ue7CF'),
    NEWSPAPER('\ue698'),
    NOENTRY('\ue76C'),
    NOTEPAD('\ue7F1'),
    NOTIFICATIONS('\ue6E2'),
    OFFICE('\ue60B'),
    OFFICE365('\ue60C'),
    OK('\ue799'),
    ONEDRIVE('\ue6D7'),
    ONENOTE('\ue602'),
    OPERA('\ue7AD'),
    OUTLOOK('\ue603'),
    PAINTBRUSH('\ue741'),
    PALETTE('\ue6F9'),
    PARTLY_CLOUDY('\ue6DA'),
    PASTE('\ue70A'),
    PATH('\ue7FB'),
    PAUSE('\ue656'),
    PAUSE_CIRCLE('\ue7B4'),
    PEACE('\ue6A5'),
    PENCIL('\ue742'),
    PENCIL2('\ue743'),
    PERSEVERING_FACE('\ue6AD'),
    PHONE('\ue716'),
    PHOTOSHOP('\ue690'),
    PICASA('\ue641'),
    PIE('\ue6BF'),
    PINTEREST('\ue639'),
    PINTEREST2('\ue7A5'),
    PISCES('\ue6BC'),
    PLAY('\ue655'),
    PLAY_CIRCLE('\ue7B3'),
    PLAYSTATION('\ue69C'),
    PLUS('\ue807'),
    POCKET('\ue652'),
    POCKET2('\ue7CD'),
    POWERPOINT('\ue604'),
    PREMIERE('\ue68F'),
    PRINTER('\ue70C'),
    PRODUCTHUNT('\ue6C4'),
    PROJECT('\ue605'),
    PUBLISHER('\ue606'),
    QRCODE('\ue773'),
    QUESTION('\ue71C'),
    QUOTES1('\ue686'),
    QWANT('\ue802'),
    RADIO('\ue717'),
    RADIOACTIVE('\ue681'),
    RAINY('\ue6DC'),
    RECYCLE('\ue6CD'),
    RECYCLE_O('\ue761'),
    REDDIT('\ue7A1'),
    REFRESH('\ue765'),
    REGISTERED('\ue704'),
    REMOVE('\ue73F'),
    RESPONSIVE('\ue7E5'),
    RSS('\ue769'),
    SAFARI('\ue7AE'),
    SAGITTARIUS('\ue6B9'),
    SAVE('\ue70B'),
    SCIENCE('\ue700'),
    SCOOPIT('\ue63C'),
    SCORPIO('\ue6B8'),
    SCRIBD('\ue6FF'),
    SEARCH('\ue762'),
    SELECT('\ue6E3'),
    SELECT_CELLS('\ue670'),
    SELECT_CIRCLE('\ue797'),
    SHAPES('\ue6E5'),
    SHARE('\ue642'),
    SHARE2('\ue804'),
    SHARE_ALT('\ue803'),
    SHAREPOINT('\ue607'),
    SHARING('\ue73E'),
    SHOPPINGBAG('\ue719'),
    SHRINK('\ue72F'),
    SHUT_DOWN('\ue7F3'),
    SIGN_IN('\ue805'),
    SIGN_OUT('\ue806'),
    SIGNAL_0('\ue723'),
    SIGNAL_1('\ue724'),
    SIGNAL_2('\ue725'),
    SIGNAL_3('\ue726'),
    SIGNAL_4('\ue727'),
    SIGNAL_5('\ue728'),
    SITEMAP('\ue7F6'),
    SKYPE('\ue7C5'),
    SLACK('\ue6C3'),
    SMARTPHONE('\ue7E3'),
    SMILING_EYES('\ue6A6'),
    SMILING_HEART_EYES('\ue6A9'),
    SMIRKING_FACE('\ue6AA'),
    SNAPCHAT('\ue6CE'),
    SNOWFLAKE('\ue6DF'),
    SNOWY('\ue6DE'),
    SOUNDCLOUD('\ue7D0'),
    SPINNER('\ue763'),
    SPINNER2('\ue766'),
    SPINNER3('\ue767'),
    SPOTIFY('\ue7C9'),
    SQUARE('\ue7DA'),
    SQUARE_BULLET('\ue6EB'),
    SQUARE_BULLET2('\ue6EF'),
    SQUARE_CALC('\ue776'),
    SQUARE_DIVIDE('\ue790'),
    SQUARE_MINUS('\ue78E'),
    SQUARE_MULTI('\ue78F'),
    SQUARE_PHONE('\ue7BF'),
    SQUARE_PLUS('\ue78D'),
    SQUARE_SUM('\ue791'),
    STACKEXCHANGE('\ue69F'),
    STACKOVERFLOW('\ue62D'),
    STAR_E('\ue6F1'),
    STAR_SMALL('\ue6F7'),
    START_CHAT('\ue712'),
    STEP_FORWARD('\ue65A'),
    STOP('\ue657'),
    STOP_CIRCLE('\ue7B5'),
    STOP_SIGN('\ue6E8'),
    STOPWATCH('\ue677'),
    STREET_VIEW('\ue673'),
    STUMBLEUPON('\ue64A'),
    SUBWAY('\ue7ED'),
    SUITCASE('\ue702'),
    SUNNY('\ue6D9'),
    SURFACE('\ue7E4'),
    SURVEILLANCE_CAM('\ue6D3'),
    SWAY('\ue608'),
    TABLE('\ue66F'),
    TABLET('\ue7E2'),
    TARGET('\ue6F8'),
    TAURUS('\ue6B2'),
    TERMINAL('\ue72B'),
    THUMBS_UP('\ue676'),
    TOGGLE_OFF('\ue721'),
    TOGGLE_ON('\ue720'),
    TRAFFIC_CONE('\ue66C'),
    TRAIN('\ue7EC'),
    TRAM('\ue7EE'),
    TRIPADVISOR('\ue7C8'),
    TUMBLR('\ue643'),
    TVG('\ue7E9'),
    TWITTER('\ue64D'),
    TWITTER2('\ue7A2'),
    UNAMUSED_FACE('\ue6AC'),
    UNHAPPY_FACE('\ue6AE'),
    UNIVERSAL_ACCESS('\ue7E6'),
    UPLOAD('\ue682'),
    USB('\ue694'),
    USB_DRIVE('\ue695'),
    USER('\ue7AF'),
    USER_PLUS('\ue7B2'),
    VIBER('\ue7C3'),
    VIMEO('\ue64F'),
    VIMEO2('\ue7D4'),
    VINE('\ue6D0'),
    VIRGO('\ue6B6'),
    VISUAL_STUDIO('\ue60E'),
    VIVALDI('\ue801'),
    VKONTAKTE('\ue653'),
    VLC('\ue7A7'),
    WARNING_SIGN('\ue7DE'),
    WECHAT('\ue6C8'),
    WEEBLY('\ue6C7'),
    WEIBO('\ue7A3'),
    WHATSAPP('\ue7C2'),
    WIFI('\ue693'),
    WINDOWS8('\ue7D5'),
    WINE_BOTTLE('\ue7E8'),
    WINKING_FACE('\ue6A8'),
    WIX('\ue6A2'),
    WORD('\ue609'),
    WORDPRESS('\ue79C'),
    WP_ARROW('\ue733'),
    WP_COG('\ue76F'),
    WP_COG_O('\ue76E'),
    XBOX('\ue69B'),
    XING('\ue7FD'),
    YAHOO('\ue63F'),
    YELP('\ue632'),
    YIN_YANG('\ue680'),
    YOUTUBE('\ue649'),
    YOUTUBE2('\ue7CE'),
    ZOOM_IN('\ue7F7'),
    ZOOM_OUT('\ue7F8'),
    ZURB('\ue62F');

    private final char character;


private Icons525(char character) {
        this.character = character;
    }

    @Override
        public char getChar() {
        return character;
    }

    @Override
        public String unicodeToString() {
        return String.format("\\u%04x", (int) character);
    }

    @Override
        public String characterToString() {
        return Character.toString(character);
    }

    @Override
        public String getFontFamily() {
        return "\'525icons\'";
    }

}
