/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.util;

import de.haumacher.msgbuf.generator.util.FileGenerator;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class AbstractFileGenerator
implements FileGenerator {
    private static final String NL;
    private static final String INDENT = "\t";
    private Appendable _out;
    private int _indent = 0;

    @Override
    public void generate(Appendable out, int indent) {
        this._out = out;
        this._indent = indent;
        try {
            this.generate();
        }
        finally {
            this._out = null;
            this._indent = 0;
        }
    }

    protected void include(FileGenerator other) {
        try {
            other.generate(this._out, this._indent);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public int getIndent() {
        return this._indent;
    }

    protected abstract void generate();

    protected abstract void docComment(String var1);

    protected void line(String line) {
        this.lineStart(line);
        this.nl();
    }

    protected void line(String ... parts) {
        this.lineStart(this.joinNonEmptyWithSpace(parts));
        this.nl();
    }

    private String joinNonEmptyWithSpace(String ... parts) {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (String part : parts) {
            if (part == null || part.isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                buffer.append(" ");
            }
            buffer.append(part);
        }
        String line = buffer.toString();
        return line;
    }

    protected void lineStart(String line) {
        int closing = this.countClose(line);
        int delta = this.countDelta(line);
        this._indent += closing;
        for (int n = 0; n < this._indent; ++n) {
            this.internalAppend(INDENT);
        }
        this._indent += delta - closing;
        this.internalAppend(line);
    }

    protected void append(String part) {
        this.internalAppend(part);
        this._indent += this.countDelta(part);
    }

    private void internalAppend(String part) {
        try {
            this._out.append(part);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    private int countDelta(String line) {
        int result = 0;
        int cnt = line.length();
        block4: for (int n = 0; n < cnt; ++n) {
            switch (line.charAt(n)) {
                case '(': 
                case '[': 
                case '{': {
                    ++result;
                    continue block4;
                }
                case ')': 
                case ']': 
                case '}': {
                    --result;
                }
            }
        }
        return result;
    }

    private int countClose(String line) {
        int result = 0;
        int cnt = line.length();
        block4: for (int n = 0; n < cnt; ++n) {
            switch (line.charAt(n)) {
                case ')': 
                case ']': 
                case '}': {
                    --result;
                    continue block4;
                }
                case '(': 
                case '[': 
                case '{': {
                    return result;
                }
            }
        }
        return result;
    }

    protected void nl() {
        this.internalAppend(NL);
    }

    static {
        StringWriter out = new StringWriter();
        try (PrintWriter p = new PrintWriter(out);){
            p.println();
        }
        NL = out.toString();
    }
}

