/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.ast;

import de.haumacher.msgbuf.generator.ast.Option;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonUtil;
import de.haumacher.msgbuf.json.JsonWriter;
import de.haumacher.msgbuf.observer.Observable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class StringOption
extends Option {
    public static final String STRING_OPTION__TYPE = "StringOption";
    public static final String VALUE = "value";
    private String _value = "";
    private static List<String> PROPERTIES = Collections.unmodifiableList(Arrays.asList("value"));

    public static StringOption create() {
        return new StringOption();
    }

    protected StringOption() {
    }

    @Override
    public Option.TypeKind kind() {
        return Option.TypeKind.STRING_OPTION;
    }

    public final String getValue() {
        return this._value;
    }

    public StringOption setValue(String value) {
        this.internalSetValue(value);
        return this;
    }

    protected final void internalSetValue(String value) {
        this._listener.beforeSet((Observable)this, VALUE, (Object)value);
        this._value = value;
    }

    public String jsonType() {
        return STRING_OPTION__TYPE;
    }

    public List<String> properties() {
        return PROPERTIES;
    }

    public Object get(String field) {
        switch (field) {
            case "value": {
                return this.getValue();
            }
        }
        return super.get(field);
    }

    public void set(String field, Object value) {
        switch (field) {
            case "value": {
                this.internalSetValue((String)value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    public static StringOption readStringOption(JsonReader in) throws IOException {
        StringOption result = new StringOption();
        result.readContent(in);
        return result;
    }

    protected void writeFields(JsonWriter out) throws IOException {
        super.writeFields(out);
        out.name(VALUE);
        out.value(this.getValue());
    }

    protected void readField(JsonReader in, String field) throws IOException {
        switch (field) {
            case "value": {
                this.setValue(JsonUtil.nextStringOptional((JsonReader)in));
                break;
            }
            default: {
                super.readField(in, field);
            }
        }
    }

    @Override
    public <R, A> R visit(Option.Visitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }
}

