/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator;

import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.ast.Option;
import de.haumacher.msgbuf.generator.util.FileGenerator;
import java.util.List;
import java.util.Map;

public interface GeneratorPlugin {
    default public void init(Map<String, Option> options) {
    }

    default public void addInterfaces(Map<String, Option> options, MessageDef def, List<String> generalizations) {
    }

    default public FileGenerator messageInterfaceContents(Map<String, Option> options, MessageDef def) {
        return (out, indent) -> {};
    }

    default public FileGenerator messageImplContents(Map<String, Option> options, MessageDef def) {
        return (out, indent) -> {};
    }

    public static GeneratorPlugin none() {
        return new GeneratorPlugin(){

            @Override
            public GeneratorPlugin andThen(GeneratorPlugin next) {
                return next;
            }
        };
    }

    default public GeneratorPlugin andThen(final GeneratorPlugin next) {
        final GeneratorPlugin self = this;
        return new GeneratorPlugin(){

            @Override
            public void init(Map<String, Option> options) {
                self.init(options);
                next.init(options);
            }

            @Override
            public void addInterfaces(Map<String, Option> options, MessageDef def, List<String> generalizations) {
                self.addInterfaces(options, def, generalizations);
                next.addInterfaces(options, def, generalizations);
            }

            @Override
            public FileGenerator messageImplContents(Map<String, Option> options, MessageDef def) {
                return (out, indent) -> {
                    self.messageImplContents(options, def).generate(out, indent);
                    next.messageImplContents(options, def).generate(out, indent);
                };
            }

            @Override
            public FileGenerator messageInterfaceContents(Map<String, Option> options, MessageDef def) {
                return (out, indent) -> {
                    self.messageInterfaceContents(options, def).generate(out, indent);
                    next.messageInterfaceContents(options, def).generate(out, indent);
                };
            }
        };
    }
}

