/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.data;

import de.haumacher.msgbuf.data.DataObject;
import de.haumacher.msgbuf.io.StringW;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonWriter;
import java.io.IOException;

public abstract class AbstractDataObject
implements DataObject {
    @Override
    public Object get(String field) {
        return null;
    }

    @Override
    public void set(String field, Object value) {
    }

    public final void writeContent(JsonWriter out) throws IOException {
        out.beginObject();
        this.writeFields(out);
        out.endObject();
    }

    protected void writeFields(JsonWriter out) throws IOException {
    }

    protected final void readFields(JsonReader in) throws IOException {
        while (in.hasNext()) {
            String field = in.nextName();
            this.readField(in, field);
        }
    }

    protected void readField(JsonReader in, String field) throws IOException {
        in.skipValue();
    }

    public String toString() {
        return this.toJson();
    }

    private String toJson() {
        StringW out = new StringW();
        try {
            this.writeTo(new JsonWriter(out));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return out.toString();
    }
}

