/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.coder;

import de.haumacher.msgbuf.io.Reader;
import java.io.EOFException;
import java.io.IOException;

public class Coder {
    private static final char[] BASE_64_URL = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
    private static final int[] DIGIT = new int[256];
    private static final int MASK_4 = 15;
    private static final int MASK_5 = 31;
    private static final int BIT_1 = 1;
    private static final int BIT_5 = 16;
    private static final int BIT_6 = 32;

    public static void appendInt(Appendable out, int num) throws IOException {
        boolean negative;
        boolean bl = negative = num < 0;
        if (negative) {
            num = -num;
        }
        int digit = num & 0xF;
        num >>>= 4;
        if (negative) {
            digit |= 0x10;
        }
        if (num == 0) {
            out.append(BASE_64_URL[digit | 0x20]);
            return;
        }
        out.append(BASE_64_URL[digit]);
        Coder.appendUInt(out, num);
    }

    public static void appendUInt(Appendable out, int num) throws IOException {
        while (true) {
            int digit = num & 0x1F;
            if ((num >>>= 5) == 0) {
                out.append(BASE_64_URL[digit | 0x20]);
                return;
            }
            out.append(BASE_64_URL[digit]);
        }
    }

    public static int readInt(Reader in) throws IOException {
        int digit = DIGIT[in.read()];
        boolean negative = (digit & 0x10) != 0;
        int result = digit & 0xF;
        if ((digit & 0x20) == 0) {
            result = Coder.readIntBits(in, 4, result);
        }
        return negative ? -result : result;
    }

    public static int readUInt(Reader in) throws IOException {
        return Coder.readIntBits(in, 0, 0);
    }

    private static int readIntBits(Reader in, int offset, int result) throws IOException {
        while (true) {
            int digit = DIGIT[in.read()];
            result |= (digit & 0x1F) << offset;
            if ((digit & 0x20) != 0) break;
            offset += 5;
        }
        return result;
    }

    public static void appendLong(Appendable out, long num) throws IOException {
        boolean negative;
        boolean bl = negative = num < 0L;
        if (negative) {
            num = -num;
        }
        int digit = (int)(num & 0xFL);
        num >>>= 4;
        if (negative) {
            digit |= 0x10;
        }
        if (num == 0L) {
            out.append(BASE_64_URL[digit | 0x20]);
            return;
        }
        out.append(BASE_64_URL[digit]);
        while (true) {
            digit = (int)(num & 0x1FL);
            if ((num >>>= 5) == 0L) {
                out.append(BASE_64_URL[digit | 0x20]);
                return;
            }
            out.append(BASE_64_URL[digit]);
        }
    }

    public static long readLong(Reader in) throws IOException {
        long digit = DIGIT[in.read()];
        boolean negative = (digit & 0x10L) != 0L;
        long result = digit & 0xFL;
        if ((digit & 0x20L) == 0L) {
            int offset = 4;
            while (true) {
                digit = DIGIT[in.read()];
                result |= (digit & 0x1FL) << offset;
                if ((digit & 0x20L) != 0L) break;
                offset += 5;
            }
        }
        return negative ? -result : result;
    }

    public static void appendString(Appendable out, String s) throws IOException {
        Coder.appendUInt(out, s.length());
        out.append(s);
    }

    public static String readString(Reader in) throws IOException {
        int length = Coder.readUInt(in);
        return Coder.readString(in, length);
    }

    private static String readString(Reader in, int length) throws IOException {
        int direct;
        char[] buffer = new char[length];
        for (int pos = 0; pos < length; pos += direct) {
            direct = in.read(buffer, pos, length - pos);
            if (direct >= 0) continue;
            throw new EOFException("Missing input");
        }
        return new String(buffer);
    }

    public static void appendFloat(Appendable out, float num) throws IOException {
        Coder.appendString(out, Float.toString(num));
    }

    public static float readFloat(Reader in) throws IOException {
        return Float.parseFloat(Coder.readString(in));
    }

    public static void appendDouble(Appendable out, double num) throws IOException {
        Coder.appendString(out, Double.toString(num));
    }

    public static double readDouble(Reader in) throws IOException {
        return Double.parseDouble(Coder.readString(in));
    }

    static {
        int cnt = BASE_64_URL.length;
        for (int n = 0; n < cnt; ++n) {
            Coder.DIGIT[Coder.BASE_64_URL[n]] = n;
        }
    }
}

