/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.ContainerConfig;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.util.TigerSerializationUtil;
import de.gematik.test.tiger.testenvmgr.servers.AbstractExternalTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.AbstractTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.DockerComposeServer;
import de.gematik.test.tiger.testenvmgr.servers.DockerServer;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.awaitility.Awaitility;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.DockerComposeContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.startupcheck.OneShotStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class DockerMgr {
    private static final Logger log = LoggerFactory.getLogger(DockerMgr.class);
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT = "-----END CERTIFICATE-----";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int MOD_ALL_EXEC = 511;
    private static final String CLASSPATH = "classpath:";
    private static final String DOCKER_COMPOSE_PROP_EXPOSE = "expose";
    public static final String TARGET_FOLDER = "target";
    public static final String TIGER_TESTENV_MGR_FOLDER = "tiger-testenv-mgr";
    private final Map<String, GenericContainer<?>> dockerContainers = new HashMap();
    private final Map<String, DockerComposeContainer<?>> composeContainers = new HashMap();
    private static final String ECHO_CERT_CMD = "echo \"%s\" >> /etc/ssl/certs/ca-certificates.crt\n";

    public void startContainer(DockerServer server) {
        String imageName = this.buildImageName(server);
        DockerImageName testContainersImageName = DockerImageName.parse((String)imageName);
        this.pullImage(imageName);
        GenericContainer container = new GenericContainer(testContainersImageName);
        try {
            InspectImageResponse iiResponse = container.getDockerClient().inspectImageCmd(imageName).exec();
            ContainerConfig containerConfig = iiResponse.getConfig();
            if (containerConfig == null) {
                throw new TigerTestEnvException("Docker image '" + imageName + "' has no configuration info!");
            }
            if (server.getDockerOptions().isProxied()) {
                File tmpScriptFolder;
                String[] startCmd = containerConfig.getCmd();
                String[] entryPointCmd = containerConfig.getEntrypoint();
                if (StringUtils.isNotEmpty((CharSequence)server.getDockerOptions().getEntryPoint())) {
                    entryPointCmd = new String[]{server.getDockerOptions().getEntryPoint()};
                }
                if (entryPointCmd != null && entryPointCmd[0].equals("/bin/sh") && entryPointCmd[1].equals("-c")) {
                    entryPointCmd = new String[]{"su", containerConfig.getUser(), "-c", "'" + entryPointCmd[2] + "'"};
                }
                if (!(tmpScriptFolder = Path.of(TARGET_FOLDER, TIGER_TESTENV_MGR_FOLDER).toFile()).exists() && !tmpScriptFolder.mkdirs()) {
                    throw new TigerTestEnvException("Unable to create temp folder for modified startup script for server " + server.getServerId());
                }
                String scriptName = this.createContainerStartupScript((AbstractTigerServer)server, iiResponse, startCmd, entryPointCmd);
                String containerScriptPath = containerConfig.getWorkingDir() + "/" + scriptName;
                container.withExtraHost("host.docker.internal", "host-gateway");
                container.withCopyFileToContainer(MountableFile.forHostPath((Path)Path.of(tmpScriptFolder.getAbsolutePath(), scriptName), (Integer)511), containerScriptPath);
                container.withCreateContainerCmdModifier(cmd -> cmd.withUser("root").withEntrypoint(new String[]{containerScriptPath}));
            }
            container.setLogConsumers(List.of(new Slf4jLogConsumer(log)));
            log.info("Passing in environment for {}...", (Object)server.getServerId());
            this.addEnvVarsToContainer(container, server.getEnvironmentProperties());
            if (containerConfig.getExposedPorts() != null) {
                List ports = Arrays.stream(containerConfig.getExposedPorts()).map(ExposedPort::getPort).collect(Collectors.toList());
                log.info("Exposing ports for {}: {}", (Object)server.getServerId(), ports);
                container.setExposedPorts(ports);
            }
            if (server.getDockerOptions().isOneShot()) {
                container.withStartupCheckStrategy((StartupCheckStrategy)new OneShotStartupCheckStrategy());
            }
            container.start();
            DockerMgr.retrieveExposedPortsAndStoreInServerConfiguration(server, container);
            this.waitForHealthyStartup(server, container);
            container.getDockerClient().renameContainerCmd(container.getContainerId()).withName("tiger." + server.getServerId()).exec();
            this.dockerContainers.put(server.getServerId(), container);
        }
        catch (DockerException de) {
            throw new TigerTestEnvException("Failed to start container for server " + server.getServerId(), (Throwable)de);
        }
    }

    private static void retrieveExposedPortsAndStoreInServerConfiguration(DockerServer server, GenericContainer<?> container) {
        try {
            HashMap ports = new HashMap();
            container.getContainerInfo().getNetworkSettings().getPorts().getBindings().entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> ports.put(((ExposedPort)entry.getKey()).getPort(), Integer.valueOf(((Ports.Binding[])entry.getValue())[0].getHostPortSpec())));
            server.getDockerOptions().setPorts(ports);
        }
        catch (RuntimeException rte) {
            log.warn("Unable to retrieve port bindings! No startup healthcheck can be performed!", (Throwable)rte);
        }
    }

    private String buildImageName(DockerServer server) {
        Object result = server.getDockerSource();
        if (server.getTigerTestEnvMgr() != null) {
            result = server.getTigerTestEnvMgr().replaceSysPropsInString(server.getDockerSource());
        }
        if (server.getConfiguration().getVersion() != null) {
            result = (String)result + ":" + server.getConfiguration().getVersion();
        }
        return result;
    }

    public void startComposition(DockerComposeServer server) {
        ArrayList<String> composeFileContents = new ArrayList<String>();
        File[] composeFiles = this.collectAndProcessComposeYamlFiles(server.getServerId(), server.getSource(), composeFileContents);
        String identity = "tiger_" + Base58.randomString((int)6).toLowerCase();
        DockerComposeContainer composition = new DockerComposeContainer(identity, composeFiles);
        composeFileContents.stream().filter(content -> !content.isEmpty()).map(content -> TigerSerializationUtil.yamlToJsonObject((String)content).getJSONObject("services")).map(JSONObject::toMap).flatMap(services -> services.entrySet().stream()).forEach(serviceEntry -> {
            Map map = (Map)serviceEntry.getValue();
            if (map.containsKey(DOCKER_COMPOSE_PROP_EXPOSE)) {
                ((List)map.get(DOCKER_COMPOSE_PROP_EXPOSE)).forEach(port -> {
                    log.info("Exposing service {} with port {}", serviceEntry.getKey(), port);
                    composition.withExposedService((String)serviceEntry.getKey(), port.intValue());
                });
            } else if (map.containsKey("ports")) {
                ((List)map.get("ports")).forEach(portString -> {
                    if (!portString.contains(":")) {
                        log.warn("Docker compose with ephemeral host ports not supported as of now, please specify manual host port for '{}'", portString);
                    } else {
                        int port = Integer.parseInt(portString.split(":")[0]);
                        log.info("Exposing service {} with port {}", serviceEntry.getKey(), (Object)port);
                        composition.withExposedService((String)serviceEntry.getKey(), port);
                    }
                });
            }
            composition.withLogConsumer((String)serviceEntry.getKey(), (Consumer)new Slf4jLogConsumer(log));
        });
        composition.withLocalCompose(true).withOptions(new String[]{"--compatibility"}).start();
        composeFileContents.stream().filter(content -> !content.isEmpty()).map(content -> TigerSerializationUtil.yamlToJsonObject((String)content).getJSONObject("services")).map(JSONObject::toMap).flatMap(services -> services.entrySet().stream()).forEach(serviceEntry -> {
            Map map = (Map)serviceEntry.getValue();
            if (map.containsKey(DOCKER_COMPOSE_PROP_EXPOSE)) {
                ((List)map.get(DOCKER_COMPOSE_PROP_EXPOSE)).forEach(port -> {
                    log.info("Service {} with port {} exposed via {}", new Object[]{serviceEntry.getKey(), port, composition.getServicePort((String)serviceEntry.getKey(), port)});
                    ListContainersCmd cmd = DockerClientFactory.instance().client().listContainersCmd();
                    log.debug("Inspecting docker container: {}", (Object)((List)cmd.exec()).toString());
                });
            }
            composition.withLogConsumer((String)serviceEntry.getKey(), (Consumer)new Slf4jLogConsumer(log));
        });
        this.composeContainers.put(server.getServerId(), composition);
    }

    private File[] collectAndProcessComposeYamlFiles(String serverId, List<String> composeFilePaths, List<String> composeFileContents) {
        File folder = Paths.get(TARGET_FOLDER, TIGER_TESTENV_MGR_FOLDER, serverId).toFile();
        return (File[])composeFilePaths.stream().map(filePath -> {
            String content = this.readAndProcessComposeFile((String)filePath, composeFileContents);
            return this.saveComposeContentToTempFile(folder, (String)filePath, content);
        }).toArray(File[]::new);
    }

    private String readAndProcessComposeFile(String filePath, List<String> composeFileContents) {
        try {
            String content = filePath.startsWith(CLASSPATH) ? this.readContentFromClassPath(filePath.substring(CLASSPATH.length())) : FileUtils.readFileToString((File)new File(filePath), (Charset)StandardCharsets.UTF_8);
            content = TigerGlobalConfiguration.resolvePlaceholders((String)content);
            composeFileContents.add(content);
            return content;
        }
        catch (IOException e) {
            throw new TigerTestEnvException("Unable to process compose file " + filePath, (Throwable)e);
        }
    }

    private String readContentFromClassPath(String filePath) {
        String content;
        try (InputStream inputStream = this.getClass().getResourceAsStream(filePath);){
            if (inputStream == null) {
                throw new TigerTestEnvException("Missing docker compose file in classpath " + filePath);
            }
            content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException exception) {
            throw new TigerTestEnvException("Unable to read docker compose file from classpath (" + filePath + ")", (Throwable)exception);
        }
        return content;
    }

    private File saveComposeContentToTempFile(File folder, String filePath, String content) {
        try {
            if (filePath.startsWith(CLASSPATH)) {
                filePath = filePath.substring(CLASSPATH.length());
            }
            String filename = new File(filePath).getName() + "." + UUID.randomUUID() + ".yml";
            File tmpFile = Paths.get(folder.getAbsolutePath(), filename).toFile();
            if (!tmpFile.getParentFile().exists() && !tmpFile.getParentFile().mkdirs()) {
                throw new TigerTestEnvException("Unable to create temp folder " + tmpFile.getParentFile().getAbsolutePath());
            }
            FileUtils.writeStringToFile((File)tmpFile, (String)content, (Charset)StandardCharsets.UTF_8);
            return tmpFile;
        }
        catch (IOException e) {
            throw new TigerTestEnvException("Unable to process compose file " + filePath, (Throwable)e);
        }
    }

    private void addEnvVarsToContainer(GenericContainer<?> container, List<String> envVars) {
        envVars.stream().filter(i -> i.contains("=")).map(i -> i.split("=", 2)).forEach(envvar -> {
            log.info("  * {}={}", (Object)envvar[0], (Object)envvar[1]);
            container.addEnv(TigerGlobalConfiguration.resolvePlaceholders((String)envvar[0]), TigerGlobalConfiguration.resolvePlaceholders((String)envvar[1]));
        });
    }

    public void pullImage(String imageName) {
        log.info("Pulling docker image {}...", (Object)imageName);
        final AtomicBoolean pullComplete = new AtomicBoolean();
        pullComplete.set(false);
        final AtomicReference cbException = new AtomicReference();
        final AtomicReference<LocalDateTime> timeOfLastInfoLogMessage = new AtomicReference<LocalDateTime>(LocalDateTime.now());
        DockerClientFactory.instance().client().pullImageCmd(imageName).exec((ResultCallback)new ResultCallback.Adapter<PullResponseItem>(){

            public void onNext(PullResponseItem item) {
                if (log.isDebugEnabled()) {
                    log.debug("{} {}", (Object)item.getStatus(), (Object)Optional.ofNullable(item.getProgressDetail()).map(ResponseItem.ProgressDetail::getCurrent).map(Object::toString).orElse(""));
                } else {
                    LocalDateTime now = LocalDateTime.now();
                    if (((LocalDateTime)timeOfLastInfoLogMessage.get()).plusSeconds(2L).isBefore(now)) {
                        timeOfLastInfoLogMessage.set(now);
                        log.info("{} {}", (Object)item.getStatus(), (Object)Optional.ofNullable(item.getProgressDetail()).map(ResponseItem.ProgressDetail::getCurrent).map(Object::toString).orElse(""));
                    }
                }
            }

            public void onError(Throwable throwable) {
                cbException.set(throwable);
            }

            public void onComplete() {
                pullComplete.set(true);
            }
        });
        Awaitility.await().pollInterval(Duration.ofMillis(1000L)).atMost(5L, TimeUnit.MINUTES).until(() -> {
            if (cbException.get() != null) {
                throw new TigerTestEnvException("Unable to pull image " + imageName + "!", (Throwable)cbException.get());
            }
            return pullComplete.get();
        });
        log.info("Docker image {} is available locally!", (Object)imageName);
    }

    private String createContainerStartupScript(AbstractTigerServer server, InspectImageResponse iiResponse, String[] startCmd, String[] entryPointCmd) {
        ContainerConfig containerConfig = iiResponse.getConfig();
        if (containerConfig == null) {
            throw new TigerTestEnvException("Docker image of server '" + server.getServerId() + "' has no configuration info!");
        }
        startCmd = startCmd == null ? new String[]{} : startCmd;
        entryPointCmd = entryPointCmd == null ? new String[]{} : entryPointCmd;
        try {
            File tmpScriptFolder = Path.of(TARGET_FOLDER, TIGER_TESTENV_MGR_FOLDER).toFile();
            if (!tmpScriptFolder.exists() && !tmpScriptFolder.mkdirs()) {
                throw new TigerTestEnvException("Unable to create script folder " + tmpScriptFolder.getAbsolutePath());
            }
            String scriptName = "__tigerStart_" + server.getServerId() + ".sh";
            Object content = "#!/bin/sh -x\nenv\n";
            if (server.getTigerTestEnvMgr().getLocalTigerProxyOptional().isPresent()) {
                content = this.addCertitifcatesToOsTruststoreOfDockerContainer(server, (String)content);
            }
            content = (String)content + this.getContainerWorkingDirectory(containerConfig) + String.join((CharSequence)" ", entryPointCmd).replace("\t", " ") + " " + String.join((CharSequence)" ", startCmd).replace("\t", " ") + "\n";
            FileUtils.writeStringToFile((File)Path.of(tmpScriptFolder.getAbsolutePath(), scriptName).toFile(), (String)content, (Charset)StandardCharsets.UTF_8);
            return scriptName;
        }
        catch (IOException ioe) {
            throw new TigerTestEnvException("Failed to configure start script on container for server " + server.getServerId(), (Throwable)ioe);
        }
    }

    @NotNull
    private String addCertitifcatesToOsTruststoreOfDockerContainer(AbstractTigerServer server, String content) throws IOException {
        String proxycert = DockerMgr.getTigerProxyRootCaCertificate(server);
        String lecert = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/letsencrypt.crt")), (Charset)StandardCharsets.UTF_8);
        String risecert = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/idp-rise-tu.crt")), (Charset)StandardCharsets.UTF_8);
        content = (String)content + String.format("echo \"%s\" >> /etc/ssl/certs/ca-certificates.crt\necho \"%s\" >> /etc/ssl/certs/ca-certificates.crt\necho \"%s\" >> /etc/ssl/certs/ca-certificates.crt\n", proxycert, lecert, risecert);
        return content;
    }

    private static String getTigerProxyRootCaCertificate(AbstractTigerServer server) {
        try {
            Certificate certificate = server.getTigerTestEnvMgr().getLocalTigerProxyOrFail().buildTruststore().getCertificate("caCert");
            Base64.Encoder encoder = Base64.getMimeEncoder(64, "\r\n".getBytes());
            byte[] rawCrtText = certificate.getEncoded();
            String encodedCertText = new String(encoder.encode(rawCrtText));
            return BEGIN_CERT + LINE_SEPARATOR + encodedCertText + LINE_SEPARATOR + END_CERT;
        }
        catch (GeneralSecurityException e) {
            throw new TigerEnvironmentStartupException("Error while retrieving TigerProxy RootCa", (Exception)e);
        }
    }

    private String getContainerWorkingDirectory(ContainerConfig containerConfig) {
        String workingDir = containerConfig.getWorkingDir();
        if (StringUtils.isBlank((CharSequence)workingDir)) {
            return "";
        }
        return "cd " + workingDir + "\n";
    }

    private void waitForHealthyStartup(AbstractExternalTigerServer server, GenericContainer<?> container) {
        long startms = System.currentTimeMillis();
        long endhalfms = server.getStartupTimeoutSec().map(millis -> (long)millis.intValue() * 500L).orElse(5000L);
        try {
            while (!container.isHealthy()) {
                Thread.sleep(500L);
                if (startms + endhalfms * 2L >= System.currentTimeMillis()) continue;
                throw new TigerTestEnvException("Startup of server %s timed out after %d seconds!", new Object[]{server.getServerId(), (System.currentTimeMillis() - startms) / 1000L});
            }
            log.info("HealthCheck OK ({}) for {}", (Object)(container.isHealthy() ? 1 : 0), (Object)server.getServerId());
        }
        catch (InterruptedException ie) {
            log.warn("Interruption signaled while waiting for server " + server.getServerId() + " to start up", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (TigerTestEnvException ttee) {
            throw ttee;
        }
        catch (RuntimeException rte) {
            if (server.getConfiguration().getDockerOptions() == null || server.getConfiguration().getDockerOptions().getPorts() == null || server.getConfiguration().getDockerOptions().getPorts().isEmpty()) {
                log.warn("No healthcheck and no port bindings configured in docker image - waiting {}s", (Object)(endhalfms / 500L));
                try {
                    Thread.sleep(endhalfms * 2L);
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted while waiting for startup of server " + server.getServerId(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                log.warn("Status UNCLEAR for {} as no healthcheck / port bindings were configured in the docker image, we assume it works and continue setup!", (Object)server.getServerId());
            }
            String dockerHost = TigerGlobalConfiguration.readString((String)"tiger.docker.host", (String)"localhost");
            server.getConfiguration().setHealthcheckUrl("http://" + dockerHost + ":" + server.getConfiguration().getDockerOptions().getPorts().values().iterator().next());
            server.waitForServerUp();
        }
    }

    public void stopContainer(AbstractTigerServer server) {
        GenericContainer<?> container = this.dockerContainers.get(server.getServerId());
        if (container != null && container.getDockerClient() != null) {
            try {
                container.stop();
            }
            catch (RuntimeException rtex) {
                if (log.isDebugEnabled()) {
                    log.warn("Failed to stop container, relying on test container's implicit stop...", (Throwable)rtex);
                }
                log.warn("Failed to stop container, relying on test container's implicit stop...");
            }
            this.dockerContainers.remove(server.getServerId());
        }
    }

    public void stopComposeContainer(AbstractTigerServer server) {
        DockerComposeContainer<?> container = this.composeContainers.get(server.getServerId());
        if (container != null) {
            try {
                container.stop();
            }
            catch (RuntimeException rtex) {
                if (log.isDebugEnabled()) {
                    log.warn("Failed to stop compose container, relying on test container's implicit stop...", (Throwable)rtex);
                }
                log.warn("Failed to stop compose container, relying on test container's implicit stop...");
            }
            this.composeContainers.remove(server.getServerId());
        }
    }

    public void pauseContainer(DockerServer srv) {
        GenericContainer<?> container = this.dockerContainers.get(srv.getServerId());
        container.getDockerClient().pauseContainerCmd(container.getContainerId()).exec();
    }

    public void unpauseContainer(DockerServer srv) {
        GenericContainer<?> container = this.dockerContainers.get(srv.getServerId());
        container.getDockerClient().unpauseContainerCmd(container.getContainerId()).exec();
    }

    public Map<String, GenericContainer<?>> getDockerContainers() {
        return this.dockerContainers;
    }

    public Map<String, DockerComposeContainer<?>> getComposeContainers() {
        return this.composeContainers;
    }
}

