/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.data.config.CfgDockerOptions;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.servers.AbstractTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.DockerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerType;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@TigerServerType(value="compose")
public class DockerComposeServer
extends AbstractTigerServer {
    public DockerComposeServer(TigerTestEnvMgr tigerTestEnvMgr, String serverId, CfgServer configuration) {
        super("", serverId, tigerTestEnvMgr, configuration);
        if (!StringUtils.isBlank((CharSequence)configuration.getHostname())) {
            throw new TigerConfigurationException("Hostname property is not supported for docker compose nodes!");
        }
    }

    public void assertThatConfigurationIsCorrect() {
        super.assertThatConfigurationIsCorrect();
        this.assertCfgPropertySet(this.getConfiguration(), new String[]{"source"});
    }

    public void performStartup() {
        this.statusMessage("Starting docker compose for " + this.getServerId() + " from " + this.getDockerSource());
        DockerServer.dockerManager.startComposition(this);
        this.statusMessage("Docker compose " + this.getServerId() + " started");
    }

    public String getDockerSource() {
        return (String)this.getConfiguration().getSource().get(0);
    }

    public CfgDockerOptions getDockerOptions() {
        return this.getConfiguration().getDockerOptions();
    }

    public List<String> getSource() {
        if (this.getConfiguration().getSource() == null) {
            return List.of();
        }
        return Collections.unmodifiableList(this.getConfiguration().getSource());
    }

    public void shutdown() {
        this.log.info("Stopping docker compose {}...", (Object)this.getServerId());
        DockerServer.dockerManager.stopComposeContainer(this);
        this.removeAllRoutes();
        this.setStatus(TigerServerStatus.STOPPED, "Docker compose " + this.getServerId() + " stopped");
    }

    public static DockerComposeServerBuilder builder() {
        return new DockerComposeServerBuilder();
    }

    public static class DockerComposeServerBuilder {
        private TigerTestEnvMgr tigerTestEnvMgr;
        private String serverId;
        private CfgServer configuration;

        DockerComposeServerBuilder() {
        }

        public DockerComposeServerBuilder tigerTestEnvMgr(TigerTestEnvMgr tigerTestEnvMgr) {
            this.tigerTestEnvMgr = tigerTestEnvMgr;
            return this;
        }

        public DockerComposeServerBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public DockerComposeServerBuilder configuration(CfgServer configuration) {
            this.configuration = configuration;
            return this;
        }

        public DockerComposeServer build() {
            return new DockerComposeServer(this.tigerTestEnvMgr, this.serverId, this.configuration);
        }

        public String toString() {
            return "DockerComposeServer.DockerComposeServerBuilder(tigerTestEnvMgr=" + this.tigerTestEnvMgr + ", serverId=" + this.serverId + ", configuration=" + this.configuration + ")";
        }
    }
}

