/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.common.data.config.CfgHelmChartOptions;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.servers.AbstractExternalTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.AbstractTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.KubeUtils;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerType;
import de.gematik.test.tiger.testenvmgr.servers.log.TigerStreamLogFeeder;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.event.Level;

@TigerServerType(value="helmChart")
public class HelmChartServer
extends AbstractExternalTigerServer {
    public static final String FAILED_START_MESSAGE = "Failed to start helm chart for server";
    public static final String SOURCE_MESSAGE = "Server {} must have property source set and contain exactly one entry!";
    public static final String PORT_NAME_MESSAGE = "Server {} must have property podName set for helm chart servers!";
    public static final String HOST_NAME_MESSAGE = "hostname must not be set for helm chart servers! Use podName in helmChartOptions instead!";
    public static final String EXPOSED_PORT_MESSAGE = "The exposedPorts should look like \"<POD_NAME_OR_REGEX>,<LOCAL_PORT>:<FORWARDING_PORT>,<LOCAL_PORT>:<FORWARDING_PORT>* \"! Please check your tiger.yml!";
    private final KubeUtils kubeUtils;

    public HelmChartServer(TigerTestEnvMgr tigerTestEnvMgr, String serverId, CfgServer configuration) {
        super("", serverId, configuration, tigerTestEnvMgr);
        this.kubeUtils = new KubeUtils((AbstractTigerServer)this, tigerTestEnvMgr.getExecutor());
    }

    public void assertThatConfigurationIsCorrect() {
        File f;
        super.assertThatConfigurationIsCorrect();
        this.assertCfgPropertySet(this.getConfiguration(), new String[]{"source"});
        if (this.getConfiguration().getSource().size() != 1) {
            throw new TigerTestEnvException(SOURCE_MESSAGE);
        }
        if (this.getConfiguration().getHostname() != null) {
            throw new TigerTestEnvException(HOST_NAME_MESSAGE);
        }
        CfgHelmChartOptions options = this.getConfiguration().getHelmChartOptions();
        if (options.getPodName() == null) {
            throw new TigerTestEnvException(PORT_NAME_MESSAGE);
        }
        if (options.getLogPods() == null) {
            this.log.warn("Detected empty logPods list, adding entry list as default value");
            options.setLogPods(new ArrayList());
        }
        if (options.getHealthcheckPods() == null) {
            this.log.warn("Detected empty healthcheckPod list, adding podName {} as default entry", (Object)this.getHelmChartOptions().getPodName());
            options.setHealthcheckPods(List.of(this.getHelmChartOptions().getPodName() + ".*"));
        }
        if (options.getWorkingDir() == null) {
            options.setWorkingDir(new File(".").getAbsolutePath());
            this.log.warn("Working folder not specified, defaulting to current working directory {}", (Object)options.getWorkingDir());
        }
        if (!(f = new File(options.getWorkingDir())).exists() && !f.mkdirs()) {
            throw new TigerTestEnvException("Unable to create working dir folder " + f.getAbsolutePath());
        }
        this.kubeUtils.setWorkingDirectory(this.getHelmChartOptions().getWorkingDir());
        this.checkExposedPorts(this.getHelmChartOptions().getExposedPorts());
    }

    private void checkExposedPorts(List<String> exposedPorts) {
        if (exposedPorts == null) {
            return;
        }
        exposedPorts.forEach(entry -> {
            List singleEx = Arrays.stream((entry = entry.replaceAll("\\s", "")).split(",")).collect(Collectors.toList());
            if (singleEx.size() < 2 || !((String)singleEx.get(0)).matches("[a-zA-Z*_.-]{3,}")) {
                throw new TigerTestEnvException(EXPOSED_PORT_MESSAGE);
            }
            singleEx.subList(1, singleEx.size()).forEach(port -> {
                if (!port.matches("\\d{2,5}") && !port.matches("\\d{2,5}:\\d{2,5}")) {
                    throw new TigerTestEnvException(EXPOSED_PORT_MESSAGE);
                }
            });
        });
    }

    public void performStartup() {
        int exitCode;
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().type(this.getServerTypeToken()).build());
        this.kubeUtils.setKubernetesContext(this.getHelmChartOptions().getContext());
        this.log.info("Checking for left over pods of helm chart {}...", (Object)this.getHelmChartOptions().getPodName());
        try {
            if (this.kubeUtils.getNumOfPodsOnStatusList(this.getHelmChartOptions().getNameSpace()) != 0L) {
                this.log.warn("Detected left over helm chart {}\nUninstalling before installing new version", (Object)this.getServerId());
                this.shutdown();
            }
        }
        catch (TigerTestEnvException exception) {
            this.log.warn("Exception while checking for left over pods of helm chart " + this.getServerId() + "!\nCheck your cluster setup!", (Throwable)exception);
            throw exception;
        }
        this.setStatus(TigerServerStatus.STARTING, "Starting helm chart for " + this.getServerId() + " from " + (String)this.getConfiguration().getSource().get(0) + " as pod " + this.getConfiguration().getHelmChartOptions().getPodName());
        try {
            CompletableFuture<Process> startHelmChart = this.kubeUtils.startupHelmChart();
            startHelmChart.thenAccept(process -> {
                new TigerStreamLogFeeder(this.log, process.getInputStream(), Level.INFO);
                new TigerStreamLogFeeder(this.log, process.getErrorStream(), Level.ERROR);
                this.statusMessage("Started helm upgrade for " + this.getServerId() + " with PID '" + process.pid() + "'");
            });
            exitCode = this.kubeUtils.getSafely(startHelmChart, "start helm chart").waitFor();
        }
        catch (InterruptedException e) {
            this.log.error("Failed to start helm chart - InterruptedException {}", (Object)this.getServerId());
            throw new TigerTestEnvException("Failed to start helm chart - InterruptedException {}", (Throwable)e);
        }
        if (exitCode != 0) {
            this.log.error("Failed to start helm chart for server {}, exitCode was {}", (Object)this.getServerId(), (Object)exitCode);
            throw new TigerTestEnvException("Failed to start helm chart for server %s! Please check log!", new Object[]{this.getServerId()});
        }
        this.waitForServerUp();
        this.logAllPods();
        if (this.getHelmChartOptions().getExposedPorts() != null) {
            this.kubeUtils.exposePortsViaKubectl(this.getHelmChartOptions());
        }
    }

    private void logAllPods() {
        this.getHelmChartOptions().getLogPods().parallelStream().forEach(podName -> this.kubeUtils.addLogForPod((String)podName, this.getHelmChartOptions().getNameSpace()));
    }

    public TigerServerStatus updateStatus(boolean quiet) {
        try {
            this.log.debug("Getting status of helm chart {}...", (Object)this.getServerId());
            this.setStatus(this.kubeUtils.getNumOfRunningPods(this.getHelmChartOptions().getNameSpace()) == (long)this.getHelmChartOptions().getHealthcheckPods().size() ? TigerServerStatus.RUNNING : TigerServerStatus.STARTING);
            return this.getStatus();
        }
        catch (TigerTestEnvException ttException) {
            TigerTestEnvException ex = new TigerTestEnvException("Unable to look up kubernetes pods for helm chart " + this.getServerId(), (Throwable)ttException);
            if (!quiet) {
                this.setStatus(TigerServerStatus.STOPPED, ex.getMessage());
                throw ex;
            }
            return this.getStatus();
        }
    }

    boolean isHealthCheckNone() {
        return false;
    }

    Optional<String> getHealthcheckUrl() {
        if (this.getHelmChartOptions().getContext() != null) {
            return Optional.of("kubernetes cluster context '" + this.getHelmChartOptions().getContext() + "'");
        }
        return Optional.of("kubernetes cluster");
    }

    public void shutdown() {
        this.log.info("Stopping helm chart {}...", (Object)this.getServerId());
        if (this.getConfiguration().getHelmChartOptions().getPodName() == null) {
            this.log.warn("Helm chart pod name not specified in tiger.yaml under helmChartOptions -> podName. No helm chart could have been started!");
            this.kubeUtils.stopAllProcesses();
            return;
        }
        this.kubeUtils.setKubernetesContext(this.getHelmChartOptions().getContext());
        this.kubeUtils.stopAllProcesses();
        Optional<CompletableFuture<Process>> shutdownFuture = this.kubeUtils.shutdownHelm(this.getHelmChartOptions().getNameSpace());
        shutdownFuture.ifPresent(future -> {
            try {
                if (((Process)this.kubeUtils.getSafely(future, "shutdown helm chart")).waitFor() != 0) {
                    this.log.error("Failed to uninstall helm chart {}", (Object)this.getServerId());
                    this.setStatus(TigerServerStatus.STOPPED, "Failed to stop helm chart " + this.getServerId() + ". Please clean up manually!");
                    return;
                }
                this.waitForShutdownToComplete();
                this.setStatus(TigerServerStatus.STOPPED, "Helm chart " + this.getServerId() + " deleted");
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                String msg = "Timeout while stopping helm chart " + this.getServerId() + ".\nPlease clean up manually!";
                this.setStatus(TigerServerStatus.STOPPED, msg);
                throw new TigerTestEnvException(msg, (Throwable)ie);
            }
            catch (TigerTestEnvException tteException) {
                String msg = "Failed to stop helm chart " + this.getServerId() + ".\n" + tteException.getMessage() + "\nPlease clean up manually!";
                this.setStatus(TigerServerStatus.STOPPED, msg);
                throw new TigerTestEnvException(msg, (Throwable)tteException);
            }
        });
    }

    private void waitForShutdownToComplete() {
        if (this.getHelmChartOptions().getHealthcheckPods().isEmpty()) {
            this.log.warn("No HealthcheckPods defined, assuming shutdown went well...");
        } else {
            try {
                long timems = System.currentTimeMillis();
                Awaitility.await().atMost((long)this.getConfiguration().getStartupTimeoutSec().intValue(), TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until(() -> {
                    try {
                        long runningPods = this.kubeUtils.getNumOfPodsOnStatusList(this.getHelmChartOptions().getNameSpace());
                        if (this.getHelmChartOptions().isDebug() && runningPods != 0L) {
                            this.log.info("{} pods of helm chart {} still present, waiting {}s ", new Object[]{runningPods, this.getServerId(), (System.currentTimeMillis() - timems) / 1000L});
                        }
                        return runningPods == 0L;
                    }
                    catch (TigerTestEnvException e) {
                        return false;
                    }
                });
            }
            catch (ConditionTimeoutException cte) {
                throw new TigerTestEnvException("Timeout waiting for helm chart server %s shutdown!", new Object[]{this.getServerId()});
            }
        }
    }

    public CfgHelmChartOptions getHelmChartOptions() {
        return this.getConfiguration().getHelmChartOptions();
    }
}

