/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerRoute;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.servers.AbstractTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.DockerAbstractServer;
import de.gematik.test.tiger.testenvmgr.servers.DockerMgr;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerType;

@TigerServerType(value="docker")
public class DockerServer
extends DockerAbstractServer {
    public static final DockerMgr dockerManager = new DockerMgr();

    public DockerServer(TigerTestEnvMgr tigerTestEnvMgr, String serverId, CfgServer configuration) {
        super(DockerServer.determineHostname((CfgServer)configuration, (String)serverId), serverId, configuration, tigerTestEnvMgr);
    }

    public void assertThatConfigurationIsCorrect() {
        super.assertThatConfigurationIsCorrect();
        this.assertCfgPropertySet(this.getConfiguration(), new String[]{"version"});
        this.assertCfgPropertySet(this.getConfiguration(), new String[]{"source"});
    }

    public void performStartup() {
        this.statusMessage("Starting docker container for " + this.getServerId() + " from '" + this.getDockerSource() + "'");
        dockerManager.startContainer(this);
        if (this.getDockerOptions().getPorts() != null && !this.getDockerOptions().getPorts().isEmpty()) {
            this.addRoute(TigerRoute.builder().from("http://" + this.getHostname()).to("http://" + (String)DockerMgr.DOCKER_HOST.getValueOrDefault() + ":" + this.getDockerOptions().getPorts().values().iterator().next()).build());
        }
        this.statusMessage("Docker container " + this.getServerId() + " started");
    }

    protected void processExports() {
        super.processExports();
        if (this.getDockerOptions().getPorts() != null && !this.getDockerOptions().getPorts().isEmpty()) {
            this.getConfiguration().getExports().forEach(exp -> {
                String origValue;
                String[] kvp = exp.split("=", 2);
                kvp[1] = origValue = TigerGlobalConfiguration.readString((String)kvp[0]);
                if (this.getDockerOptions().getPorts() != null) {
                    this.getDockerOptions().getPorts().forEach((localPort, externPort) -> {
                        kvp[1] = kvp[1].replace("${PORT:" + localPort + "}", String.valueOf(externPort));
                    });
                }
                if (!origValue.equals(kvp[1])) {
                    this.log.info("Setting global property {}={}", (Object)kvp[0], (Object)kvp[1]);
                    TigerGlobalConfiguration.putValue((String)kvp[0], (String)kvp[1], (SourceType)SourceType.RUNTIME_EXPORT);
                }
            });
        }
    }

    public String getDockerSource() {
        return (String)this.getConfiguration().getSource().get(0);
    }

    public void shutdown() {
        this.log.info("Stopping docker container {}...", (Object)this.getServerId());
        dockerManager.stopContainer((AbstractTigerServer)this);
        this.setStatus(TigerServerStatus.STOPPED, "Docker container " + this.getServerId() + " stopped");
    }

    public static DockerServerBuilder builder() {
        return new DockerServerBuilder();
    }

    public static class DockerServerBuilder {
        private TigerTestEnvMgr tigerTestEnvMgr;
        private String serverId;
        private CfgServer configuration;

        DockerServerBuilder() {
        }

        public DockerServerBuilder tigerTestEnvMgr(TigerTestEnvMgr tigerTestEnvMgr) {
            this.tigerTestEnvMgr = tigerTestEnvMgr;
            return this;
        }

        public DockerServerBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public DockerServerBuilder configuration(CfgServer configuration) {
            this.configuration = configuration;
            return this;
        }

        public DockerServer build() {
            return new DockerServer(this.tigerTestEnvMgr, this.serverId, this.configuration);
        }

        public String toString() {
            return "DockerServer.DockerServerBuilder(tigerTestEnvMgr=" + this.tigerTestEnvMgr + ", serverId=" + this.serverId + ", configuration=" + this.configuration + ")";
        }
    }
}

