/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.vauchannel.protocol.helpers;

import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.Date;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.isismtt.ocsp.CertHash;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.BasicOCSPRespBuilder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class OCSPResponseGenerator {
    private static final AlgorithmIdentifier SHA256_OID = new AlgorithmIdentifier(new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.1"));

    public static OCSPResp gen(X509Certificate eeCertJca, X509Certificate caCertJca, X509Certificate ocspSignerCertJa, PrivateKey ocspSignerPrivateKey, CertificateStatus status) throws CertificateException {
        return OCSPResponseGenerator.gen(eeCertJca, caCertJca, ocspSignerCertJa, ocspSignerPrivateKey, status, ZonedDateTime.now());
    }

    public static OCSPResp gen(X509Certificate eeCertJca, X509Certificate caCertJca, X509Certificate ocspSignerCertJa, PrivateKey ocspSignerPrivateKey, CertificateStatus status, ZonedDateTime dateTime) throws CertificateException {
        try {
            JcaX509CertificateHolder caCertificate = new JcaX509CertificateHolder(caCertJca);
            BcDigestCalculatorProvider digCalcProv = new BcDigestCalculatorProvider();
            BasicOCSPRespBuilder basicBuilder = new BasicOCSPRespBuilder(SubjectPublicKeyInfo.getInstance((Object)ocspSignerCertJa.getPublicKey().getEncoded()), digCalcProv.get(CertificateID.HASH_SHA1));
            CertificateID certId = new CertificateID(digCalcProv.get(CertificateID.HASH_SHA1), (X509CertificateHolder)caCertificate, eeCertJca.getSerialNumber());
            byte[] certHash = DigestUtils.sha256((byte[])eeCertJca.getEncoded());
            Extensions singleResponseExtensions = new Extensions(new Extension(new ASN1ObjectIdentifier("1.3.36.8.3.13"), false, new CertHash(SHA256_OID, certHash).toASN1Primitive().getEncoded()));
            Date updateDate = new Date();
            if (status != CertificateStatus.GOOD) {
                updateDate = new Date(updateDate.getTime() - 60000L);
            }
            basicBuilder.addResponse(certId, status, updateDate, null, singleResponseExtensions);
            X509CertificateHolder[] chain = new X509CertificateHolder[]{new X509CertificateHolder(ocspSignerCertJa.getEncoded())};
            BasicOCSPResp resp = basicBuilder.build(new JcaContentSignerBuilder("SHA256withECDSA").setProvider("BC").build(ocspSignerPrivateKey), chain, new Date(dateTime.toInstant().toEpochMilli()));
            OCSPRespBuilder builder = new OCSPRespBuilder();
            return builder.build(0, (Object)resp);
        }
        catch (Exception e) {
            throw new CertificateException("cannot generate OCSP response", e);
        }
    }
}

