/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.vauchannel.protocol.helpers;

import de.gematik.ti.vauchannel.protocol.helpers.Identity;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class KeyProvider {
    public static X509Certificate getCertificate2(String p12Password, String p12Path) throws Exception {
        KeyStore p12 = KeyStore.getInstance("pkcs12", "BC");
        p12.load(new FileInputStream(p12Path), p12Password.toCharArray());
        X509Certificate c = null;
        Enumeration<String> e = p12.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            c = (X509Certificate)p12.getCertificate(alias);
        }
        return c;
    }

    public static PrivateKey getPrivateKey2(String p12Password, String privateKeyPassword, String p12Path) throws Exception {
        KeyStore p12 = KeyStore.getInstance("pkcs12", "BC");
        p12.load(new FileInputStream(p12Path), p12Password.toCharArray());
        PrivateKey privateKey = null;
        Enumeration<String> e = p12.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            privateKey = (PrivateKey)p12.getKey(alias, privateKeyPassword.toCharArray());
        }
        return privateKey;
    }

    public static Identity getIdentity(String p12Password, String privateKeyPassword, String p12Path) throws Exception {
        KeyStore p12 = KeyStore.getInstance("pkcs12", "BC");
        p12.load(new FileInputStream(p12Path), p12Password.toCharArray());
        Identity identity = null;
        Enumeration<String> e = p12.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            X509Certificate c = (X509Certificate)p12.getCertificate(alias);
            PrivateKey privateKey = (PrivateKey)p12.getKey(alias, privateKeyPassword.toCharArray());
            identity = new Identity(privateKey, c);
        }
        return identity;
    }

    public static Identity getIdentity(byte[] p12Bytes, String p12Password, String privateKeyPassword) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, CertificateException, NoSuchProviderException {
        KeyStore p12 = KeyStore.getInstance("pkcs12", "BC");
        p12.load(new ByteArrayInputStream(p12Bytes), p12Password.toCharArray());
        Identity identity = null;
        Enumeration<String> e = p12.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            X509Certificate c = (X509Certificate)p12.getCertificate(alias);
            PrivateKey privateKey = (PrivateKey)p12.getKey(alias, privateKeyPassword.toCharArray());
            identity = new Identity(privateKey, c);
        }
        return identity;
    }
}

