/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.vauchannel.protocol.helpers;

import com.google.common.primitives.Longs;
import de.gematik.ti.vauchannel.protocol.TransportedData;
import de.gematik.ti.vauchannel.protocol.helpers.HexUtils;
import de.gematik.ti.vauchannel.protocol.helpers.VAUProtocolHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Data {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public long counter;
    public byte[] raw;
    public byte[] keyId;
    byte version;

    public Data(byte[] keyId, long counter, TransportedData transportedData) {
        this.keyId = keyId;
        this.counter = counter;
        this.version = 1;
        this.raw = transportedData.getRaw();
        this.log();
    }

    public Data(byte[] keyId, byte[] all) {
        this.keyId = keyId;
        this.version = all[0];
        byte[] rawCounter = new byte[8];
        System.arraycopy(all, 1, rawCounter, 0, 8);
        this.counter = Longs.fromByteArray((byte[])rawCounter);
        this.raw = new byte[all.length - 8 - 1];
        System.arraycopy(all, 9, this.raw, 0, this.raw.length);
        this.log();
    }

    public void log() {
        this.log.info("keyid: " + HexUtils.convertToLowerCaseHexWith64ByteLength(this.keyId) + ", counter for decrypt: " + this.counter);
    }

    public byte[] getEncoded() {
        return VAUProtocolHelpers.concat(new byte[]{this.version}, VAUProtocolHelpers.concat(Longs.toByteArray((long)this.counter), this.raw));
    }

    public TransportedData getDecryptedData() {
        return TransportedData.fromRaw(this.raw);
    }
}

