/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.vauchannel.protocol;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.rs.vau.VAUClientHello;
import de.gematik.rs.vau.VAUClientHelloData;
import de.gematik.rs.vau.VAUClientSigFin;
import de.gematik.rs.vau.VAUServerError;
import de.gematik.rs.vau.VAUServerErrorData;
import de.gematik.rs.vau.VAUServerFin;
import de.gematik.rs.vau.VAUServerHello;
import de.gematik.rs.vau.VAUServerHelloData;
import de.gematik.ti.vauchannel.protocol.TransportedData;
import de.gematik.ti.vauchannel.protocol.VAUProtocolCrypto;
import de.gematik.ti.vauchannel.protocol.VAUProtocolException;
import de.gematik.ti.vauchannel.protocol.VAUProtocolSession;
import de.gematik.ti.vauchannel.protocol.VAUProtocolSessionPersister;
import de.gematik.ti.vauchannel.protocol.VAUProtocolSessionState;
import de.gematik.ti.vauchannel.protocol.helpers.AESGCM;
import de.gematik.ti.vauchannel.protocol.helpers.Base64;
import de.gematik.ti.vauchannel.protocol.helpers.Data;
import de.gematik.ti.vauchannel.protocol.helpers.EncData;
import de.gematik.ti.vauchannel.protocol.helpers.HexUtils;
import de.gematik.ti.vauchannel.protocol.helpers.ObjectMapperFactory;
import de.gematik.ti.vauchannel.protocol.helpers.VAUProtocolHelpers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VAUProtocol {
    static final String KeyID = "KeyID";
    static final String AES256GCMKeyServer2Client = "AES-256-GCM-Key-Server-to-Client";
    static final String AES256GCMKeyClient2Server = "AES-256-GCM-Key-Client-to-Server";
    static Logger logger = LoggerFactory.getLogger(VAUProtocol.class);
    private ObjectMapper mapper = ObjectMapperFactory.objectMapper();
    private VAUProtocolCrypto crypto;
    private VAUProtocolSession session;
    private VAUProtocolSessionPersister persister;

    public VAUProtocol(VAUProtocolCrypto crypto, VAUProtocolSession session, VAUProtocolSessionPersister persister) {
        this.crypto = crypto;
        this.session = session;
        this.persister = persister;
    }

    public VAUProtocol(VAUProtocolCrypto crypto, VAUProtocolSession session) {
        this.crypto = crypto;
        this.session = session;
    }

    public static byte[] getKeyIDFromRawRequest(byte[] rawRequest) {
        EncData d = new EncData(rawRequest);
        return d.keyID;
    }

    public String handshakeStep1_generate_VAUClientHello_Message(byte[] authzToken) {
        String authzTokenStr = null;
        if (authzToken != null) {
            authzTokenStr = Base64.encode2String(authzToken);
        }
        VAUClientHello vAUClientHello = this.handshakeStep1_generate_VAUClientHello_Object(authzTokenStr);
        String message = null;
        try {
            message = this.mapper.writeValueAsString((Object)vAUClientHello);
        }
        catch (JsonProcessingException e) {
            this.handleNotRecoverableException((Exception)((Object)e), "message syntax not correct");
        }
        VAUProtocolHelpers.logJSON(message);
        this.tryToPersist();
        return message;
    }

    private VAUClientHello handshakeStep1_generate_VAUClientHello_Object(String authorizationAssertion) {
        this.session().initialize();
        VAUClientHelloData vAUClientHelloData = new VAUClientHelloData();
        vAUClientHelloData.setAuthorizationAssertion(authorizationAssertion);
        vAUClientHelloData.setDataType(VAUClientHelloData.DataType.VAU_CLIENT_HELLO_DATA);
        vAUClientHelloData.setCipherConfiguration(VAUProtocolHelpers.getCipherConfiguration());
        try {
            byte[] certBytes = this.crypto.getEECertificate().getEncoded();
            String certHash = Base64.encode2String(this.crypto.hash(certBytes));
            vAUClientHelloData.setCertificateHash(certHash);
        }
        catch (Exception e) {
            this.handleNotRecoverableException(e, "internal server error");
        }
        this.session().setEphemeralKeyPair(this.crypto.generateECCKeyPair());
        vAUClientHelloData.setPublicKey(Base64.encode2String(this.session().getEphemeralKeyPair().getPublic().getEncoded()));
        String vAUClientHelloDataStr = null;
        try {
            vAUClientHelloDataStr = this.mapper.writeValueAsString((Object)vAUClientHelloData);
        }
        catch (JsonProcessingException e) {
            this.handleNotRecoverableException((Exception)((Object)e), "message syntax not correct");
        }
        VAUProtocolHelpers.logJSON(vAUClientHelloDataStr);
        byte[] data = Base64.encode(vAUClientHelloDataStr);
        this.session().setClientHelloDataHash(this.crypto.hash(data));
        VAUClientHello vAUClientHello = new VAUClientHello();
        vAUClientHello.setMessageType(VAUClientHello.MessageType.VAU_CLIENT_HELLO);
        vAUClientHello.setData(new String(data, StandardCharsets.UTF_8));
        return vAUClientHello;
    }

    public String handshakeStep2_generate_VAUServerHello_Message(String vAUClientHelloStr) {
        this.session().initialize();
        try {
            VAUProtocolHelpers.logJSON(vAUClientHelloStr);
            VAUClientHello vAUClientHello = (VAUClientHello)this.mapper.readValue(vAUClientHelloStr, VAUClientHello.class);
            VAUServerHello vAUServerHello = this.handshakeStep2_generate_VAUServerHello_Object(vAUClientHello);
            String vAUServerHelloStr = this.mapper.writeValueAsString((Object)vAUServerHello);
            VAUProtocolHelpers.logJSON(vAUServerHelloStr);
            this.tryToPersist();
            return vAUServerHelloStr;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            if ("context manager: Access Denied".equals(e.getMessage())) {
                return "context manager: Access Denied";
            }
            return this.generateVAUServerErrorMessage(e.getMessage());
        }
    }

    private VAUServerHello handshakeStep2_generate_VAUServerHello_Object(VAUClientHello vAUClientHello) {
        String vAUClientHelloDataStr = vAUClientHello.getData();
        VAUProtocolHelpers.logJSON(vAUClientHelloDataStr);
        byte[] vAUClientHelloDataHash = this.crypto.hash(vAUClientHelloDataStr.getBytes(StandardCharsets.UTF_8));
        VAUServerHello vAUServerHello = new VAUServerHello();
        vAUServerHello.setMessageType(VAUServerHello.MessageType.VAU_SERVER_HELLO);
        VAUServerHelloData vAUServerHelloData = new VAUServerHelloData();
        vAUServerHelloData.setDataType(VAUServerHelloData.DataType.VAU_SERVER_HELLO_DATA);
        vAUServerHelloData.setCipherConfiguration(VAUProtocolHelpers.getCipherConfiguration_());
        this.session().setEphemeralKeyPair(this.crypto.generateECCKeyPair());
        vAUServerHelloData.setPublicKey(Base64.encode2String(this.session().getEphemeralKeyPair().getPublic().getEncoded()));
        vAUServerHelloData.setVAUClientHelloDataHash(Base64.encode2String(vAUClientHelloDataHash));
        try {
            byte[] certBytes = this.crypto.getEECertificate().getEncoded();
            String certHash = Base64.encode2String(this.crypto.hash(certBytes));
            vAUServerHelloData.setCertificateHash(certHash);
        }
        catch (Exception e) {
            this.handleNotRecoverableException(e, "internal server error");
        }
        String vAUServerHelloDataStr = null;
        try {
            vAUServerHelloDataStr = this.mapper.writeValueAsString((Object)vAUServerHelloData);
        }
        catch (JsonProcessingException e) {
            this.handleNotRecoverableException((Exception)((Object)e), "message syntax not correct");
        }
        VAUProtocolHelpers.logJSON(vAUServerHelloData);
        vAUServerHello.setData(Base64.encode2String(vAUServerHelloDataStr.getBytes(StandardCharsets.UTF_8)));
        try {
            vAUServerHello.setSignature(Base64.encode2String(this.crypto.signECDSA(vAUServerHello.getData().getBytes(StandardCharsets.UTF_8))));
        }
        catch (Exception e) {
            this.handleNotRecoverableException(e, "internal server error");
        }
        try {
            vAUServerHello.setCertificate(Base64.encode2String(this.crypto.getEECertificate().getEncoded()));
        }
        catch (CertificateEncodingException e) {
            this.handleNotRecoverableException(e, "internal server error");
        }
        if (this.crypto.canProvideOcspResponse()) {
            try {
                vAUServerHello.setOCSPResponse(Base64.encode2String(this.crypto.getOcspResponse().getEncoded()));
            }
            catch (IOException e) {
                this.handleNotRecoverableException(e, "internal server error");
            }
        }
        VAUClientHelloData vAUClientHelloData = null;
        try {
            vAUClientHelloData = (VAUClientHelloData)this.mapper.readValue(Base64.decode(vAUClientHelloDataStr), VAUClientHelloData.class);
        }
        catch (IOException e) {
            this.handleNotRecoverableException(e, "message syntax not correct");
        }
        String authorizationAssertionStr = vAUClientHelloData.getAuthorizationAssertion();
        if (authorizationAssertionStr != null) {
            this.session.setAuthzToken(authorizationAssertionStr.getBytes(StandardCharsets.UTF_8));
        }
        this.crypto.validateAuthorizationAssertion(this.session, authorizationAssertionStr);
        this.session.setClientHelloDataCertificateHash(Base64.decode(vAUClientHelloData.getCertificateHash()));
        this.session.setClientHelloDataHash(vAUClientHelloDataHash);
        PublicKey ephemeralPublicKeyClient = this.crypto.eccPublicKeyFromBytes(Base64.decode(vAUClientHelloData.getPublicKey()));
        this.keyDerivation(ephemeralPublicKeyClient);
        byte[] hash = this.crypto.hash(vAUServerHello.getData().getBytes(StandardCharsets.UTF_8));
        this.session().setServerHelloDataHash(hash);
        return vAUServerHello;
    }

    private void keyDerivation(PublicKey ephemeralPublicKeyCounterpart) {
        BCECPublicKey ephemeralPublicKeyClientBC = (BCECPublicKey)ephemeralPublicKeyCounterpart;
        ECNamedCurveSpec spec = (ECNamedCurveSpec)ephemeralPublicKeyClientBC.getParams();
        if (!"brainpoolP256r1".equals(spec.getName())) {
            this.handleNotRecoverableException("invalid curve (ECDH)");
        }
        try {
            this.session().setShare(this.crypto.ECKA(this.session().getEphemeralKeyPair().getPrivate(), ephemeralPublicKeyCounterpart));
        }
        catch (Exception e) {
            this.handleNotRecoverableException(e, "internal server error");
        }
        logger.info("shared secret: " + Hex.encodeHexString((byte[])this.session().getShare()));
        this.session().setKeyID(this.crypto.HKDF(this.session().getShare(), KeyID, 256));
        logger.info("keyID: " + Hex.encodeHexString((byte[])this.session().getKeyID()));
        this.session().setSymKeyClientToServer(this.crypto.HKDF(this.session().getShare(), AES256GCMKeyClient2Server, 256));
        logger.info("AES-256-GCM-Key-Client-to-Server: " + Hex.encodeHexString((byte[])this.session().getSymKeyClientToServer()));
        this.session().setSymKeyServerToClient(this.crypto.HKDF(this.session().getShare(), AES256GCMKeyServer2Client, 256));
        logger.info("AES-256-GCM-Key-Server-to-Client: " + Hex.encodeHexString((byte[])this.session().getSymKeyServerToClient()));
    }

    public String handshakeStep3_generate_VAUClientSigFin_Message(String vAUServerHelloStr) {
        VAUProtocolHelpers.logJSON(vAUServerHelloStr);
        VAUServerHello vAUServerHello = null;
        try {
            vAUServerHello = (VAUServerHello)this.mapper.readValue(vAUServerHelloStr, VAUServerHello.class);
        }
        catch (Exception e) {
            try {
                VAUServerError vAUServerError = (VAUServerError)this.mapper.readValue(vAUServerHelloStr, VAUServerError.class);
            }
            catch (IOException ex) {
                this.handleNotRecoverableException(e, "message syntax not correct");
            }
            String serverErrorStr = this.validateAndUnpackServerError(vAUServerHelloStr);
            throw new VAUProtocolException(serverErrorStr);
        }
        VAUClientSigFin vAUClientSigFin = this.handshakeStep3_generate_VAUClientSigFin_Object(vAUServerHello);
        String vAUClientSigFinStr = null;
        try {
            vAUClientSigFinStr = this.mapper.writeValueAsString((Object)vAUClientSigFin);
        }
        catch (JsonProcessingException e) {
            this.handleNotRecoverableException((Exception)((Object)e), "message syntax not correct");
        }
        VAUProtocolHelpers.logJSON(vAUClientSigFinStr);
        this.tryToPersist();
        return vAUClientSigFinStr;
    }

    private VAUClientSigFin handshakeStep3_generate_VAUClientSigFin_Object(VAUServerHello vAUServerHello) {
        String hashStrB;
        String hashStrA;
        String vAUServerHelloDataStr = new String(Base64.decode(vAUServerHello.getData()));
        VAUProtocolHelpers.logJSON(vAUServerHelloDataStr);
        VAUProtocolHelpers.checkServerSignature(vAUServerHello, this.crypto);
        VAUServerHelloData vAUServerHelloData = null;
        try {
            vAUServerHelloData = (VAUServerHelloData)this.mapper.readValue(vAUServerHelloDataStr, VAUServerHelloData.class);
        }
        catch (IOException e) {
            this.handleNotRecoverableException(e, "message syntax not correct");
        }
        if (!Arrays.equals(Base64.decode(vAUServerHelloData.getVAUClientHelloDataHash()), this.session.getClientHelloDataHash())) {
            this.handleNotRecoverableException("unexpected VAUClientHelloDataHash");
        }
        if (!(hashStrA = vAUServerHelloData.getCertificateHash()).equals(hashStrB = Base64.encode2String(this.crypto.hash(Base64.decode(vAUServerHello.getCertificate()))))) {
            this.handleNotRecoverableException("unexpected Certificate Hash");
        }
        VAUClientSigFin vAUClientSigFin = new VAUClientSigFin();
        vAUClientSigFin.setOCSPResponse("");
        vAUClientSigFin.setMessageType(VAUClientSigFin.MessageType.VAU_CLIENT_SIG_FIN);
        vAUClientSigFin.setVAUClientHelloDataHash(Base64.encode2String(this.session().getClientHelloDataHash()));
        byte[] hash = this.crypto.hash(vAUServerHello.getData().getBytes(StandardCharsets.UTF_8));
        this.session().setServerHelloDataHash(hash);
        vAUClientSigFin.setVAUServerHelloDataHash(Base64.encode2String(hash));
        byte[] concatenatedHashes = VAUProtocolHelpers.concat(vAUClientSigFin.getVAUClientHelloDataHash().getBytes(StandardCharsets.UTF_8), vAUClientSigFin.getVAUServerHelloDataHash().getBytes(StandardCharsets.UTF_8));
        if (this.crypto.isECCIdentity()) {
            try {
                vAUClientSigFin.setSignature(Base64.encode2String(this.crypto.signECDSA(concatenatedHashes)));
            }
            catch (Exception e) {
                this.handleNotRecoverableException(e, "internal server error");
            }
        } else {
            try {
                vAUClientSigFin.setSignature(Base64.encode2String(this.crypto.signRSASSA_PSS(concatenatedHashes)));
            }
            catch (Exception e) {
                this.handleNotRecoverableException(e, "internal server error");
            }
        }
        try {
            vAUClientSigFin.setCertificate(Base64.encode2String(this.crypto.getEECertificate().getEncoded()));
        }
        catch (CertificateEncodingException e) {
            this.handleNotRecoverableException(e, "internal server error");
        }
        PublicKey ephemeralPublicKeyFromServer = this.crypto.eccPublicKeyFromBytes(Base64.decode(vAUServerHelloData.getPublicKey()));
        this.keyDerivation(ephemeralPublicKeyFromServer);
        byte[] concatenatedHashesUncoded = VAUProtocolHelpers.concat(Base64.decode(vAUClientSigFin.getVAUClientHelloDataHash()), Base64.decode(vAUClientSigFin.getVAUServerHelloDataHash()));
        byte[] stringBytes = VAUProtocolHelpers.concat("VAUClientSigFin".getBytes(StandardCharsets.UTF_8), concatenatedHashesUncoded);
        byte[] encryptedBytes = new byte[]{};
        try {
            encryptedBytes = AESGCM.encrypt(stringBytes, this.session().getSymKeyClientToServer());
        }
        catch (Exception e) {
            this.handleNotRecoverableException(e, "internal server error");
        }
        vAUClientSigFin.setFinishedData(Base64.encode2String(VAUProtocolHelpers.concat(this.session().getKeyID(), encryptedBytes)));
        return vAUClientSigFin;
    }

    public String handshakeStep4_generate_VAUServerFin_Message(String vAUClientSigFinStr) {
        try {
            VAUProtocolHelpers.logJSON(vAUClientSigFinStr);
            VAUClientSigFin vAUClientSigFin = (VAUClientSigFin)this.mapper.readValue(vAUClientSigFinStr, VAUClientSigFin.class);
            vAUClientSigFin.setMessageType(VAUClientSigFin.MessageType.VAU_CLIENT_SIG_FIN);
            VAUServerFin vAUServerFin = this.handshakeStep4_generate_VAUServerFin_Object(vAUClientSigFin);
            String vAUServerFinStr = this.mapper.writeValueAsString((Object)vAUServerFin);
            VAUProtocolHelpers.logJSON(vAUServerFinStr);
            this.session.setState(VAUProtocolSessionState.open);
            this.tryToPersist();
            return vAUServerFinStr;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this.generateVAUServerErrorMessage(e.getMessage());
        }
    }

    private VAUServerFin handshakeStep4_generate_VAUServerFin_Object(VAUClientSigFin vAUClientSigFin) {
        VAUProtocolHelpers.checkClientSignature(vAUClientSigFin, this.crypto);
        VAUProtocolHelpers.checkClientCertificateHash(vAUClientSigFin, this.crypto, this.session);
        VAUProtocolHelpers.checkFinishedDataFromClient(this.session(), vAUClientSigFin, this.session.getClientHelloDataHash(), this.session.getServerHelloDataHash());
        VAUServerFin vAUServerFin = new VAUServerFin();
        vAUServerFin.setMessageType(VAUServerFin.MessageType.VAU_SERVER_FIN);
        byte[] concatenatedHashes = VAUProtocolHelpers.concat(Base64.decode(vAUClientSigFin.getVAUClientHelloDataHash()), this.session().getServerHelloDataHash());
        concatenatedHashes = VAUProtocolHelpers.concat("VAUServerFin".getBytes(StandardCharsets.UTF_8), concatenatedHashes);
        try {
            byte[] encryptedString = AESGCM.encrypt(concatenatedHashes, this.session().getSymKeyServerToClient());
            byte[] stringBytes = VAUProtocolHelpers.concat(this.session().getKeyID(), encryptedString);
            vAUServerFin.setFinishedData(Base64.encode2String(stringBytes));
        }
        catch (Exception ex) {
            this.handleNotRecoverableException(ex, "internal server error");
        }
        return vAUServerFin;
    }

    public void handshakeStep5_validate_VAUServerFin_Message(String vAUServerFinStr) {
        VAUProtocolHelpers.logJSON(vAUServerFinStr);
        VAUServerFin vAUServerFin = null;
        try {
            vAUServerFin = (VAUServerFin)this.mapper.readValue(vAUServerFinStr, VAUServerFin.class);
        }
        catch (Exception e) {
            try {
                VAUServerError vAUServerError = (VAUServerError)this.mapper.readValue(vAUServerFinStr, VAUServerError.class);
            }
            catch (IOException ex) {
                this.handleNotRecoverableException(ex, "message syntax not correct");
            }
            String serverErrorStr = this.validateAndUnpackServerError(vAUServerFinStr);
            throw new VAUProtocolException(serverErrorStr);
        }
        VAUProtocolHelpers.checkFinishedDataFromServer(this.session(), vAUServerFin);
        this.session().setState(VAUProtocolSessionState.open);
        this.tryToPersist();
    }

    public String generateVAUServerErrorMessage(String errorMessage) {
        try {
            if (errorMessage == null) {
                errorMessage = "internal server error";
            }
            VAUServerErrorData data = new VAUServerErrorData();
            data.setDataType(VAUServerErrorData.DataType.VAU_SERVER_ERROR_DATA);
            data.setTime(this.crypto.now());
            data.setData(errorMessage);
            VAUServerError error = new VAUServerError();
            error.setMessageType(VAUServerError.MessageType.VAU_SERVER_ERROR);
            String dataStr = this.mapper.writeValueAsString((Object)data);
            VAUProtocolHelpers.logJSON(dataStr);
            String data64Str = Base64.encode2String(dataStr.getBytes(Charsets.UTF_8));
            error.setData(data64Str);
            error.setSignature(Base64.encode2String(this.crypto.signECDSA(data64Str.getBytes(Charsets.UTF_8))));
            error.setCertificate(Base64.encode2String(this.crypto.getEECertificate().getEncoded()));
            if (this.crypto.canProvideOcspResponse()) {
                error.setOCSPResponse(Base64.encode2String(this.crypto.getOcspResponse().getEncoded()));
            }
            VAUProtocolHelpers.logJSON(error);
            return this.mapper.writeValueAsString((Object)error);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return errorMessage;
        }
    }

    public String validateAndUnpackServerError(String serverErrorStr) {
        try {
            VAUServerError vAUServerError = (VAUServerError)this.mapper.readValue(serverErrorStr, VAUServerError.class);
            byte[] certBytes = Base64.decode(vAUServerError.getCertificate());
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream in = new ByteArrayInputStream(certBytes);
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(in);
            PublicKey publicKey = cert.getPublicKey();
            boolean ok = this.crypto.verify(vAUServerError.getData().getBytes(StandardCharsets.UTF_8), Base64.decode(vAUServerError.getSignature()), publicKey);
            if (!ok) {
                throw new VAUProtocolException("server error signature not valid");
            }
            VAUServerErrorData vauServerErrorData = (VAUServerErrorData)this.mapper.readValue(Base64.decode(vAUServerError.getData()), VAUServerErrorData.class);
            return vauServerErrorData.getData();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "exception parsing server error";
        }
    }

    public VAUProtocolSession session() {
        return this.session;
    }

    public VAUProtocolCrypto crypto() {
        return this.crypto;
    }

    public byte[] encrypt(TransportedData transportedData) {
        if (this.session.isForceErrorInEncryptIfCountIs6() && this.session.getCounter() == 5L) {
            this.handleNotRecoverableException("error has been forced by configuration");
        }
        if (this.session.isClient()) {
            if (this.session.getCounter() == 0L) {
                this.session.setCounter(1L);
            } else {
                this.session.setCounter(this.session.getCounter() + 2L);
            }
        }
        Data data = new Data(this.session.getKeyID(), this.session.getCounter(), transportedData);
        byte[] encData = null;
        try {
            logger.debug("### VAUProtocol.encrypt ###");
            encData = this.crypto.encrypt_AESGCM(data.getEncoded(), this.session.isClient() ? this.session.getSymKeyClientToServer() : this.session.getSymKeyServerToClient(), this.session.getCounter());
        }
        catch (Exception e) {
            this.handleNotRecoverableException(e, "encryption not successful");
        }
        EncData dataWrapper = new EncData(this.session.getKeyID(), encData);
        encData = dataWrapper.getEncoded();
        this.tryToPersist();
        return encData;
    }

    public TransportedData decrypt(byte[] in) {
        if (this.session != null && this.session.isForceErrorInDecryptIfCountIs5() && this.session.getCounter() == 4L) {
            this.handleNotRecoverableException("error has been forced by configuration");
        }
        EncData d = new EncData(in);
        if (this.session == null && !this.session.isClient() && this.session == null) {
            this.handleNotRecoverableException("AES-GCM decryption error.");
        }
        Data decryptedData = null;
        try {
            logger.info("### VAUProtocol.decrypt ###");
            decryptedData = new Data(d.keyID, this.crypto.decrypt_AESGCM(d.enc, !this.session.isClient() ? this.session.getSymKeyClientToServer() : this.session.getSymKeyServerToClient(), this.session.getCounter()));
        }
        catch (Exception e) {
            this.handleNotRecoverableException(e, "AES-GCM decryption error.");
        }
        if (!this.session.isClient()) {
            if (decryptedData.counter - this.session.getCounter() <= 0L) {
                this.handleNotRecoverableException("invalid counter value");
            }
            this.session.setCounter(decryptedData.counter + 1L);
            logger.info("keyid: " + HexUtils.convertToLowerCaseHexWith64ByteLength(this.session.getKeyID()) + ", counter for encrypt: " + this.session.getCounter());
            if (this.session.getCounter() == 0L) {
                this.handleNotRecoverableException("message counter overflow");
            }
        }
        this.tryToPersist();
        return decryptedData.getDecryptedData();
    }

    public void handleNotRecoverableException(String errorMessage) {
        logger.error(errorMessage);
        this.closeSession();
        throw new VAUProtocolException(errorMessage);
    }

    public void handleNotRecoverableException(Exception e, String errorMessage) {
        logger.error(e.getMessage(), (Throwable)e);
        this.handleNotRecoverableException(errorMessage);
    }

    public void closeSession() {
        if (this.getPersister() != null) {
            this.session.setState(VAUProtocolSessionState.closed);
            this.getPersister().markSessionForClosing(this.session);
        }
    }

    public void tryToPersist() {
        if (this.getPersister() != null) {
            this.getPersister().persist(this.session);
        }
    }

    public VAUProtocolSessionPersister getPersister() {
        return this.persister;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

