/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.vauchannel.protocol.helpers;

import de.gematik.ti.vauchannel.protocol.helpers.KeyPairGenerator;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Identity {
    private static final Logger logger = LoggerFactory.getLogger(Identity.class);
    public PrivateKey privateKey;
    public X509Certificate certificate;

    public Identity(PrivateKey privateKey, X509Certificate certificate) {
        this.privateKey = privateKey;
        this.certificate = certificate;
    }

    public static Identity generateSelfSigned_ECC() {
        Identity identity = null;
        try {
            KeyPair keyPair = KeyPairGenerator.generateECCKeyPair();
            X509Certificate cert = KeyPairGenerator.generateCertificate(keyPair, "CN=SelfSignedECCCertificate", "SHA256withECDSA");
            identity = new Identity(keyPair.getPrivate(), cert);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return identity;
    }

    public static Identity generateSelfSigned_RSA() throws Exception {
        Identity identity = null;
        try {
            KeyPair keyPair = KeyPairGenerator.generateRSAKeyPair();
            X509Certificate cert = KeyPairGenerator.selfSign(keyPair, "CN=SelfSignedECCCertificate", "SHA256withRSA");
            identity = new Identity(keyPair.getPrivate(), cert);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return identity;
    }
}

