/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.vauchannel.cxf;

import de.gematik.ti.vauchannel.cxf.DecryptedHTTPMessageLogger;
import de.gematik.ti.vauchannel.cxf.SOAPHelper;
import de.gematik.ti.vauchannel.cxf.VAUMessageContext;
import de.gematik.ti.vauchannel.cxf.VAUProtocolProvider;
import de.gematik.ti.vauchannel.protocol.TransportedData;
import de.gematik.ti.vauchannel.protocol.VAUProtocol;
import de.gematik.ti.vauchannel.protocol.VAUProtocolException;
import de.gematik.ti.vauchannel.protocol.VAUProtocolSession;
import de.gematik.ti.vauchannel.protocol.VAUProtocolSessionState;
import de.gematik.ti.vauchannel.protocol.helpers.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Hex;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.http.HTTPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AESInterceptor
extends AbstractPhaseInterceptor<Message> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    VAUProtocolProvider vauProtocolProvider;
    @Autowired(required=false)
    DecryptedHTTPMessageLogger decryptedHTTPMessageLogger;

    public AESInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) {
        String errorMessage = (String)message.getExchange().get((Object)"jsonerror");
        if (errorMessage == null) {
            try {
                this.handleVauProtocolAES(message);
            }
            catch (HTTPException he) {
                if (he.getResponseCode() == 403) {
                    this.log.error("got HTTP status code 403 -> access denied");
                }
                SoapFault f = new SoapFault("Access Denied", SoapFault.FAULT_CODE_CLIENT);
                f.setStatusCode(he.getResponseCode());
                throw f;
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                this.handleExceptionInEncryptionLayer(message, e);
            }
        } else {
            try {
                this.handleVauProtocolError(message, errorMessage);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void handleFault(Message message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleVauProtocolAES(Message message) throws Exception {
        String contentType = (String)message.get((Object)"Content-Type");
        if (this.vauProtocolProvider.isClient()) {
            VAUProtocol vauProtocol = this.vauProtocolProvider.getVAUProtocol();
            Object o = message.get((Object)"org.apache.cxf.message.inbound");
            if (o != null && ((Boolean)o).booleanValue() && contentType != null && contentType.startsWith("application/json")) {
                byte[] rawData = this.readContentFromMessage(message);
                String serverError = new String(rawData);
                this.log.info(serverError);
                String errorString = vauProtocol.validateAndUnpackServerError(serverError);
                this.log.info(errorString);
                SOAPHelper.writeErrorStringToMessage(errorString, message);
            }
        }
        if (contentType != null && contentType.startsWith("application/json")) {
            return;
        }
        boolean isOutbound = message == message.getExchange().getOutMessage() || message == message.getExchange().getOutFaultMessage();
        VAUMessageContext vauMessageContext = VAUMessageContext.VAU_CHANNEL_NOT_ALLOWED;
        if (contentType != null && contentType.startsWith("application/json")) {
            vauMessageContext = VAUMessageContext.VAU_CHANNEL_HANDSHAKE;
        } else if (isOutbound) {
            vauMessageContext = VAUMessageContext.VAU_CHANNEL_TRANSPORT;
        } else if (contentType != null && contentType.startsWith("application/octet-stream")) {
            vauMessageContext = VAUMessageContext.VAU_CHANNEL_TRANSPORT;
        }
        if (vauMessageContext == VAUMessageContext.VAU_CHANNEL_NOT_ALLOWED) {
            String errorMessage = "context manager: Access Denied";
            this.log.error(errorMessage);
            this.handleExceptionInEncryptionLayer(message, errorMessage);
        }
        if (isOutbound) {
            VAUProtocol vauProtocol = this.vauProtocolProvider.getVAUProtocol();
            VAUProtocolSession session = vauProtocol.session();
            if (session.isClient() && vauMessageContext == VAUMessageContext.VAU_CHANNEL_TRANSPORT && session.getSymKeyClientToServer() == null) {
                throw new VAUProtocolException("Access Denied");
            }
            OutputStream os = (OutputStream)message.getContent(OutputStream.class);
            CachedStream cs = new CachedStream();
            message.setContent(OutputStream.class, (Object)cs);
            message.getInterceptorChain().doIntercept(message);
            try {
                HashMap headers;
                cs.flush();
                Object originalContentType = (String)message.get((Object)"Content-Type");
                String encoding = (String)message.get((Object)"org.apache.cxf.message.Message.ENCODING");
                if (encoding != null) {
                    originalContentType = (String)originalContentType + "; charset=" + encoding;
                }
                if ((headers = (HashMap)message.get((Object)Message.PROTOCOL_HEADERS)) == null) {
                    headers = new HashMap();
                    message.put((Object)Message.PROTOCOL_HEADERS, headers);
                }
                message.put((Object)"org.apache.cxf.message.Message.ENCODING", null);
                message.put((Object)"Content-Type", (Object)"application/octet-stream");
                CachedOutputStream csNew = (CachedOutputStream)message.getContent(OutputStream.class);
                message.setContent(OutputStream.class, (Object)os);
                byte[] rawMessageData = csNew.getBytes();
                byte[] finalMessageData = null;
                if (!session.isClient() && this.isAccessDeniedException(rawMessageData)) {
                    if (this.isAccessDeniedExceptionByVAU(rawMessageData)) {
                        this.log.info("access denied by vau");
                        String errorStr = vauProtocol.generateVAUServerErrorMessage("Access Denied");
                        message.put((Object)"Content-Type", (Object)"application/json");
                        finalMessageData = errorStr.getBytes(Charsets.UTF_8);
                    } else {
                        this.log.info("access denied by context manager");
                    }
                    message.put((Object)Message.RESPONSE_CODE, (Object)403);
                    session.setState(VAUProtocolSessionState.closing);
                } else {
                    if (this.decryptedHTTPMessageLogger != null) {
                        this.decryptedHTTPMessageLogger.logMessage(!isOutbound, message, rawMessageData);
                    }
                    TransportedData transportedData = new TransportedData(rawMessageData, (String)originalContentType);
                    finalMessageData = vauProtocol.encrypt(transportedData);
                }
                if (!session.isClient() && session.getState() == VAUProtocolSessionState.closing) {
                    session.setState(VAUProtocolSessionState.closed);
                    this.vauProtocolProvider.closeVAUProtocol(vauProtocol);
                }
                os.write(finalMessageData, 0, finalMessageData.length);
                return;
            }
            catch (IOException e) {
                if (session == null) return;
                this.log.error(e.getMessage(), (Throwable)e);
                return;
            }
            finally {
                if (vauProtocol != null) {
                    vauProtocol.tryToPersist();
                }
                try {
                    cs.close();
                    os.flush();
                    os.close();
                }
                catch (HTTPException he) {
                    if (!session.isClient() || he.getResponseCode() != 403) throw he;
                    this.log.error("got HTTP status code 403 -> access denied");
                    throw he;
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        byte[] rawRequest = this.readContentFromMessage(message);
        VAUProtocol vauProtocol = null;
        byte[] keyID = null;
        try {
            keyID = VAUProtocol.getKeyIDFromRawRequest((byte[])rawRequest);
            vauProtocol = this.vauProtocolProvider.getVAUProtocolByKeyID(keyID);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            this.log.info("KeyID (Base64): " + Base64.encode2String((byte[])keyID));
            this.log.info("KeyID (Hex): " + Hex.encodeHexString((byte[])keyID));
            this.log.info("Message: \n" + Base64.encode2String((byte[])rawRequest));
            throw new VAUProtocolException("internal server error");
        }
        VAUProtocolSession session = vauProtocol.session();
        if (session.getState() == VAUProtocolSessionState.handshaking || session.getState() == VAUProtocolSessionState.closed) {
            session.setState(VAUProtocolSessionState.closed);
            vauProtocol.tryToPersist();
            throw new VAUProtocolException("Access Denied");
        }
        TransportedData transportedData = vauProtocol.decrypt(rawRequest);
        message.put((Object)"Content-Type", (Object)transportedData.contentType);
        String charset = HttpHeaderHelper.findCharset((String)transportedData.contentType);
        message.put((Object)"org.apache.cxf.message.Message.ENCODING", (Object)charset);
        if (this.decryptedHTTPMessageLogger != null) {
            this.decryptedHTTPMessageLogger.logMessage(!isOutbound, message, transportedData.body);
        }
        ByteArrayInputStream myInputStream = new ByteArrayInputStream(transportedData.body);
        message.setContent(InputStream.class, (Object)myInputStream);
    }

    private boolean isAccessDeniedException(byte[] rawMessageData) {
        try {
            String xml = new String(rawMessageData, Charsets.UTF_8);
            return xml.indexOf("Access Denied") != -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isAccessDeniedExceptionByVAU(byte[] rawMessageData) {
        try {
            String xml = new String(rawMessageData, Charsets.UTF_8);
            return xml.indexOf("context manager: Access Denied") == -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public byte[] readContentFromMessage(Message message) {
        InputStream is = (InputStream)message.getContent(InputStream.class);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)is, (OutputStream)bout);
        }
        catch (IOException ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        byte[] rawRequest = bout.toByteArray();
        return rawRequest;
    }

    private void handleExceptionInEncryptionLayer(Message message, Exception e) {
        String errorMessage = e.getMessage();
        this.handleExceptionInEncryptionLayer(message, errorMessage);
    }

    private void handleExceptionInEncryptionLayer(Message message, String errorMessage) {
        VAUProtocol vauProtocol = this.vauProtocolProvider.getVAUProtocol();
        if (!vauProtocol.session().isClient()) {
            message.getExchange().put((Object)"jsonerror", (Object)errorMessage);
            HttpServletResponse httpResponse = (HttpServletResponse)message.get((Object)"HTTP.RESPONSE");
            this.log.error("Exception in Encryption Layer");
            throw new RuntimeException(errorMessage);
        }
        this.log.error(errorMessage);
    }

    private void handleVauProtocolError(Message message, String jsonerror) {
        message.put((Object)"Content-Type", (Object)"application/json");
        HttpServletResponse httpResponse = (HttpServletResponse)message.get((Object)"HTTP.RESPONSE");
        VAUProtocol vauProtocol = this.vauProtocolProvider.getVAUProtocol();
        VAUProtocolSession session = vauProtocol.session();
        session.setState(VAUProtocolSessionState.closed);
        this.vauProtocolProvider.closeVAUProtocol(vauProtocol);
        vauProtocol.tryToPersist();
        String errorStr = "";
        errorStr = "context manager: Access Denied".equals(jsonerror) ? jsonerror : vauProtocol.generateVAUServerErrorMessage(jsonerror);
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        CachedStream cs = new CachedStream();
        message.setContent(OutputStream.class, (Object)cs);
        message.getInterceptorChain().doIntercept(message);
        try {
            cs.flush();
            CachedOutputStream csnew = (CachedOutputStream)message.getContent(OutputStream.class);
            message.setContent(OutputStream.class, (Object)os);
            csnew.getBytes();
            byte[] data_ = errorStr.getBytes(StandardCharsets.UTF_8);
            os.write(data_, 0, data_.length);
            cs.close();
            os.flush();
            os.close();
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private class CachedStream
    extends CachedOutputStream {
        public CachedStream() {
            super(0x40000000L);
        }

        protected void doFlush() throws IOException {
            this.currentStream.flush();
        }

        protected void doClose() throws IOException {
        }

        protected void onWrite() throws IOException {
        }
    }
}

