/*
Copyright (c) 2020 gematik GmbH

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package de.gematik.ti.vauchannel.cxf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOAPHelper {

  private static final Logger logger = LoggerFactory.getLogger(SOAPHelper.class);

  public static void writeErrorStringToMessage(String errorString, Message message) {
    try {
      MessageFactory factory = MessageFactory.newInstance(SOAPConstants.SOAP_1_2_PROTOCOL);
      SOAPMessage soapMessage = factory.createMessage();
      SOAPFault fault = soapMessage.getSOAPBody().addFault();
      fault.setFaultString(errorString);
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      soapMessage.writeTo(baos);
      InputStream myInputStream = new ByteArrayInputStream(baos.toByteArray());
      message.setContent(InputStream.class, myInputStream);
    } catch (Exception e) {
      logger.error(e.getMessage(), e);
    }
  }
}
