/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.test.utils.parser;

import de.gematik.ti.cardreader.provider.api.command.CommandApdu;
import de.gematik.ti.utils.codec.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApduParser {
    private static final Logger LOG = LoggerFactory.getLogger(ApduParser.class);
    private static final int MIN_APDU_LENGTH = 4;
    private static final int BYTE_MASK = 255;
    private static final int EXPECTED_LENGTH_WILDCARD_SHORT = 256;
    private static final int EXPECTED_LENGTH_WILDCARD_EXTENDED = 65536;

    private ApduParser() {
    }

    public static CommandApdu toCommandApdu(String apduString) {
        byte[] apduRaw = Hex.decode((String)apduString);
        byte[] apdu = (byte[])apduRaw.clone();
        return ApduParser.parse(apdu);
    }

    public static CommandApdu toCommandApdu(byte[] apduRaw) {
        byte[] apdu = (byte[])apduRaw.clone();
        return ApduParser.parse(apdu);
    }

    private static CommandApdu parse(byte[] apdu) {
        if (apdu.length < 4) {
            throw new IllegalArgumentException("apdu must be at least 4 bytes long");
        }
        if (apdu.length == 4) {
            LOG.debug("It's a Command of CASE-1");
            return new CommandApdu(apdu[0] & 0xFF, apdu[1] & 0xFF, apdu[2] & 0xFF, apdu[3] & 0xFF);
        }
        int l1 = apdu[4] & 0xFF;
        if (apdu.length == 5) {
            return ApduParser.doCase2e(apdu, l1, "It's a Command of CASE-2s", 256);
        }
        if (l1 != 0) {
            if (apdu.length == 5 + l1) {
                return ApduParser.doCase3(apdu, l1, "It's a Command of CASE-3s", 5);
            }
            if (apdu.length == 6 + l1) {
                return ApduParser.doCase4s(apdu, l1);
            }
            throw new IllegalArgumentException("Invalid APDU: length=" + apdu.length + ", b1=" + l1);
        }
        if (apdu.length < 7) {
            throw new IllegalArgumentException("Invalid APDU: length=" + apdu.length + ", b1=" + l1);
        }
        int l2 = (apdu[5] & 0xFF) << 8 | apdu[6] & 0xFF;
        if (apdu.length == 7) {
            return ApduParser.doCase2e(apdu, l2, "It's a Command of CASE-2e", 65536);
        }
        if (l2 == 0) {
            throw new IllegalArgumentException("Invalid APDU: length=" + apdu.length + ", b1=" + l1 + ", b2||b3=" + l2);
        }
        if (apdu.length == 7 + l2) {
            return ApduParser.doCase3(apdu, l2, "It's a Command of CASE-3e", 7);
        }
        if (apdu.length == 9 + l2) {
            return ApduParser.doCase4e(apdu, l2);
        }
        throw new IllegalArgumentException("Invalid APDU: length=" + apdu.length + ", b1=" + l1 + ", b2||b3=" + l2);
    }

    private static CommandApdu doCase4s(byte[] apdu, int l1) {
        LOG.debug("It's a Command of CASE-4s");
        int dataOffset = 5;
        int l2 = apdu[apdu.length - 1] & 0xFF;
        int ne = l2 == 0 ? 256 : l2;
        int dataLength = l1;
        byte[] data = new byte[dataLength];
        System.arraycopy(apdu, dataOffset, data, 0, dataLength);
        return new CommandApdu(apdu[0] & 0xFF, apdu[1] & 0xFF, apdu[2] & 0xFF, apdu[3] & 0xFF, data, Integer.valueOf(ne));
    }

    private static CommandApdu doCase2e(byte[] apdu, int l2, String s, int i) {
        LOG.debug(s);
        int ne = l2 == 0 ? i : l2;
        return new CommandApdu(apdu[0] & 0xFF, apdu[1] & 0xFF, apdu[2] & 0xFF, apdu[3] & 0xFF, Integer.valueOf(ne));
    }

    private static CommandApdu doCase4e(byte[] apdu, int l2) {
        LOG.debug("It's a Command of CASE-4e");
        int dataOffset = 7;
        int leOfs = apdu.length - 2;
        int l3 = (apdu[leOfs] & 0xFF) << 8 | apdu[leOfs + 1] & 0xFF;
        int ne = l3 == 0 ? 65536 : l3;
        int dataLength = l2;
        byte[] data = new byte[dataLength];
        System.arraycopy(apdu, dataOffset, data, 0, dataLength);
        return new CommandApdu(apdu[0] & 0xFF, apdu[1] & 0xFF, apdu[2] & 0xFF, apdu[3] & 0xFF, data, Integer.valueOf(ne));
    }

    private static CommandApdu doCase3(byte[] apdu, int l1, String s, int i) {
        LOG.debug(s);
        int dataOffset = i;
        int dataLength = l1;
        byte[] data = new byte[dataLength];
        System.arraycopy(apdu, dataOffset, data, 0, dataLength);
        return new CommandApdu(apdu[0] & 0xFF, apdu[1] & 0xFF, apdu[2] & 0xFF, apdu[3] & 0xFF, data);
    }
}

