/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.openhealthcard.events.control;

import de.gematik.ti.openhealthcard.events.message.ErrorEvent;
import de.gematik.ti.openhealthcard.events.message.InfoEvent;
import de.gematik.ti.openhealthcard.events.message.WarnEvent;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.greenrobot.eventbus.EventBus;

public final class CommonEventTransmitter {
    private static String packageFilter = "de.gematik.";

    private CommonEventTransmitter() {
    }

    public static void postError(Exception exception) {
        EventBus.getDefault().post((Object)new ErrorEvent(CommonEventTransmitter.findClassName(), (Throwable)exception));
    }

    private static String findClassName() {
        Optional<StackTraceElement> stackTraceElement = Stream.of(Thread.currentThread().getStackTrace()).filter(CommonEventTransmitter.checkStackTraceElement()).findFirst();
        return stackTraceElement.isPresent() ? stackTraceElement.get().getClassName() : "CallerClassNotFound";
    }

    private static Predicate<StackTraceElement> checkStackTraceElement() {
        return element -> element.getClassName().startsWith(packageFilter) && !element.getClassName().equals(CommonEventTransmitter.class.getCanonicalName());
    }

    public static void postError(Exception exception, String message) {
        EventBus.getDefault().post((Object)new ErrorEvent(CommonEventTransmitter.findClassName(), (Throwable)exception, message));
    }

    public static void postInfo(String message) {
        EventBus.getDefault().post((Object)new InfoEvent(CommonEventTransmitter.findClassName(), message));
    }

    public static void postWarn(String message) {
        EventBus.getDefault().post((Object)new WarnEvent(CommonEventTransmitter.findClassName(), message));
    }

    public static void setPackageFilter(String packageFilter) {
        CommonEventTransmitter.packageFilter = packageFilter;
    }
}

