/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.security;

import de.gematik.ti.utils.primitives.Bytes;
import java.io.IOException;
import java.math.BigInteger;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.DERApplicationSpecific;
import org.spongycastle.math.ec.ECCurve;
import org.spongycastle.math.ec.ECPoint;

public final class Utilities {
    private static final int UNCOMPRESSEDPOINTVALUE = 4;

    private Utilities() {
    }

    public static ECPoint byteArrayToECPoint(byte[] byteArray, ECCurve curve) {
        byte[] x = new byte[(byteArray.length - 1) / 2];
        byte[] y = new byte[(byteArray.length - 1) / 2];
        if (byteArray[0] != 4) {
            throw new IllegalArgumentException("Found no uncompressed point!");
        }
        System.arraycopy(byteArray, 1, x, 0, (byteArray.length - 1) / 2);
        System.arraycopy(byteArray, 1 + (byteArray.length - 1) / 2, y, 0, (byteArray.length - 1) / 2);
        return curve.createPoint(new BigInteger(1, x), new BigInteger(1, y));
    }

    public static byte[] getKeyObjectEncoded(byte[] asn1Input) throws IOException {
        byte[] key;
        try (ASN1InputStream asn1InputStream = new ASN1InputStream(asn1Input);){
            DERApplicationSpecific seq = (DERApplicationSpecific)asn1InputStream.readObject();
            ASN1Primitive seqObj = seq.getObject();
            key = Bytes.copyByteArray((byte[])seqObj.getEncoded(), (int)2, (int)(seqObj.getEncoded().length - 2));
        }
        return key;
    }
}

