/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.security;

import de.gematik.ti.healthcard.control.exceptions.VerifyReceivedMacPiccException;
import de.gematik.ti.healthcard.control.security.KeyDerivationFunction;
import de.gematik.ti.healthcard.control.security.PaceInfo;
import de.gematik.ti.healthcard.control.security.Utilities;
import de.gematik.ti.healthcardaccess.IHealthCard;
import de.gematik.ti.healthcardaccess.cardobjects.FileIdentifier;
import de.gematik.ti.healthcardaccess.cardobjects.Key;
import de.gematik.ti.healthcardaccess.commands.GeneralAuthenticateCommand;
import de.gematik.ti.healthcardaccess.commands.ManageSecurityEnvironmentCommand;
import de.gematik.ti.healthcardaccess.commands.ReadCommand;
import de.gematik.ti.healthcardaccess.commands.SelectCommand;
import de.gematik.ti.healthcardaccess.operation.ResultOperation;
import de.gematik.ti.healthcardaccess.result.Response;
import de.gematik.ti.openhealthcard.events.response.entities.PaceKey;
import de.gematik.ti.utils.codec.Hex;
import de.gematik.ti.utils.primitives.Bytes;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.DERApplicationSpecific;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERTaggedObject;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.Mac;
import org.spongycastle.crypto.engines.AESEngine;
import org.spongycastle.crypto.macs.CMac;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.jce.ECNamedCurveTable;
import org.spongycastle.jce.spec.ECNamedCurveParameterSpec;
import org.spongycastle.math.ec.ECCurve;
import org.spongycastle.math.ec.ECPoint;

public class TrustedChannelPaceKeyExchange {
    private static final Logger LOG = LoggerFactory.getLogger(TrustedChannelPaceKeyExchange.class);
    private static final int SECRET_KEY_REFERENCE = 2;
    private static final int AES_BLOCK_SIZE = 16;
    private static final int BYTE_LENGTH = 8;
    private static final int MAX = 64;
    private static final int TAG_6 = 6;
    private static final int TAG_49 = 73;
    private final IHealthCard card;
    private final String can;
    private final PaceInfo[] paceInfo = new PaceInfo[1];
    private Mac mac;
    private ECCurve.Fp curve;
    private ECPoint ecPointG;
    private BigInteger nonceSInt;
    private BigInteger pcdSkX1;
    private BigInteger pcdSkX2;
    private byte[] kEnc;
    private byte[] kMac;
    private byte[] authTokenX;
    private SecureRandom randomGenerator;
    private PaceKey paceKey;

    public TrustedChannelPaceKeyExchange(IHealthCard card, String can) {
        this.can = can;
        this.card = card;
    }

    public ResultOperation<PaceKey> negotiatePaceKey() {
        return new SelectCommand(false, true).executeOn(this.card).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).flatMap(__ -> new SelectCommand(new FileIdentifier(284), false).executeOn(this.card)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).flatMap(__ -> new ReadCommand().executeOn(this.card).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).map(Response::getResponseData).map(cardAccessBytes -> {
            this.paceInfo[0] = new PaceInfo((byte[])cardAccessBytes);
            return this.paceInfo[0];
        })).flatMap(__ -> new ManageSecurityEnvironmentCommand(ManageSecurityEnvironmentCommand.MseUseCase.KEY_SELECTION_FOR_SYMMETRIC_CARD_CONNECTION_WITHOUT_CURVES, new Key(2), false, this.paceInfo[0].getPaceInfoProtocolBytes()).executeOn(this.card).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0))).flatMap(__ -> new GeneralAuthenticateCommand(true).executeOn(this.card)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).map(Response::getResponseData).flatMap(this::generateEphemeralPublicKeyFirstECDH).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).map(Response::getResponseData).flatMap(pk1Pcd -> new GeneralAuthenticateCommand(true, pk1Pcd, 1).executeOn(this.card)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).map(Response::getResponseData).flatMap(this::generateEphemeralPublicKeySecondECDH).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).map(Response::getResponseData).flatMap(pk2Pcd -> new GeneralAuthenticateCommand(true, pk2Pcd, 3).executeOn(this.card)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).map(Response::getResponseData).flatMap(this::createMacPcdForMutualAuthentication).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).map(Response::getResponseData).flatMap(macPcd -> new GeneralAuthenticateCommand(false, macPcd, 5).executeOn(this.card)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).map(Response::getResponseData).flatMap(this::verifyReceivedMacPicc).flatMap(aBoolean -> {
            if (aBoolean.booleanValue()) {
                return this.createPaceKey();
            }
            throw new VerifyReceivedMacPiccException();
        });
    }

    private ResultOperation<Response> generateEphemeralPublicKeyFirstECDH(byte[] nonceZBytes) {
        LOG.debug("nonceZBytes: " + Hex.encodeHexString((byte[])nonceZBytes));
        String parameter = this.paceInfo[0].getParameterIDString();
        try {
            byte[] nonceZBytesEncoded = Utilities.getKeyObjectEncoded(nonceZBytes);
            byte[] canBytes = this.can.getBytes();
            byte[] nonceS = new byte[16];
            byte[] aes128Key = KeyDerivationFunction.getAES128Key(canBytes, KeyDerivationFunction.Mode.PASSWORD);
            KeyParameter encKey = new KeyParameter(aes128Key);
            AESEngine cipher = new AESEngine();
            ECNamedCurveParameterSpec ecNamedCurveParameterSpec = ECNamedCurveTable.getParameterSpec((String)parameter);
            this.curve = (ECCurve.Fp)ecNamedCurveParameterSpec.getCurve();
            this.ecPointG = ecNamedCurveParameterSpec.getG();
            this.randomGenerator = new SecureRandom();
            Random rnd = new Random();
            this.randomGenerator.setSeed(rnd.nextLong());
            cipher.init(false, (CipherParameters)encKey);
            cipher.processBlock(nonceZBytesEncoded, 0, nonceS, 0);
            this.nonceSInt = new BigInteger(1, nonceS);
            byte[] pk1Pcd = new byte[this.curve.getFieldSize() / 8];
            this.randomGenerator.nextBytes(pk1Pcd);
            this.pcdSkX1 = new BigInteger(1, pk1Pcd);
            ECPoint pcdPkS1 = this.ecPointG.multiply(this.pcdSkX1);
            pk1Pcd = pcdPkS1.getEncoded(false);
            return ResultOperation.unitRo((Object)new Response(Response.ResponseStatus.SUCCESS, pk1Pcd));
        }
        catch (IOException e) {
            LOG.error("Failed to get encoded NonceZ " + e.getMessage());
            return ResultOperation.unitRo((Object)new Response(Response.ResponseStatus.UNKNOWN_EXCEPTION, null));
        }
    }

    private ResultOperation<Response> generateEphemeralPublicKeySecondECDH(byte[] pk1PiccBytes) {
        LOG.debug("pk1PiccBytes: " + Hex.encodeHexString((byte[])pk1PiccBytes));
        try {
            byte[] pk1PiccBytesEncoded = Utilities.getKeyObjectEncoded(pk1PiccBytes);
            ECPoint.Fp y1 = (ECPoint.Fp)Utilities.byteArrayToECPoint(pk1PiccBytesEncoded, (ECCurve)this.curve);
            ECPoint.Fp sharedSecretP = (ECPoint.Fp)y1.multiply(this.pcdSkX1);
            ECPoint pointGS = this.ecPointG.multiply(this.nonceSInt).add((ECPoint)sharedSecretP);
            byte[] x2 = new byte[this.curve.getFieldSize() / 8];
            this.randomGenerator.nextBytes(x2);
            this.pcdSkX2 = new BigInteger(1, x2);
            ECPoint pcdPkS2 = pointGS.multiply(this.pcdSkX2);
            byte[] pk2Pcd = pcdPkS2.getEncoded(false);
            ECPoint.Fp ecPointX2 = (ECPoint.Fp)Utilities.byteArrayToECPoint(pk2Pcd, (ECCurve)this.curve);
            this.authTokenX = this.createAsn1AuthToken(ecPointX2, this.paceInfo[0].getProtocolID());
            return ResultOperation.unitRo((Object)new Response(Response.ResponseStatus.SUCCESS, pk2Pcd));
        }
        catch (IOException e) {
            LOG.error("Failed to get encoded pk1PiccBytes " + e.getMessage());
            return ResultOperation.unitRo((Object)new Response(Response.ResponseStatus.KEY_INVALID, null));
        }
    }

    private ResultOperation<Response> createMacPcdForMutualAuthentication(byte[] pk2Picc) {
        LOG.debug("pk2Picc: " + Hex.encodeHexString((byte[])pk2Picc));
        try {
            String protocolID = this.paceInfo[0].getProtocolID();
            byte[] pk2PiccEncoded = Utilities.getKeyObjectEncoded(pk2Picc);
            ECPoint piccPkY2 = Utilities.byteArrayToECPoint(pk2PiccEncoded, (ECCurve)this.curve);
            ECPoint.Fp sharedSecretK = (ECPoint.Fp)piccPkY2.multiply(this.pcdSkX2);
            BigInteger sharedSekBigInt = sharedSecretK.normalize().getXCoord().toBigInteger();
            LOG.debug("BIGINT:" + sharedSekBigInt);
            byte[] sharedSecretKBytes = Bytes.bigIntToByteArray((BigInteger)sharedSecretK.normalize().getXCoord().toBigInteger());
            LOG.debug("sharedSecretKBytes: " + Hex.encodeHexString((byte[])sharedSecretKBytes));
            this.kEnc = KeyDerivationFunction.getAES128Key(sharedSecretKBytes, KeyDerivationFunction.Mode.ENC);
            this.kMac = KeyDerivationFunction.getAES128Key(sharedSecretKBytes, KeyDerivationFunction.Mode.MAC);
            AESEngine cipher = new AESEngine();
            KeyParameter keyP = new KeyParameter(this.kMac);
            this.mac = new CMac((BlockCipher)cipher, 64);
            this.mac.init((CipherParameters)keyP);
            ECPoint.Fp y2 = (ECPoint.Fp)Utilities.byteArrayToECPoint(pk2PiccEncoded, (ECCurve)this.curve);
            byte[] authTokenY = this.createAsn1AuthToken(y2, protocolID);
            byte[] macPcd = this.generateMacPcdPicc2(authTokenY);
            return ResultOperation.unitRo((Object)new Response(Response.ResponseStatus.SUCCESS, macPcd));
        }
        catch (IOException e) {
            throw new RuntimeException("Error on creating MacPcd for Mutual Authentication " + e.getMessage());
        }
    }

    private ResultOperation<Boolean> verifyReceivedMacPicc(byte[] macPiccBytes) {
        LOG.debug("macPiccBytes: " + Hex.encodeHexString((byte[])macPiccBytes));
        byte[] macPicc2 = this.generateMacPcdPicc2(this.authTokenX);
        try {
            byte[] macPicc = Utilities.getKeyObjectEncoded(macPiccBytes);
            if (Hex.encodeHexString((byte[])macPicc).equals(Hex.encodeHexString((byte[])macPicc2))) {
                return ResultOperation.unitRo((Object)true);
            }
            throw new RuntimeException("calculated macPicc does not match received macPicc");
        }
        catch (IOException e) {
            throw new RuntimeException("Error on encoding key object " + e.getMessage());
        }
    }

    private byte[] createAsn1AuthToken(ECPoint.Fp point, String protocolID) {
        ASN1EncodableVector asn1EncodableVector = new ASN1EncodableVector();
        asn1EncodableVector.add((ASN1Encodable)new ASN1ObjectIdentifier(protocolID));
        asn1EncodableVector.add((ASN1Encodable)new DERTaggedObject(false, 6, (ASN1Encodable)new DEROctetString(point.getEncoded(false))));
        byte[] authToken = new byte[]{};
        try {
            authToken = new DERApplicationSpecific(73, asn1EncodableVector).getEncoded();
        }
        catch (IOException e) {
            LOG.error("Failed to encoding ASN1 AuthToken" + e.getMessage());
        }
        return authToken;
    }

    private byte[] generateMacPcdPicc2(byte[] authToken) {
        this.mac.update(authToken, 0, authToken.length);
        byte[] key = new byte[this.mac.getMacSize()];
        this.mac.doFinal(key, 0);
        return key;
    }

    private ResultOperation<PaceKey> createPaceKey() {
        PaceKey paceKey = new PaceKey(this.kEnc, this.kMac);
        return ResultOperation.unitRo((Object)paceKey);
    }
}

