/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.security;

import de.gematik.ti.healthcard.control.CardDetector;
import de.gematik.ti.healthcard.control.security.CardAccessNumberRequester;
import de.gematik.ti.healthcard.control.security.TrustedChannelPaceKeyExchange;
import de.gematik.ti.healthcardaccess.HealthCard;
import de.gematik.ti.healthcardaccess.IHealthCard;
import de.gematik.ti.healthcardaccess.exceptions.runtime.BasicChannelException;
import de.gematik.ti.healthcardaccess.operation.Subscriber;
import de.gematik.ti.openhealthcard.events.control.RequestTransmitter;
import de.gematik.ti.openhealthcard.events.request.RequestPaceKeyEvent;
import de.gematik.ti.openhealthcard.events.response.callbacks.ICardAccessNumberResponseListener;
import de.gematik.ti.openhealthcard.events.response.entities.CardAccessNumber;
import de.gematik.ti.openhealthcard.events.response.entities.PaceKey;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedChannelConstructor
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(CardDetector.class);
    private static final String TAG = "TrustedChannelConstructor: ";
    private static final int TIMEOUT = 30;
    private final RequestPaceKeyEvent requestPaceKeyEvent;

    public TrustedChannelConstructor(RequestPaceKeyEvent requestPaceKeyEvent) {
        this.requestPaceKeyEvent = requestPaceKeyEvent;
    }

    @Override
    public void run() {
        super.run();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        CardAccessNumberRequester cardAccessNumberRequester = new CardAccessNumberRequester();
        new RequestTransmitter().requestCardAccessNumber((ICardAccessNumberResponseListener)cardAccessNumberRequester);
        Future<CardAccessNumber> future = executor.submit(cardAccessNumberRequester);
        executor.shutdown();
        CardAccessNumber cardAccessNumber = null;
        try {
            cardAccessNumber = future.get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            future.cancel(true);
        }
        if (cardAccessNumber != null) {
            try {
                HealthCard healthCard = new HealthCard(this.requestPaceKeyEvent.getCard());
                new TrustedChannelPaceKeyExchange((IHealthCard)healthCard, cardAccessNumber.getValue()).negotiatePaceKey().subscribe((Subscriber)new Subscriber<PaceKey>(){

                    public void onSuccess(PaceKey paceKey) {
                        TrustedChannelConstructor.this.requestPaceKeyEvent.getResponseListener().handlePaceKey(paceKey);
                    }

                    public void onError(Throwable t) throws RuntimeException {
                        LOG.error("PaceKey negotiation failed! " + t.getMessage());
                    }
                });
            }
            catch (BasicChannelException basic) {
                LOG.error("PaceKey negotiation failed! Broken Card-Channel" + (Object)((Object)basic));
            }
        }
    }
}

