/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.security;

import de.gematik.ti.healthcard.control.entities.PinResult;
import de.gematik.ti.healthcard.control.entities.PinType;
import de.gematik.ti.healthcard.control.exceptions.HealthcardControlRuntimeException;
import de.gematik.ti.healthcardaccess.IHealthCard;
import de.gematik.ti.healthcardaccess.IHealthCardType;
import de.gematik.ti.healthcardaccess.cardobjects.ApplicationIdentifier;
import de.gematik.ti.healthcardaccess.cardobjects.Format2Pin;
import de.gematik.ti.healthcardaccess.cardobjects.Password;
import de.gematik.ti.healthcardaccess.commands.GetPinStatusCommand;
import de.gematik.ti.healthcardaccess.commands.SelectCommand;
import de.gematik.ti.healthcardaccess.commands.VerifyCommand;
import de.gematik.ti.healthcardaccess.healthcards.Egk2;
import de.gematik.ti.healthcardaccess.healthcards.Egk21;
import de.gematik.ti.healthcardaccess.healthcards.Hba2;
import de.gematik.ti.healthcardaccess.healthcards.Hba21;
import de.gematik.ti.healthcardaccess.healthcards.HealthCardStatusValid;
import de.gematik.ti.healthcardaccess.healthcards.Smcb2;
import de.gematik.ti.healthcardaccess.healthcards.Smcb21;
import de.gematik.ti.healthcardaccess.operation.ResultOperation;
import de.gematik.ti.healthcardaccess.result.Response;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(PinVerifier.class);
    private final IHealthCard cardHc;

    public PinVerifier(IHealthCard card) {
        this.cardHc = card;
    }

    public static boolean isCardValidForVerify(IHealthCard card) {
        return card.getStatus().isValid();
    }

    public static int[] stringToIntarray(String value) {
        int[] intArray = new int[value.length()];
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isDigit(value.charAt(i))) {
                LOG.error("Contains an invalid digit");
                break;
            }
            intArray[i] = Integer.parseInt(String.valueOf(value.charAt(i)));
        }
        return intArray;
    }

    public ResultOperation<PinResult> verifyPin(int[] pinValue, PinType pinType) {
        if (PinVerifier.isCardValidForVerify(this.cardHc)) {
            HashMap<Class, RunnableFuture<ResultOperation<PinResult>>> doByClass = new HashMap<Class, RunnableFuture<ResultOperation<PinResult>>>();
            doByClass.put(Egk2.class, new FutureTask<ResultOperation>(() -> this.verifyPinEgk2(pinValue, pinType)));
            doByClass.put(Egk21.class, new FutureTask<ResultOperation>(() -> this.verifyPinEgk21(pinValue, pinType)));
            doByClass.put(Hba2.class, new FutureTask<ResultOperation>(() -> this.verifyPinCH(pinValue, pinType, 1)));
            doByClass.put(Hba21.class, new FutureTask<ResultOperation>(() -> this.verifyPinCH(pinValue, pinType, 1)));
            doByClass.put(Smcb2.class, new FutureTask<ResultOperation>(() -> this.verifyPinCH(pinValue, pinType, 1)));
            doByClass.put(Smcb21.class, new FutureTask<ResultOperation>(() -> this.verifyPinCH(pinValue, pinType, 1)));
            Class<?> cardType = ((HealthCardStatusValid)this.cardHc.getStatus()).getHealthCardType().getClass();
            ResultOperation<PinResult> result = this.getPinResultResultOperation(doByClass, cardType);
            if (result != null) {
                return result;
            }
        }
        throw new HealthcardControlRuntimeException("Card not valid for verifyPin: " + this.cardHc.getStatus().getClass().getSimpleName());
    }

    private ResultOperation<PinResult> getPinResultResultOperation(Map<Class, RunnableFuture<ResultOperation<PinResult>>> doByClass, Class<? extends IHealthCardType> cardType) {
        block4: {
            if (doByClass.containsKey(cardType)) {
                RunnableFuture<ResultOperation<PinResult>> runnable = doByClass.get(cardType);
                runnable.run();
                try {
                    Object result = runnable.get();
                    if (result != null) {
                        return (ResultOperation)result;
                    }
                    break block4;
                }
                catch (Exception e) {
                    throw new HealthcardControlRuntimeException("Execute VerifyPin for " + this.cardHc.getStatus().getClass().getSimpleName() + " failed: " + e.getLocalizedMessage());
                }
            }
            throw new HealthcardControlRuntimeException("Unknown cardType for verifyPin: " + this.cardHc.getStatus().getClass().getSimpleName());
        }
        return null;
    }

    private ResultOperation<PinResult> verifyPinCH(int[] pinValue, PinType pinType, int pwid) {
        LOG.debug("pinType {}, pwid {}", (Object)pinType, (Object)pwid);
        Password password = new Password(pwid);
        return this.getSelectRootResult().flatMap(__ -> new GetPinStatusCommand(password, false).executeOn(this.cardHc)).map(Response::getResponseStatus).map(Enum::name).map(PinResult::new).flatMap(pinResult -> new VerifyCommand(password, false, new Format2Pin(pinValue)).executeOn(this.cardHc).map(Response::getResponseStatus).map(status -> pinResult.setPinVerifiSuccess(status == Response.ResponseStatus.SUCCESS)));
    }

    private ResultOperation<Response> getSelectRootResult() {
        return new SelectCommand(false, false).executeOn(this.cardHc).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0));
    }

    private ResultOperation<Response> getSelectRootHcaResult() {
        return this.getSelectRootResult().flatMap(__ -> new SelectCommand(new ApplicationIdentifier("D27600000102")).executeOn(this.cardHc)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0));
    }

    private ResultOperation<PinResult> verifyPinEgk21(int[] pinValue, PinType pinType) {
        LOG.debug("pinType: " + (Object)((Object)pinType));
        int[] pwid = new int[]{0};
        if (pinType == PinType.PIN_CH) {
            pwid[0] = 1;
            Password password = new Password(pwid[0]);
            return this.getSelectRootResult().flatMap(__ -> new GetPinStatusCommand(password, false).executeOn(this.cardHc)).map(Response::getResponseStatus).map(Enum::name).map(PinResult::new).flatMap(pinResult -> new VerifyCommand(password, false, new Format2Pin(pinValue)).executeOn(this.cardHc).map(Response::getResponseStatus).map(status -> pinResult.setPinVerifiSuccess(status == Response.ResponseStatus.SUCCESS)));
        }
        switch (pinType) {
            case MRPIN_AMTS: {
                pwid[0] = 12;
                break;
            }
            case MRPIN_DPE: {
                pwid[0] = 4;
                break;
            }
            case MRPIN_GDD: {
                pwid[0] = 5;
                break;
            }
            case MRPIN_NFD: {
                pwid[0] = 3;
                break;
            }
            case MRPIN_NFD_READ: {
                pwid[0] = 7;
                break;
            }
            case MRPIN_OSE: {
                pwid[0] = 9;
                break;
            }
            default: {
                LOG.warn("The 'pinType' " + (Object)((Object)pinType) + "is not yet considered in process.");
            }
        }
        Password password = new Password(pwid[0]);
        return this.getSelectRootResult().flatMap(__ -> new GetPinStatusCommand(password, false).executeOn(this.cardHc)).map(Response::getResponseStatus).map(Enum::name).map(PinResult::new).flatMap(pinResult -> new VerifyCommand(password, false, new Format2Pin(pinValue)).executeOn(this.cardHc).map(Response::getResponseStatus).map(status -> pinResult.setPinVerifiSuccess(status == Response.ResponseStatus.SUCCESS)));
    }

    private ResultOperation<PinResult> verifyPinEgk2(int[] pinValue, PinType pinType) {
        LOG.debug("pinType: " + (Object)((Object)pinType));
        int[] pwid = new int[]{0};
        if (pinType == PinType.PIN_CH) {
            pwid[0] = 1;
            Password password = new Password(pwid[0]);
            return this.getSelectRootResult().flatMap(__ -> new GetPinStatusCommand(password, false).executeOn(this.cardHc)).map(Response::getResponseStatus).map(Enum::name).map(PinResult::new).flatMap(pinResult -> new VerifyCommand(password, false, new Format2Pin(pinValue)).executeOn(this.cardHc).map(Response::getResponseStatus).map(status -> pinResult.setPinVerifiSuccess(status == Response.ResponseStatus.SUCCESS)));
        }
        String[] aid = new String[]{""};
        switch (pinType) {
            case MRPIN_AMTS: {
                aid[0] = "D2760001440C";
                pwid[0] = 12;
                break;
            }
            case MRPIN_DPE: {
                aid[0] = "D27600014408";
                pwid[0] = 4;
                break;
            }
            case MRPIN_DPE_READ: {
                aid[0] = "D27600014408";
                pwid[0] = 8;
                break;
            }
            case MRPIN_GDD: {
                aid[0] = "D2760001440A";
                pwid[0] = 5;
                break;
            }
            case MRPIN_NFD: {
                aid[0] = "D27600014407";
                pwid[0] = 3;
                break;
            }
            case MRPIN_NFD_READ: {
                aid[0] = "D27600014407";
                pwid[0] = 7;
                break;
            }
            case MRPIN_OSE: {
                aid[0] = "D2760001440B";
                pwid[0] = 9;
                break;
            }
            default: {
                LOG.warn("The 'pinType' " + (Object)((Object)pinType) + "is not yet considered in process.");
            }
        }
        LOG.debug("aid: {}, pwid: {}", (Object)aid[0], (Object)pwid[0]);
        Password password = new Password(pwid[0]);
        ResultOperation pinResultResultOperation = this.getSelectRootHcaResult().flatMap(__ -> new SelectCommand(new ApplicationIdentifier(aid[0])).executeOn(this.cardHc)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).flatMap(__ -> new GetPinStatusCommand(password, true).executeOn(this.cardHc)).map(Response::getResponseStatus).map(Enum::name).map(PinResult::new).flatMap(pinResult -> new VerifyCommand(password, true, new Format2Pin(pinValue)).executeOn(this.cardHc).map(Response::getResponseStatus).map(status -> pinResult.setPinVerifiSuccess(status == Response.ResponseStatus.SUCCESS)));
        return pinResultResultOperation;
    }
}

