/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.security;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DLSet;

public class PaceInfo {
    private static final Logger LOG = LoggerFactory.getLogger(PaceInfo.class);
    private static final int PARAMETER256 = 13;
    private static final int PARAMETER384 = 16;
    private static final int PARAMETER512 = 17;
    private final byte[] cardAccess;
    private byte[] paceInfoProtocolBytes;
    private ASN1ObjectIdentifier protocol;
    private int parameterID;

    PaceInfo(byte[] cardAccess) throws IOException {
        this.cardAccess = cardAccess;
        if (cardAccess != null) {
            this.extractProtocol();
        } else {
            LOG.error("CardAccess is null");
        }
    }

    private void extractProtocol() throws IOException {
        if (this.cardAccess != null) {
            try (ASN1InputStream asn1InputStream = new ASN1InputStream(this.cardAccess);){
                DLSet app = (DLSet)asn1InputStream.readObject();
                ASN1Sequence seq = (ASN1Sequence)app.getObjectAt(0);
                this.protocol = (ASN1ObjectIdentifier)seq.getObjectAt(0);
                this.parameterID = ((ASN1Integer)seq.getObjectAt(2)).getValue().intValue();
                if (this.protocol == null) {
                    LOG.error("Protocol == null");
                } else {
                    this.paceInfoProtocolBytes = new byte[this.protocol.getEncoded().length - 2];
                    System.arraycopy(this.protocol.getEncoded(), 2, this.paceInfoProtocolBytes, 0, this.paceInfoProtocolBytes.length);
                }
            }
        }
    }

    byte[] getPaceInfoProtocolBytes() {
        return this.paceInfoProtocolBytes;
    }

    String getParameterIDString() {
        String parameter;
        switch (this.parameterID) {
            case 13: {
                parameter = "BrainpoolP256r1";
                break;
            }
            case 16: {
                parameter = "BrainpoolP384r1";
                break;
            }
            case 17: {
                parameter = "BrainpoolP512r1";
                break;
            }
            default: {
                parameter = "";
            }
        }
        return parameter;
    }

    String getProtocolID() {
        return this.protocol.getId();
    }
}

