/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.security;

import java.util.Arrays;
import org.spongycastle.crypto.digests.SHA1Digest;

public final class KeyDerivationFunction {
    private static final int CHECKSUMLENGTH = 20;
    private static final int AES128LENGTH = 16;
    private static final int OFFSETLENGTH = 4;
    private static final int ENCLASTBYTE = 1;
    private static final int MACLASTBYTE = 2;
    private static final int PASSWORDLASTBYTE = 3;

    private KeyDerivationFunction() {
    }

    public static byte[] getAES128Key(byte[] sharedSecretK, Mode mode) {
        byte[] checksum = new byte[20];
        byte[] data = KeyDerivationFunction.replaceLastKeyByte(sharedSecretK, mode);
        SHA1Digest sha1 = new SHA1Digest();
        sha1.update(data, 0, data.length);
        sha1.doFinal(checksum, 0);
        return Arrays.copyOf(checksum, 16);
    }

    private static byte[] replaceLastKeyByte(byte[] key, Mode mode) {
        byte[] keyBytes = new byte[key.length + 4];
        System.arraycopy(key, 0, keyBytes, 0, key.length);
        switch (mode) {
            case ENC: {
                keyBytes[keyBytes.length - 1] = 1;
                break;
            }
            case MAC: {
                keyBytes[keyBytes.length - 1] = 2;
                break;
            }
            case PASSWORD: {
                keyBytes[keyBytes.length - 1] = 3;
                break;
            }
            default: {
                keyBytes[keyBytes.length - 1] = 1;
            }
        }
        return keyBytes;
    }

    public static enum Mode {
        ENC,
        MAC,
        PASSWORD;

    }
}

