/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.role;

import de.gematik.ti.healthcard.control.entities.card.certificate.CertificateUtil;
import de.gematik.ti.healthcard.control.exceptions.AuthenticationCertificateException;
import de.gematik.ti.healthcard.control.exceptions.WrongRoleException;
import de.gematik.ti.healthcardaccess.operation.Result;
import de.gematik.ti.healthcardaccess.result.Response;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DLSequence;

public enum ProfessionalRole {
    VERSICHERTER,
    ARZT,
    ZAHNARZT,
    APOTHEKER,
    MITARBEITER_APOTHEKE,
    SONSTIGE_LEISTUNGSERBRINGER,
    ANDERER_HEILBERUF,
    PS_PSYCHOTHERAPEUT,
    MITARBEITER_KOSTENTRAEGER,
    PRAXIS_ARZT,
    PRAXIS_ZAHNARZT,
    PRAXIS_PSYCHOTHERAPEUT,
    KRANKENHAUS,
    OEFFENTLICHE_APOTHEKE,
    KRANKENHAUS_APOTHEKE,
    BUNDESWEHR_APOTHEKE,
    MOBILE_EINRICHTUNG_RETTUNGSDIENST,
    BS_GEMATIK,
    LEO_ZAHNAERZTE,
    ADV_KOSTENTRAEGER;

    private static final String ERROR_MESSAGE = "failed to extract profession info sequence from certificate";
    private static ASN1Encodable oid;

    public static ProfessionalRole getRole(Response response) throws IOException {
        byte[] osArray = ProfessionalRole.getExtensionValue(response.getResponseData());
        String oidString = "";
        try (ASN1InputStream asn1Source = new ASN1InputStream(osArray);){
            DEROctetString os = (DEROctetString)asn1Source.readObject().toASN1Primitive();
            byte[] octets = os.getOctets();
            try (ASN1InputStream seqSrc = new ASN1InputStream(octets);){
                DLSequence admissionsSequence = (DLSequence)seqSrc.readObject();
                Enumeration admissionsSequenceObjects = admissionsSequence.getObjects();
                DLSequence professionInfosSequence = ProfessionalRole.getPlSequence(admissionsSequenceObjects);
                ProfessionalRole.extractOid(professionInfosSequence);
                oidString = oid.toString();
            }
        }
        return ProfessionalRole.mapOID(oidString);
    }

    private static void extractOid(DLSequence professionInfosSequence) {
        if (professionInfosSequence.getObjects().nextElement() instanceof ASN1Sequence) {
            Object professionOidObject;
            DLSequence professionInfoSequence = (DLSequence)professionInfosSequence.getObjects().nextElement();
            Enumeration professionInfoObjects = professionInfoSequence.getObjects();
            while (!((professionOidObject = professionInfoObjects.nextElement()) instanceof ASN1Sequence) && professionInfoObjects.hasMoreElements()) {
            }
            if (professionOidObject instanceof ASN1Sequence) {
                DLSequence directoryStringSequence = (DLSequence)professionOidObject;
                professionInfoObjects = directoryStringSequence.getObjects();
            } else {
                throw new AuthenticationCertificateException(ERROR_MESSAGE);
            }
            while (!((professionOidObject = professionInfoObjects.nextElement()) instanceof ASN1Sequence) && professionInfoObjects.hasMoreElements()) {
            }
            if (professionOidObject instanceof ASN1Sequence) {
                DLSequence professionOidSequence = (DLSequence)professionOidObject;
                professionOidSequence = (DLSequence)professionOidSequence.getObjectAt(1);
                oid = professionOidSequence.getObjectAt(0);
            } else {
                throw new AuthenticationCertificateException(ERROR_MESSAGE);
            }
        }
    }

    private static DLSequence getPlSequence(Enumeration admissionsSequenceObjects) {
        Object professionInfoObject;
        while (!((professionInfoObject = admissionsSequenceObjects.nextElement()) instanceof ASN1Sequence) && admissionsSequenceObjects.hasMoreElements()) {
        }
        if (!(professionInfoObject instanceof ASN1Sequence)) {
            throw new AuthenticationCertificateException(ERROR_MESSAGE);
        }
        DLSequence professionInfosSequence = (DLSequence)professionInfoObject;
        return professionInfosSequence;
    }

    private static ProfessionalRole mapOID(String oidString) {
        HashMap<String, ProfessionalRole> roleMap = new HashMap<String, ProfessionalRole>();
        roleMap.put("1.2.276.0.76.4.30", ARZT);
        roleMap.put("1.2.276.0.76.4.31", ZAHNARZT);
        roleMap.put("1.2.276.0.76.4.32", APOTHEKER);
        roleMap.put("1.2.276.0.76.4.33", APOTHEKER);
        roleMap.put("1.2.276.0.76.4.34", APOTHEKER);
        roleMap.put("1.2.276.0.76.4.35", MITARBEITER_APOTHEKE);
        roleMap.put("1.2.276.0.76.4.36", MITARBEITER_APOTHEKE);
        roleMap.put("1.2.276.0.76.4.37", MITARBEITER_APOTHEKE);
        roleMap.put("1.2.276.0.76.4.38", APOTHEKER);
        roleMap.put("1.2.276.0.76.4.39", MITARBEITER_APOTHEKE);
        roleMap.put("1.2.276.0.76.4.40", MITARBEITER_APOTHEKE);
        roleMap.put("1.2.276.0.76.4.41", MITARBEITER_APOTHEKE);
        roleMap.put("1.2.276.0.76.4.42", MITARBEITER_APOTHEKE);
        roleMap.put("1.2.276.0.76.4.43", MITARBEITER_APOTHEKE);
        roleMap.put("1.2.276.0.76.4.44", MITARBEITER_APOTHEKE);
        roleMap.put("1.2.276.0.76.4.45", ARZT);
        roleMap.put("1.2.276.0.76.4.46", PS_PSYCHOTHERAPEUT);
        roleMap.put("1.2.276.0.76.4.47", PS_PSYCHOTHERAPEUT);
        roleMap.put("1.2.276.0.76.4.48", ANDERER_HEILBERUF);
        roleMap.put("1.2.276.0.76.4.49", VERSICHERTER);
        roleMap.put("1.2.276.0.76.4.178", ANDERER_HEILBERUF);
        roleMap.put("1.2.276.0.76.4.50", PRAXIS_ARZT);
        roleMap.put("1.2.276.0.76.4.51", PRAXIS_ZAHNARZT);
        roleMap.put("1.2.276.0.76.4.52", PRAXIS_PSYCHOTHERAPEUT);
        roleMap.put("1.2.276.0.76.4.53", KRANKENHAUS);
        roleMap.put("1.2.276.0.76.4.54", OEFFENTLICHE_APOTHEKE);
        roleMap.put("1.2.276.0.76.4.55", KRANKENHAUS_APOTHEKE);
        roleMap.put("1.2.276.0.76.4.56", BUNDESWEHR_APOTHEKE);
        roleMap.put("1.2.276.0.76.4.57", MOBILE_EINRICHTUNG_RETTUNGSDIENST);
        roleMap.put("1.2.276.0.76.4.58", BS_GEMATIK);
        roleMap.put("1.2.276.0.76.4.59", MITARBEITER_KOSTENTRAEGER);
        roleMap.put("1.2.276.0.76.4.187", LEO_ZAHNAERZTE);
        roleMap.put("1.2.276.0.76.4.190", ADV_KOSTENTRAEGER);
        return (ProfessionalRole)((Object)roleMap.get(oidString));
    }

    private static byte[] getExtensionValue(byte[] responseData) {
        X509Certificate cert = CertificateUtil.getCertificate(responseData);
        return cert.getExtensionValue("1.3.36.8.3.3");
    }

    public Result<ProfessionalRole> validateProfessionalRole(ProfessionalRole role) {
        if (this == role) {
            return Result.success((Object)((Object)role));
        }
        return Result.failure((Throwable)new WrongRoleException(String.format("expected role: %s, but was: %s", new Object[]{this, role})));
    }
}

