/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.healthcard.control.protocol;

import de.gematik.ti.healthcard.control.entities.card.ProtocolEntry;
import de.gematik.ti.healthcard.control.exceptions.HealthcardControlRuntimeException;
import de.gematik.ti.healthcardaccess.IHealthCard;
import de.gematik.ti.healthcardaccess.cardobjects.ApplicationIdentifier;
import de.gematik.ti.healthcardaccess.cardobjects.FileIdentifier;
import de.gematik.ti.healthcardaccess.cardobjects.ShortFileIdentifier;
import de.gematik.ti.healthcardaccess.commands.AppendRecordCommand;
import de.gematik.ti.healthcardaccess.commands.SelectCommand;
import de.gematik.ti.healthcardaccess.healthcards.Egk2;
import de.gematik.ti.healthcardaccess.healthcards.Egk21;
import de.gematik.ti.healthcardaccess.healthcards.HealthCardStatusValid;
import de.gematik.ti.healthcardaccess.operation.ResultOperation;
import de.gematik.ti.healthcardaccess.result.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolWriter.class);
    private final IHealthCard cardEgkHc;
    private final ResultOperation<Response> responseResultOperation;
    private FileIdentifier efLoggingFid;
    private ShortFileIdentifier efLoggingSfid;
    private ApplicationIdentifier dfHcaAid;

    public ProtocolWriter(IHealthCard cardEgkHc) {
        this.initFileReference(cardEgkHc);
        this.cardEgkHc = cardEgkHc;
        this.responseResultOperation = new SelectCommand(this.dfHcaAid).executeOn(cardEgkHc).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)).flatMap(__ -> new SelectCommand(this.efLoggingFid, false).executeOn(cardEgkHc).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0)));
    }

    private void initFileReference(IHealthCard cardHc) {
        if (cardHc.getStatus().isValid() && ((HealthCardStatusValid)cardHc.getStatus()).getHealthCardType() instanceof Egk2) {
            this.efLoggingFid = new FileIdentifier(53254);
            this.efLoggingSfid = new ShortFileIdentifier(6);
            this.dfHcaAid = new ApplicationIdentifier("D27600000102");
        } else if (cardHc.getStatus().isValid() && ((HealthCardStatusValid)cardHc.getStatus()).getHealthCardType() instanceof Egk21) {
            this.efLoggingFid = new FileIdentifier(53254);
            this.efLoggingSfid = new ShortFileIdentifier(6);
            this.dfHcaAid = new ApplicationIdentifier("D27600000102");
        } else {
            throw new HealthcardControlRuntimeException("Cardtype " + ((HealthCardStatusValid)cardHc.getStatus()).getHealthCardType() + " is invalid or unknown");
        }
    }

    public ResultOperation write(ProtocolEntry protocolEntry) {
        LOG.debug(protocolEntry.toString());
        ResultOperation resultOp = this.responseResultOperation.flatMap(__ -> new AppendRecordCommand(this.efLoggingSfid, protocolEntry.getRecord()).executeOn(this.cardEgkHc)).validate(arg_0 -> ((Response.ResponseStatus)Response.ResponseStatus.SUCCESS).validateResult(arg_0));
        return resultOp;
    }
}

